/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.stats;

import fr.neatmonster.nocheatplus.utilities.ds.corw.LinkedHashMapCOW;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters {
    private final Map<String, Integer> idMap = new LinkedHashMapCOW<String, Integer>();
    private String[] keys = new String[0];
    private CountEntry[] ptCounts = new CountEntry[0];
    private CountEntry[] syCounts = new CountEntry[0];
    private ReentrantLock[] syLocks = new ReentrantLock[0];
    private final ReentrantLock globalLock = new ReentrantLock();

    public int registerKey(String key) {
        int newId;
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        Integer registeredId = this.idMap.get(key);
        if (registeredId != null) {
            return registeredId;
        }
        this.globalLock.lock();
        if (this.idMap.containsKey(key)) {
            newId = this.idMap.get(key);
        } else {
            newId = this.keys.length;
            this.ptCounts = Arrays.copyOf(this.ptCounts, newId + 1);
            this.ptCounts[newId] = new CountEntry();
            this.syCounts = Arrays.copyOf(this.syCounts, newId + 1);
            this.syCounts[newId] = new CountEntry();
            this.syLocks = Arrays.copyOf(this.syLocks, newId + 1);
            this.syLocks[newId] = null;
            String[] newKeys = Arrays.copyOf(this.keys, newId + 1);
            newKeys[newId] = key;
            this.keys = newKeys;
            this.idMap.put(key, newId);
        }
        this.globalLock.unlock();
        return newId;
    }

    public void add(int id, int count) {
        if (Bukkit.isPrimaryThread()) {
            this.addPrimaryThread(id, count);
        } else {
            this.addSynchronized(id, count);
        }
    }

    public void addPrimaryThread(int id, int count) {
        ++this.ptCounts[id].count;
    }

    public void addSynchronized(int id, int count) {
        ReentrantLock lock = this.syLocks[id];
        if (lock == null) {
            this.addLock(id);
            lock = this.syLocks[id];
        }
        lock.lock();
        this.syCounts[id].count += count;
        lock.unlock();
    }

    private void addLock(int id) {
        this.globalLock.lock();
        if (this.syLocks[id] == null) {
            this.syLocks[id] = new ReentrantLock();
        }
        this.globalLock.unlock();
    }

    public void resetAll() {
        int i;
        this.globalLock.lock();
        for (i = 0; i < this.ptCounts.length; ++i) {
            this.ptCounts[i] = new CountEntry();
        }
        for (i = 0; i < this.syCounts.length; ++i) {
            this.syCounts[i] = new CountEntry();
        }
        this.globalLock.unlock();
    }

    public Map<String, Integer> getPrimaryThreadCounts() {
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            counts.put(this.keys[i], this.ptCounts[i].count);
        }
        return counts;
    }

    public Map<String, Integer> getSynchronizedCounts() {
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            counts.put(this.keys[i], this.syCounts[i].count);
        }
        return counts;
    }

    public Map<String, Integer> getMergedCounts() {
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            counts.put(this.keys[i], this.syCounts[i].count + this.ptCounts[i].count);
        }
        return counts;
    }

    public String getMergedCountsString() {
        return this.getMergedCountsString(false);
    }

    public String getMergedCountsString(boolean details) {
        StringBuilder builder = new StringBuilder(1024);
        Map<String, Integer> syCounts = this.getSynchronizedCounts();
        Map<String, Integer> ptCounts = this.getPrimaryThreadCounts();
        builder.append('|');
        for (Map.Entry<String, Integer> entry : ptCounts.entrySet()) {
            String key = entry.getKey();
            builder.append(' ');
            builder.append(key);
            builder.append(' ');
            int pt = entry.getValue();
            int sy = syCounts.get(key);
            int sum = pt + sy;
            builder.append(Integer.toString(sum));
            if (details && sum > 0) {
                builder.append(" (");
                builder.append(Integer.toString(pt));
                builder.append('/');
                builder.append(Integer.toString(sy));
                builder.append(')');
            }
            builder.append(" |");
        }
        return builder.toString();
    }

    private static final class CountEntry {
        public int count = 0;

        private CountEntry() {
        }
    }
}

