/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.debug;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.Location;

public class DebugUtil {
    public static String formatLocation(Location loc) {
        StringBuilder b = new StringBuilder(128);
        DebugUtil.addLocation(loc, b);
        return b.toString();
    }

    public static String formatMove(Location from, Location to) {
        StringBuilder builder = new StringBuilder(128);
        DebugUtil.addMove(from, to, null, builder);
        return builder.toString();
    }

    public static void addLocation(double x, double y, double z, StringBuilder builder) {
        builder.append(x + ", " + y + ", " + z);
    }

    public static void addLocation(Location loc, StringBuilder builder) {
        DebugUtil.addLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addLocation(PlayerLocation loc, StringBuilder builder) {
        DebugUtil.addLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addFormattedLocation(double x, double y, double z, StringBuilder builder) {
        builder.append(StringUtil.fdec3.format(x) + ", " + StringUtil.fdec3.format(y) + ", " + StringUtil.fdec3.format(z));
    }

    public static void addFormattedLocation(Location loc, StringBuilder builder) {
        DebugUtil.addFormattedLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addFormattedLocation(PlayerLocation loc, StringBuilder builder) {
        DebugUtil.addFormattedLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addMove(double fromX, double fromY, double fromZ, double toX, double toY, double toZ, StringBuilder builder) {
        builder.append("from: ");
        DebugUtil.addLocation(fromX, fromY, fromZ, builder);
        builder.append("\nto: ");
        DebugUtil.addLocation(toX, toY, toZ, builder);
    }

    public static void addFormattedMove(double fromX, double fromY, double fromZ, double toX, double toY, double toZ, StringBuilder builder) {
        DebugUtil.addFormattedLocation(fromX, fromY, fromZ, builder);
        builder.append(" -> ");
        DebugUtil.addFormattedLocation(toX, toY, toZ, builder);
    }

    public static void addFormattedMove(PlayerLocation from, PlayerLocation to, Location loc, StringBuilder builder) {
        if (loc != null && !from.isSamePos(loc)) {
            builder.append("(");
            DebugUtil.addFormattedLocation(loc, builder);
            builder.append(") ");
        }
        DebugUtil.addFormattedMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addMove(PlayerLocation from, PlayerLocation to, Location loc, StringBuilder builder) {
        if (loc != null && !from.isSamePos(loc)) {
            builder.append("Location: ");
            DebugUtil.addLocation(loc, builder);
            builder.append("\n");
        }
        DebugUtil.addMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addFormattedMove(Location from, Location to, Location loc, StringBuilder builder) {
        if (loc != null && !TrigUtil.isSamePos(from, loc)) {
            builder.append("(");
            DebugUtil.addFormattedLocation(loc, builder);
            builder.append(") ");
        }
        DebugUtil.addFormattedMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addMove(Location from, Location to, Location loc, StringBuilder builder) {
        if (loc != null && !TrigUtil.isSamePos(from, loc)) {
            builder.append("Location: ");
            DebugUtil.addLocation(loc, builder);
            builder.append("\n");
        }
        DebugUtil.addMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addBlockBelowInfo(StringBuilder builder, PlayerLocation loc, String tag) {
        DebugUtil.addBlockInfo(builder, loc.getBlockCache(), loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ(), tag + " below");
    }

    public static void addBlockInfo(StringBuilder builder, PlayerLocation loc, String tag) {
        DebugUtil.addBlockInfo(builder, loc.getBlockCache(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), tag);
    }

    public static void addBlockInfo(StringBuilder builder, BlockCache blockCache, int x, int y, int z, String messagePrefix) {
        if (messagePrefix != null && !messagePrefix.isEmpty()) {
            builder.append(messagePrefix);
        }
        builder.append(" id=");
        int id = blockCache.getTypeId(x, y, z);
        builder.append(id);
        builder.append(" data=");
        builder.append(blockCache.getData(x, y, z));
        double[] bounds = blockCache.getBounds(x, y, z);
        double minHeight = BlockProperties.getGroundMinHeight(blockCache, x, y, z, id, bounds, BlockProperties.getBlockFlags(id));
        builder.append(" shape=[");
        builder.append(bounds[0]);
        builder.append(", ");
        builder.append(bounds[1]);
        builder.append(", ");
        builder.append(bounds[2]);
        builder.append(", ");
        builder.append(bounds[3]);
        builder.append(", ");
        builder.append(minHeight == bounds[4] ? Double.valueOf(minHeight) : minHeight + ".." + bounds[4]);
        builder.append(", ");
        builder.append(bounds[5]);
        builder.append("]");
    }

    public static boolean debug(String message, boolean returnValue) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, message);
        return returnValue;
    }

    public static void debug(String message) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, message);
    }

    public static String toJava(double[] doubles) {
        StringBuilder builder = new StringBuilder(20 + doubles.length * 20);
        DebugUtil.toJava(doubles, builder);
        return builder.toString();
    }

    public static void toJava(double[] doubles, StringBuilder builder) {
        if (doubles == null) {
            builder.append("null");
            return;
        }
        builder.append("new double[] {");
        if (doubles.length > 0) {
            builder.append(doubles[0]);
        }
        for (int i = 1; i < doubles.length; ++i) {
            builder.append(", " + doubles[i]);
        }
        builder.append("}");
    }
}

