/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.actions.ActionFactory;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.DefaultConfig;
import fr.neatmonster.nocheatplus.config.PathUtils;
import fr.neatmonster.nocheatplus.config.WorldConfigProvider;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static ActionFactoryFactory actionFactoryFactory = new ActionFactoryFactory(){

        @Override
        public final ActionFactory newActionFactory(Map<String, Object> library) {
            return new ActionFactory(library);
        }
    };
    private static Map<String, ConfigFile> worldsMap = new LinkedHashMap<String, ConfigFile>();
    private static final WorldConfigProvider<ConfigFile> worldConfigProvider = new WorldConfigProvider<ConfigFile>(){

        @Override
        public ConfigFile getDefaultConfig() {
            return ConfigManager.getConfigFile();
        }

        @Override
        public ConfigFile getConfig(String worldName) {
            return ConfigManager.getConfigFile(worldName);
        }

        @Override
        public Collection<ConfigFile> getAllConfigs() {
            return worldsMap.values();
        }
    };
    private static boolean isInitialized = false;

    public static ActionFactory getActionFactory(Map<String, Object> library) {
        return actionFactoryFactory.newActionFactory(library);
    }

    public static void setActionFactoryFactory(ActionFactoryFactory factory) {
        actionFactoryFactory = factory != null ? factory : new ActionFactoryFactory(){

            @Override
            public final ActionFactory newActionFactory(Map<String, Object> library) {
                return new ActionFactory(library);
            }
        };
        for (ConfigFile config : worldsMap.values()) {
            config.setActionFactory(null);
        }
    }

    public static ActionFactoryFactory getActionFactoryFactory() {
        return actionFactoryFactory;
    }

    public static void setAllActionFactories() {
        for (ConfigFile config : worldsMap.values()) {
            config.setActionFactory();
        }
    }

    public static WorldConfigProvider<ConfigFile> getWorldConfigProvider() {
        return worldConfigProvider;
    }

    public static void cleanup() {
        isInitialized = false;
        ConfigManager.setActionFactoryFactory(null);
    }

    public static ConfigFile getConfigFile() {
        return worldsMap.get(null);
    }

    @Deprecated
    public static synchronized ConfigFile getConfigFileSync() {
        return ConfigManager.getConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigFile getConfigFile(String worldName) {
        ConfigFile configFile = worldsMap.get(worldName);
        if (configFile != null) {
            return configFile;
        }
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (worldsMap.containsKey(worldName)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return worldsMap.get(worldName);
            }
            LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>(worldsMap);
            ConfigFile globalConfig = (ConfigFile)((Object)newWorldsMap.get(null));
            newWorldsMap.put(worldName, globalConfig);
            worldsMap = newWorldsMap;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return globalConfig;
        }
    }

    @Deprecated
    public static synchronized ConfigFile getConfigFileSync(String worldName) {
        return ConfigManager.getConfigFile(worldName);
    }

    public static synchronized void init(Plugin plugin) {
        LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>();
        File globalFile = new File(plugin.getDataFolder(), "config.yml");
        PathUtils.processPaths(globalFile, "global config", false);
        ConfigFile globalConfig = new ConfigFile();
        globalConfig.setDefaults((Configuration)new DefaultConfig());
        globalConfig.options().copyDefaults(true);
        if (globalFile.exists()) {
            try {
                globalConfig.load(globalFile);
                try {
                    if (globalConfig.getBoolean("savebackconfig")) {
                        if (!globalConfig.contains("configversion.created")) {
                            globalConfig.set("configversion.created", 785);
                        }
                        globalConfig.set("configversion.saved", 785);
                        globalConfig.save(globalFile);
                    }
                }
                catch (Exception e) {
                    StaticLog.logSevere("Could not save back config.yml (see exception below).");
                    StaticLog.logSevere(e);
                }
            }
            catch (Exception e) {
                StaticLog.logSevere("Could not load config.yml (see exception below).  Continue with default settings...");
                StaticLog.logSevere(e);
            }
        } else {
            globalConfig.options().header("This configuration was auto-generated by NoCheatPlus.");
            globalConfig.options().copyHeader(true);
            try {
                globalConfig.set("configversion.created", 785);
                globalConfig.set("configversion.saved", 785);
                globalConfig.save(globalFile);
            }
            catch (Exception e) {
                StaticLog.logSevere(e);
            }
        }
        newWorldsMap.put(null, globalConfig);
        MemoryConfiguration worldDefaults = PathUtils.getWorldsDefaultConfig((MemoryConfiguration)globalConfig);
        HashMap<String, File> worldFiles = new HashMap<String, File>();
        if (plugin.getDataFolder().isDirectory()) {
            for (File file : plugin.getDataFolder().listFiles()) {
                String fileName;
                if (!file.isFile() || !(fileName = file.getName()).matches(".+_config.yml$")) continue;
                String worldname = fileName.substring(0, fileName.length() - 11);
                worldFiles.put(worldname, file);
            }
        }
        for (Map.Entry worldEntry : worldFiles.entrySet()) {
            File worldFile = (File)worldEntry.getValue();
            PathUtils.processPaths(worldFile, "world " + (String)worldEntry.getKey(), true);
            ConfigFile worldConfig = new ConfigFile();
            worldConfig.setDefaults((Configuration)worldDefaults);
            worldConfig.options().copyDefaults(true);
            try {
                worldConfig.load(worldFile);
                newWorldsMap.put((String)worldEntry.getKey(), worldConfig);
                try {
                    if (worldConfig.getBoolean("savebackconfig")) {
                        worldConfig.save(worldFile);
                    }
                }
                catch (Exception e) {
                    StaticLog.logSevere("Couldn't save back world-specific configuration for " + (String)worldEntry.getKey() + " (see exception below).");
                    StaticLog.logSevere(e);
                }
            }
            catch (Exception e) {
                StaticLog.logSevere("Couldn't load world-specific configuration for " + (String)worldEntry.getKey() + " (see exception below). Continue with global default settings...");
                StaticLog.logSevere(e);
            }
            worldConfig.setDefaults((Configuration)globalConfig);
            worldConfig.options().copyDefaults(true);
        }
        worldsMap = newWorldsMap;
        isInitialized = true;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static synchronized void setForAllConfigs(String path, Object value) {
        LinkedHashMap<String, ConfigFile> newWorldsMap = new LinkedHashMap<String, ConfigFile>(worldsMap);
        for (ConfigFile cfg : newWorldsMap.values()) {
            cfg.set(path, value);
        }
        worldsMap = newWorldsMap;
    }

    public static boolean isTrueForAnyConfig(String path) {
        for (ConfigFile cfg : worldsMap.values()) {
            if (!cfg.getBoolean(path, false)) continue;
            return true;
        }
        return false;
    }

    public static Double getMaxNumberForAllConfigs(String path) {
        Number max = null;
        for (ConfigFile config : worldsMap.values()) {
            try {
                Object obj = config.get(path);
                if (!(obj instanceof Number)) continue;
                Number num = (Number)obj;
                if (max != null && !(num.doubleValue() > max.doubleValue())) continue;
                max = num;
            }
            catch (Throwable throwable) {}
        }
        return max.doubleValue();
    }

    public static Double getMinNumberForAllConfigs(String path) {
        Number min = null;
        for (ConfigFile config : worldsMap.values()) {
            try {
                Object obj = config.get(path);
                if (!(obj instanceof Number)) continue;
                Number num = (Number)obj;
                if (min != null && !(num.doubleValue() < min.doubleValue())) continue;
                min = num;
            }
            catch (Throwable throwable) {}
        }
        return min.doubleValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ActionFactoryFactory {
        public ActionFactory newActionFactory(Map<String, Object> var1);
    }
}

