/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.hooks.NCPHook;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionCommand
extends BaseCommand {
    public VersionCommand(JavaPlugin plugin) {
        super(plugin, "version", "nocheatplus.command.version", new String[]{"versions", "ver"});
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        List<String> lines = VersionCommand.getVersionInfo();
        sender.sendMessage(lines.toArray(new String[lines.size()]));
        return true;
    }

    public static List<String> getVersionInfo() {
        Collection<NCPHook> hooks;
        LinkedList<String> lines = new LinkedList<String>();
        MCAccess mcAccess = NCPAPIProvider.getNoCheatPlusAPI().getMCAccess();
        lines.addAll(Arrays.asList("---- Version information ----", "#### Server ####", VersionCommand.alt(Bukkit.getServer().getVersion()), "  detected: " + VersionCommand.alt(ServerVersion.getMinecraftVersion()), "#### NoCheatPlus ####", "Plugin: " + VersionCommand.alt(Bukkit.getPluginManager().getPlugin("NoCheatPlus").getDescription().getVersion()), "MCAccess: " + VersionCommand.alt(mcAccess.getMCVersion() + " / " + mcAccess.getServerVersionTag())));
        Map<String, Set<String>> featureTags = NCPAPIProvider.getNoCheatPlusAPI().getAllFeatureTags();
        if (!featureTags.isEmpty()) {
            LinkedList<String> features = new LinkedList<String>();
            for (Map.Entry<String, Set<String>> entry : featureTags.entrySet()) {
                features.add(VersionCommand.alt("  " + entry.getKey() + ": " + StringUtil.join((Collection)entry.getValue(), " | ")));
            }
            Collections.sort(features, String.CASE_INSENSITIVE_ORDER);
            features.add(0, "Features:");
            lines.addAll(features);
        }
        if (!(hooks = NCPHookManager.getAllHooks()).isEmpty()) {
            LinkedList<String> fullNames = new LinkedList<String>();
            for (NCPHook hook : hooks) {
                fullNames.add(VersionCommand.alt(hook.getHookName() + " " + hook.getHookVersion()));
            }
            Collections.sort(fullNames, String.CASE_INSENSITIVE_ORDER);
            lines.add("Hooks: " + StringUtil.join(fullNames, " | "));
        }
        LinkedList<String> relatedPlugins = new LinkedList<String>();
        for (String name : new String[]{"CompatNoCheatPlus", "ProtocolLib"}) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
            if (plugin == null) continue;
            relatedPlugins.add(VersionCommand.alt(plugin.getDescription().getFullName()));
        }
        if (!relatedPlugins.isEmpty()) {
            lines.add("#### Related Plugins ####");
            lines.add(StringUtil.join(relatedPlugins, " | "));
        }
        return lines;
    }

    private static String alt(String x) {
        return x.replace('(', '~').replace(')', '~');
    }
}

