/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.CountableLocation;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class OutgoingPosition
extends BaseAdapter {
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;
    private final Integer ID_OUTGOING_POSITION_UNTRACKED;

    public OutgoingPosition(Plugin plugin) {
        super(plugin, ListenerPriority.HIGHEST, PacketType.Play.Server.POSITION);
        this.ID_OUTGOING_POSITION_UNTRACKED = this.counters.registerKey("packet.outgoing_position.untracked");
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (this.configFactory.getConfig((Player)player).flyingFrequencyActive) {
            this.interpretPacket(player, event.getPacket(), time, this.dataFactory.getData(player));
        }
    }

    private void interpretPacket(Player player, PacketContainer packet, long time, NetData data) {
        float pitch;
        float yaw;
        double z;
        double y;
        StructureModifier doubles = packet.getDoubles();
        StructureModifier floats = packet.getFloat();
        if (doubles.size() != 3 || floats.size() != 2) {
            this.packetMismatch(packet);
            return;
        }
        double x = (Double)doubles.read(0);
        CountableLocation packetData = data.teleportQueue.onOutgoingTeleport(x, y = ((Double)doubles.read(1)).doubleValue(), z = ((Double)doubles.read(2)).doubleValue(), yaw = ((Float)floats.read(0)).floatValue(), pitch = ((Float)floats.read(1)).floatValue());
        if (packetData == null) {
            this.counters.add(this.ID_OUTGOING_POSITION_UNTRACKED, 1);
            if (data.debug) {
                this.debug(player, "Untracked outgoing position: " + x + ", " + y + ", " + z + " (yaw=" + yaw + ", pitch=" + pitch + ").");
            }
        } else if (data.debug) {
            this.debug(player, "Expect ACK on outgoing position: " + packetData);
        }
    }

    private void packetMismatch(PacketContainer packet) {
    }
}

