/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.util;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;

public class MovingUtil {
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public static final boolean shouldCheckSurvivalFly(Player player, MovingData data, MovingConfig cc) {
        GameMode gameMode = player.getGameMode();
        return !(!cc.survivalFlyCheck || gameMode == BridgeMisc.GAME_MODE_SPECTATOR || NCPExemptionManager.isExempted(player, CheckType.MOVING_SURVIVALFLY) || player.hasPermission("nocheatplus.checks.moving.survivalfly") || !cc.ignoreCreative && gameMode == GameMode.CREATIVE || player.isFlying() || !cc.ignoreAllowFlight && player.getAllowFlight());
    }

    public static void handleIllegalMove(PlayerMoveEvent event, Player player, MovingData data, MovingConfig cc) {
        boolean restored = false;
        PlayerLocation pLoc = new PlayerLocation(NCPAPIProvider.getNoCheatPlusAPI().getMCAccess(), null);
        Location loc = player.getLocation();
        if (!restored && data.hasSetBack()) {
            Location setBack = data.getSetBack(loc);
            pLoc.set(setBack, player);
            if (!(pLoc.hasIllegalCoords() || !cc.ignoreStance && pLoc.hasIllegalStance())) {
                event.setFrom(setBack);
                event.setTo(setBack);
                restored = true;
            } else {
                data.resetSetBack();
            }
        }
        if (!restored) {
            pLoc.set(loc, player);
            if (!(pLoc.hasIllegalCoords() || !cc.ignoreStance && pLoc.hasIllegalStance())) {
                event.setFrom(loc);
                event.setTo(loc);
                restored = true;
            }
        }
        pLoc.cleanup();
        if (!restored) {
            if (cc.tempKickIllegal) {
                NCPAPIProvider.getNoCheatPlusAPI().denyLogin(player.getName(), 86400000L);
                StaticLog.logSevere("[NCP] could not restore location for " + player.getName() + ", kicking them and deny login for 24 hours");
            } else {
                StaticLog.logSevere("[NCP] could not restore location for " + player.getName() + ", kicking them.");
            }
            CheckUtils.kickIllegalMove(player);
        }
    }

    public static boolean canJumpOffTop(Material blockType) {
        return BlockProperties.isGround(blockType) || BlockProperties.isSolid(blockType);
    }

    public static boolean shouldCheckUntrackedLocation(Player player, Location loc) {
        return !TrigUtil.isSamePos(loc, loc.getWorld().getSpawnLocation()) && !BlockProperties.isPassable(loc) && CheckType.MOVING_PASSABLE.isEnabled(player);
    }

    public static Location checkUntrackedLocation(Location loc) {
        Chunk toChunk = loc.getChunk();
        Entity[] entities = toChunk.getEntities();
        MovingData untrackedData = null;
        for (int i = 0; i < entities.length; ++i) {
            Location refLoc;
            Entity entity = entities[i];
            if (entity.getType() != EntityType.PLAYER || !TrigUtil.isSamePos(loc, refLoc = entity.getLocation(useLoc)) || !(entity instanceof Player)) continue;
            Player other = (Player)entity;
            MovingData otherData = MovingData.getData(other);
            MoveData otherLastMove = otherData.moveData.getFirst();
            if (!otherLastMove.toIsValid) continue;
            if (TrigUtil.isSamePos(refLoc, otherLastMove.to.x, otherLastMove.to.y, otherLastMove.to.z)) {
                return null;
            }
            if (TrigUtil.isSameBlock(loc, otherLastMove.to.x, otherLastMove.to.y, otherLastMove.to.z) && !BlockProperties.isPassable(refLoc.getWorld(), otherLastMove.to.x, otherLastMove.to.y, otherLastMove.to.z)) continue;
            untrackedData = otherData;
        }
        useLoc.setWorld(null);
        if (untrackedData == null) {
            return null;
        }
        MoveData lastMove = untrackedData.moveData.getFirst();
        return new Location(loc.getWorld(), lastMove.to.x, lastMove.to.y, lastMove.to.z, loc.getYaw(), loc.getPitch());
    }

    public static double getRealisticFallDistance(Player player, double fromY, double toY, MovingData data) {
        if (CheckType.MOVING_NOFALL.isEnabled(player)) {
            if (data.noFallMaxY >= fromY) {
                return Math.max(0.0, data.noFallMaxY - toY);
            }
            return Math.max(0.0, fromY - toY);
        }
        return (double)player.getFallDistance() + Math.max(0.0, fromY - toY);
    }
}

