/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import fr.neatmonster.nocheatplus.utilities.PlayerLocation;

public class LocationData {
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    public boolean extraPropertiesValid = false;
    public boolean onClimbable;
    public boolean inWeb;
    public boolean inLava;
    public boolean inWater;
    public boolean inLiquid;
    public boolean onGround;
    public boolean resetCond;
    public boolean onGroundOrResetCond;

    public void set(LocationData other) {
        this.setLocation(other.x, other.y, other.z, other.yaw, other.pitch);
        this.setExtraProperties(other);
    }

    public void set(PlayerLocation loc) {
        this.setLocation(loc);
        this.setExtraProperties(loc);
    }

    public void setLocation(PlayerLocation loc) {
        this.setLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public void setLocation(double x, double y, double z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setExtraProperties(PlayerLocation loc) {
        loc.collectBlockFlags();
        this.onClimbable = loc.isOnClimbable();
        this.inWeb = loc.isInWeb();
        this.inLiquid = loc.isInLiquid();
        if (this.inLiquid) {
            this.inLava = loc.isInLava();
            this.inWater = loc.isInWater();
        } else {
            this.inWater = false;
            this.inLava = false;
        }
        this.onGround = loc.isOnGround();
        this.resetCond = this.inLiquid || this.inWeb || this.onClimbable;
        this.onGroundOrResetCond = this.onGround || this.resetCond;
        this.extraPropertiesValid = true;
    }

    public void setExtraProperties(LocationData other) {
        if (other.extraPropertiesValid) {
            this.onClimbable = other.onClimbable;
            this.inWeb = other.inWeb;
            this.inLiquid = other.inLiquid;
            this.inLava = other.inLava;
            this.inWater = other.inWater;
            this.onGround = other.onGround;
            this.resetCond = other.resetCond;
            this.onGroundOrResetCond = other.onGroundOrResetCond;
        }
        this.extraPropertiesValid = other.extraPropertiesValid;
    }

    public void resetExtraProperties() {
        this.extraPropertiesValid = false;
        this.onClimbable = false;
        this.inWeb = false;
        this.inLiquid = false;
        this.inLava = false;
        this.inWater = false;
        this.onGround = false;
        this.resetCond = false;
        this.onGroundOrResetCond = false;
    }
}

