/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class FastConsume
extends Check
implements Listener {
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("canceldead");

    public static void testAvailability() {
        if (!PlayerItemConsumeEvent.class.getSimpleName().equals("PlayerItemConsumeEvent")) {
            throw new RuntimeException("This exception should not even get thrown.");
        }
    }

    public FastConsume() {
        super(CheckType.INVENTORY_FASTCONSUME);
        ConfigManager.setForAllConfigs("checks.inventory.instanteat.active", false);
        StaticLog.logInfo("Inventory checks: FastConsume is available, disabled InstantEat.");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        if (!this.isEnabled(player)) {
            return;
        }
        InventoryData data = InventoryData.getData(player);
        long time = System.currentTimeMillis();
        if (this.check(player, event.getItem(), time, data)) {
            event.setCancelled(true);
            DataManager.getPlayerData((String)player.getName(), (boolean)true).task.updateInventory();
        }
    }

    private boolean check(Player player, ItemStack stack, long time, InventoryData data) {
        ItemStack actualStack;
        Material mat;
        long ref;
        if (stack == null) {
            return false;
        }
        long l = ref = data.instantEatInteract == 0L ? 0L : Math.max(data.instantEatInteract, data.lastClickTime);
        if (time < ref) {
            data.instantEatInteract = data.lastClickTime = time;
            return false;
        }
        InventoryConfig cc = InventoryConfig.getConfig(player);
        Material material = mat = stack == null ? null : stack.getType();
        if (mat != null && (cc.fastConsumeWhitelist ? !cc.fastConsumeItems.contains(mat) : cc.fastConsumeItems.contains(mat))) {
            return false;
        }
        long timeSpent = ref == 0L ? 0L : time - ref;
        long expectedDuration = cc.fastConsumeDuration;
        boolean cancel = false;
        if (timeSpent < expectedDuration) {
            float lag = TickTask.getLag(expectedDuration, true);
            if ((float)timeSpent * lag < (float)expectedDuration) {
                double difference = (double)((float)expectedDuration - (float)timeSpent * lag) / 100.0;
                data.instantEatVL += difference;
                ViolationData vd = new ViolationData(this, player, data.instantEatVL, difference, cc.fastConsumeActions);
                vd.setParameter(ParameterName.FOOD, "" + mat);
                if (data.instantEatFood != mat) {
                    vd.setParameter(ParameterName.TAGS, "inconsistent(" + data.instantEatFood + ")");
                } else {
                    vd.setParameter(ParameterName.TAGS, "");
                }
                if (this.executeActions(vd)) {
                    cancel = true;
                }
            }
        } else {
            data.instantEatVL *= 0.6;
        }
        data.instantEatFood = cancel ? ((actualStack = player.getItemInHand()) == null ? null : actualStack.getType()) : null;
        data.instantEatInteract = time;
        return cancel;
    }
}

