/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.combined;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.combined.MunchHausen;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;

public class CombinedListener
extends CheckListener {
    protected final Improbable improbable = this.addCheck(new Improbable());
    protected final MunchHausen munchHausen = this.addCheck(new MunchHausen());
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idFakeInvulnerable = this.counters.registerKey("fakeinvulnerable");

    public CombinedListener() {
        super(CheckType.COMBINED);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        int invulnerableTicks;
        Player player = event.getPlayer();
        CombinedData data = CombinedData.getData(player);
        CombinedConfig cc = CombinedConfig.getConfig(player);
        if (cc.invulnerableCheck && (cc.invulnerableTriggerAlways || cc.invulnerableTriggerFallDistance && player.getFallDistance() > 0.0f) && (invulnerableTicks = this.mcAccess.getInvulnerableTicks(player)) != Integer.MAX_VALUE) {
            int ticks = cc.invulnerableInitialTicksJoin >= 0 ? cc.invulnerableInitialTicksJoin : invulnerableTicks;
            data.invulnerableTick = TickTask.getTick() + ticks;
            this.mcAccess.setInvulnerableTicks(player, 0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CombinedConfig cc = CombinedConfig.getConfig(player);
        if (!cc.invulnerableCheck) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cc.invulnerableIgnore.contains(cause)) {
            return;
        }
        Integer modifier = cc.invulnerableModifiers.get(cause);
        if (modifier == null) {
            modifier = cc.invulnerableModifierDefault;
        }
        CombinedData data = CombinedData.getData(player);
        if (TickTask.getTick() >= data.invulnerableTick + modifier) {
            return;
        }
        event.setCancelled(true);
        this.counters.addPrimaryThread(this.idFakeInvulnerable, 1);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerToggleSprintHighest(PlayerToggleSprintEvent event) {
        Improbable.feed(event.getPlayer(), 0.35f, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Improbable.feed(event.getPlayer(), 0.35f, System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerFish(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (this.munchHausen.isEnabled(player) && this.munchHausen.checkFish(player, event.getCaught(), event.getState())) {
            event.setCancelled(true);
        }
    }
}

