/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.APIUtils;
import fr.neatmonster.nocheatplus.utilities.FCFSComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationHistory {
    static Map<String, CheckType> checkTypeMap = new HashMap<String, CheckType>();
    private static Map<String, ViolationHistory> violationHistories = new HashMap<String, ViolationHistory>();
    private final List<ViolationLevel> violationLevels = new ArrayList<ViolationLevel>();

    public static ViolationHistory getHistory(Player player) {
        return ViolationHistory.getHistory(player.getName(), true);
    }

    public static ViolationHistory getHistory(Player player, boolean create) {
        return ViolationHistory.getHistory(player.getName(), create);
    }

    public static ViolationHistory getHistory(String playerName, boolean create) {
        ViolationHistory hist = violationHistories.get(playerName);
        if (hist != null) {
            return hist;
        }
        if (create) {
            ViolationHistory newHist = new ViolationHistory();
            violationHistories.put(playerName, newHist);
            return newHist;
        }
        return null;
    }

    public static List<VLView> getView(CheckType checkType) {
        LinkedList<VLView> view = new LinkedList<VLView>();
        for (Map.Entry<String, ViolationHistory> entry : violationHistories.entrySet()) {
            ViolationHistory hist = entry.getValue();
            ViolationLevel vl = hist.getViolationLevel(checkType);
            if (vl == null) continue;
            view.add(new VLView(entry.getKey(), vl));
        }
        return view;
    }

    public static ViolationHistory removeHistory(String playerName) {
        return violationHistories.remove(playerName);
    }

    public static void clear(CheckType checkType) {
        for (ViolationHistory hist : violationHistories.values()) {
            hist.remove(checkType);
        }
    }

    public ViolationLevel[] getViolationLevels() {
        ViolationLevel[] sortedLevels = new ViolationLevel[this.violationLevels.size()];
        this.violationLevels.toArray(sortedLevels);
        Arrays.sort(sortedLevels, ViolationLevel.VLComparator);
        return sortedLevels;
    }

    public ViolationLevel getViolationLevel(CheckType type) {
        for (int i = 0; i < this.violationLevels.size(); ++i) {
            ViolationLevel vl = this.violationLevels.get(i);
            if (checkTypeMap.get(vl.check) != type) continue;
            return vl;
        }
        return null;
    }

    public void log(String check, double VL) {
        for (ViolationLevel violationLevel : this.violationLevels) {
            if (!check.equals(violationLevel.check)) continue;
            violationLevel.add(VL);
            return;
        }
        this.violationLevels.add(new ViolationLevel(check, VL));
    }

    public boolean remove(CheckType checkType) {
        if (checkType == CheckType.ALL) {
            boolean empty = this.violationLevels.isEmpty();
            this.violationLevels.clear();
            return !empty;
        }
        Iterator<ViolationLevel> it = this.violationLevels.iterator();
        boolean found = false;
        while (it.hasNext()) {
            ViolationLevel vl = it.next();
            CheckType refType = checkTypeMap.get(vl.check);
            if (refType == null || refType != checkType && !APIUtils.isParent(checkType, refType)) continue;
            found = true;
            it.remove();
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VLView {
        public static final Comparator<VLView> CmpName = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        };
        public static final Comparator<VLView> CmpCheck = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return o1.check.compareToIgnoreCase(o2.check);
            }
        };
        public static final Comparator<VLView> CmpSumVL = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return Double.compare(o1.sumVL, o2.sumVL);
            }
        };
        public static final Comparator<VLView> CmpnVL = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return Integer.compare(o1.nVL, o2.nVL);
            }
        };
        public static final Comparator<VLView> CmpAvgVL = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return Double.compare(o1.sumVL / (double)o1.nVL, o2.sumVL / (double)o2.nVL);
            }
        };
        public static final Comparator<VLView> CmpMaxVL = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return Double.compare(o1.maxVL, o2.maxVL);
            }
        };
        public static final Comparator<VLView> CmpTime = new Comparator<VLView>(){

            @Override
            public int compare(VLView o1, VLView o2) {
                return Long.compare(o1.time, o2.time);
            }
        };
        public final String name;
        public final String check;
        public final double sumVL;
        public final int nVL;
        public final double maxVL;
        public final long time;

        public static Comparator<VLView> parseMixedComparator(String[] args, int startIndex) {
            LinkedHashSet comparators = new LinkedHashSet();
            for (int i = startIndex; i < args.length; ++i) {
                String arg = args[i].toLowerCase();
                while (arg.startsWith("-")) {
                    arg = arg.substring(1);
                }
                if (arg.matches("(name|player|playername)")) {
                    comparators.add(CmpName);
                    continue;
                }
                if (arg.matches("(check|type|checktype)")) {
                    comparators.add(CmpCheck);
                    continue;
                }
                if (arg.matches("(sum|sumvl|vl)")) {
                    comparators.add(CmpSumVL);
                    continue;
                }
                if (arg.matches("(n|num|number|nvl)")) {
                    comparators.add(CmpnVL);
                    continue;
                }
                if (arg.matches("(avg|av|average|averagevl|avgvl|avvl|avl)")) {
                    comparators.add(CmpAvgVL);
                    continue;
                }
                if (arg.matches("(max|maxvl|maximum|maximumvl)")) {
                    comparators.add(CmpMaxVL);
                    continue;
                }
                if (!arg.matches("(time|t)")) continue;
                comparators.add(CmpTime);
            }
            if (comparators.isEmpty()) {
                return null;
            }
            return new FCFSComparator<VLView>(comparators, true);
        }

        public VLView(String name, ViolationLevel vl) {
            this(name, vl.check, vl.sumVL, vl.nVL, vl.maxVL, vl.time);
        }

        public VLView(String name, String check, double sumVL, int nVL, double maxVL, long time) {
            this.name = name;
            this.check = check;
            this.sumVL = sumVL;
            this.nVL = nVL;
            this.maxVL = maxVL;
            this.time = time;
        }
    }

    public static class ViolationLevel {
        public static Comparator<ViolationLevel> VLComparator = new Comparator<ViolationLevel>(){

            @Override
            public int compare(ViolationLevel vl1, ViolationLevel vl2) {
                return Long.compare(vl1.time, vl2.time);
            }
        };
        public final String check;
        public double sumVL;
        public int nVL;
        public double maxVL;
        public long time;

        public ViolationLevel(String check, double VL) {
            this.check = check;
            this.sumVL = VL;
            this.nVL = 1;
            this.maxVL = VL;
            this.time = System.currentTimeMillis();
        }

        public void add(double VL) {
            this.sumVL += VL;
            ++this.nVL;
            this.maxVL = Math.max(this.maxVL, VL);
            this.time = System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ViolationLevel) {
                return this.check.equals(((ViolationLevel)obj).check);
            }
            return false;
        }

        public int hashCode() {
            return this.check.hashCode();
        }
    }
}

