/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.MCAccessHolder;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.ExecutionHistory;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class Check
implements MCAccessHolder {
    protected static Map<String, ExecutionHistory> histories = new HashMap<String, ExecutionHistory>();
    protected final CheckType type;
    protected MCAccess mcAccess;

    protected static ExecutionHistory getHistory(Player player) {
        if (!histories.containsKey(player.getName())) {
            histories.put(player.getName(), new ExecutionHistory());
        }
        return histories.get(player.getName());
    }

    public Check(CheckType type) {
        this.type = type;
        this.mcAccess = NCPAPIProvider.getNoCheatPlusAPI().getMCAccess();
        ViolationHistory.checkTypeMap.put(this.getClass().getName(), type);
        DataManager.registerExecutionHistory(type, histories);
    }

    public boolean executeActions(Player player, double vL, double addedVL, ActionList actions) {
        return this.executeActions(new ViolationData(this, player, vL, addedVL, actions));
    }

    public boolean executeActions(ViolationData violationData) {
        if (NCPHookManager.shouldCancelVLProcessing(violationData)) {
            return false;
        }
        boolean hasCancel = violationData.hasCancel();
        if (Bukkit.isPrimaryThread()) {
            return violationData.executeActions();
        }
        TickTask.requestActionsExecution(violationData);
        return hasCancel;
    }

    public CheckType getType() {
        return this.type;
    }

    public boolean isEnabled(Player player, ICheckData data, ICheckConfig cc) {
        return cc.isEnabled(this.type) && !CheckUtils.hasBypass(this.type, player, data);
    }

    public boolean isEnabled(Player player, ICheckConfig cc) {
        return cc.isEnabled(this.type) && !CheckUtils.hasBypass(this.type, player, null);
    }

    public boolean isEnabled(Player player) {
        return this.type.isEnabled(player) && !CheckUtils.hasBypass(this.type, player, null);
    }

    public boolean hasBypass(Player player) {
        return CheckUtils.hasBypass(this.type, player, null);
    }

    public void setMCAccess(MCAccess mcAccess) {
        this.mcAccess = mcAccess;
    }

    public MCAccess getMCAccess() {
        return this.mcAccess;
    }

    public void debug(Player player, String message) {
        CheckUtils.debug(player, this.type, message);
    }
}

