/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PlayerLocation {
    private final MCAccess mcAccess;
    private double yOnGround = 0.001;
    private int blockX;
    private int blockY;
    private int blockZ;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private double width;
    private double height;
    private double eyeHeight;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private double onGroundMinY = Double.MAX_VALUE;
    private double notOnGroundMaxY = Double.MIN_VALUE;
    private Integer typeId = null;
    private Integer typeIdBelow = null;
    private Integer data = null;
    private Long blockFlags = null;
    private Boolean onIce = null;
    private Boolean onClimbable = null;
    private Boolean passable = null;
    private Boolean aboveStairs = null;
    private Boolean inLava = null;
    private Boolean inWater = null;
    private Boolean inWeb = null;
    private Boolean onGround = null;
    private Player player = null;
    private World world = null;
    private BlockCache blockCache = null;

    public PlayerLocation(MCAccess mcAccess, BlockCache blockCache) {
        this.mcAccess = mcAccess;
        this.blockCache = blockCache;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        if (this.world == null) {
            throw new NullPointerException("World is null.");
        }
        return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Vector getVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getEyeHeight() {
        return this.eyeHeight;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public double[] getBoundsAsDoubles() {
        return new double[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public final boolean isSameBlock(PlayerLocation other) {
        return this.blockX == other.getBlockX() && this.blockZ == other.getBlockZ() && this.blockY == other.getBlockY();
    }

    public final boolean isSameBlock(int x, int y, int z) {
        return this.blockX == x && this.blockZ == z && this.blockY == y;
    }

    public final boolean isSameBlock(Location loc) {
        return this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ() && this.blockY == loc.getBlockY();
    }

    public boolean isBlockAbove(PlayerLocation loc) {
        return this.blockY == loc.getBlockY() + 1 && this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ();
    }

    public boolean isBlockAbove(Location loc) {
        return this.blockY == loc.getBlockY() + 1 && this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ();
    }

    public boolean isSamePos(PlayerLocation loc) {
        return this.x == loc.getX() && this.z == loc.getZ() && this.y == loc.getY();
    }

    public boolean isSamePos(Location loc) {
        return this.x == loc.getX() && this.z == loc.getZ() && this.y == loc.getY();
    }

    public int manhattan(PlayerLocation other) {
        return TrigUtil.manhattan(this.blockX, this.blockY, this.blockZ, other.blockX, other.blockY, other.blockZ);
    }

    public int maxBlockDist(PlayerLocation other) {
        return TrigUtil.maxDistance(this.blockX, this.blockY, this.blockZ, other.blockX, other.blockY, other.blockZ);
    }

    public boolean isAboveStairs() {
        if (this.aboveStairs == null) {
            if (this.blockFlags != null && (this.blockFlags & 1L) == 0L) {
                this.aboveStairs = false;
                return false;
            }
            double diff = 0.0;
            this.aboveStairs = BlockProperties.collides(this.blockCache, this.minX - 0.0, this.minY - 1.0, this.minZ - 0.0, this.maxX + 0.0, this.minY + 0.25, this.maxZ + 0.0, 1L);
        }
        return this.aboveStairs;
    }

    public boolean isInLava() {
        if (this.inLava == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x20L) == 0L) {
                this.inLava = false;
                return false;
            }
            this.inLava = BlockProperties.collides(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, 32L);
        }
        return this.inLava;
    }

    public boolean isInWater() {
        if (this.inWater == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x10L) == 0L) {
                this.inWater = false;
                return false;
            }
            this.inWater = BlockProperties.collides(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, 16L);
        }
        return this.inWater;
    }

    public boolean isInLiquid() {
        if (this.blockFlags != null && (this.blockFlags & 2L) == 0L) {
            return false;
        }
        return this.isInWater() || this.isInLava();
    }

    public boolean isOnIce() {
        if (this.onIce == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x20000L) == 0L) {
                this.onIce = false;
            } else {
                int id = this.player.isSneaking() || this.player.isBlocking() ? this.getTypeId(this.blockX, Location.locToBlock((double)(this.minY - 0.1)), this.blockZ) : this.getTypeIdBelow().intValue();
                this.onIce = BlockProperties.isIce(id);
            }
        }
        return this.onIce;
    }

    public boolean isOnClimbable() {
        if (this.onClimbable == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x200L) == 0L) {
                this.onClimbable = false;
                return false;
            }
            this.onClimbable = (BlockProperties.getBlockFlags(this.getTypeId()) & 0x200L) != 0L;
        }
        return this.onClimbable;
    }

    public boolean canClimbUp(double jumpHeigth) {
        if (BlockProperties.isAttachedClimbable(this.getTypeId())) {
            if (BlockProperties.canClimbUp(this.blockCache, this.blockX, this.blockY, this.blockZ)) {
                return true;
            }
            int headY = Location.locToBlock((double)(this.y + this.eyeHeight));
            if (headY > this.blockY) {
                for (int cy = this.blockY + 1; cy <= headY; ++cy) {
                    if (!BlockProperties.canClimbUp(this.blockCache, this.blockX, cy, this.blockZ)) continue;
                    return true;
                }
            }
            return this.isOnGround(jumpHeigth);
        }
        return true;
    }

    public boolean isAboveLadder() {
        if (this.blockFlags != null && (this.blockFlags & 0x200L) == 0L) {
            return false;
        }
        return (BlockProperties.getBlockFlags(this.getTypeIdBelow()) & 0x200L) != 0L;
    }

    public boolean isInWeb() {
        if (this.inWeb == null) {
            double inset = 0.001;
            this.inWeb = BlockProperties.collidesId(this.blockCache, this.minX + 0.001, this.minY + 0.001, this.minZ + 0.001, this.maxX - 0.001, this.maxY - 0.001, this.maxZ - 0.001, Material.WEB);
        }
        return this.inWeb;
    }

    public boolean isOnGround() {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (this.notOnGroundMaxY >= this.yOnGround) {
            this.onGround = false;
        } else if (this.onGroundMinY <= this.yOnGround) {
            this.onGround = true;
        } else if (this.blockFlags == null || (this.blockFlags & 0x80L) != 0L) {
            double[] bounds;
            int bY = Location.locToBlock((double)(this.y - this.yOnGround));
            int id = bY == this.blockY ? this.getTypeId() : (bY == this.blockY - 1 ? this.getTypeIdBelow().intValue() : this.blockCache.getTypeId(this.blockX, bY, this.blockZ));
            long flags = BlockProperties.getBlockFlags(id);
            if ((flags & 0x80L) != 0L && (flags & 0x400L) == 0L && (bounds = this.blockCache.getBounds(this.blockX, bY, this.blockZ)) != null && this.y - (double)bY >= bounds[4] && BlockProperties.collidesBlock(this.blockCache, this.x, this.minY - this.yOnGround, this.z, this.x, this.minY, this.z, this.blockX, bY, this.blockZ, id, bounds, flags) && (!BlockProperties.isPassableWorkaround(this.blockCache, this.blockX, bY, this.blockZ, this.minX - (double)this.blockX, this.minY - this.yOnGround - (double)bY, this.minZ - (double)this.blockZ, id, this.maxX - this.minX, this.yOnGround, this.maxZ - this.minZ, 1.0) || (flags & 0x1000L) != 0L && BlockProperties.getGroundMinHeight(this.blockCache, this.blockX, bY, this.blockZ, id, bounds, flags) <= this.y - (double)bY)) {
                this.onGround = true;
            }
            if (this.onGround == null) {
                this.onGround = BlockProperties.isOnGround(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, 0L);
            }
        } else {
            this.onGround = false;
        }
        if (this.onGround.booleanValue()) {
            this.onGroundMinY = Math.min(this.onGroundMinY, this.yOnGround);
        } else {
            this.notOnGroundMaxY = Math.max(this.notOnGroundMaxY, this.yOnGround);
            double d1 = 0.25;
            this.onGround = this.blockCache.standsOnEntity((Entity)this.player, this.minX - 0.25, this.minY - this.yOnGround - 0.25, this.minZ - 0.25, this.maxX + 0.25, this.minY + 0.25 + 0.25, this.maxZ + 0.25);
        }
        return this.onGround;
    }

    public boolean isOnGround(double yOnGround) {
        if (this.notOnGroundMaxY >= yOnGround) {
            return false;
        }
        if (this.onGroundMinY <= yOnGround) {
            return true;
        }
        return this.isOnGround(yOnGround, 0.0, 0.0, 0L);
    }

    public boolean isOnGround(double yOnGround, long ignoreFlags) {
        if (ignoreFlags == 0L) {
            if (this.notOnGroundMaxY >= yOnGround) {
                return false;
            }
            if (this.onGroundMinY <= yOnGround) {
                return true;
            }
        }
        return this.isOnGround(yOnGround, 0.0, 0.0, ignoreFlags);
    }

    public boolean isOnGround(double yOnGround, double xzMargin, double yMargin) {
        if (xzMargin >= 0.0 && this.onGroundMinY <= yOnGround) {
            return true;
        }
        if (xzMargin <= 0.0 && yMargin == 0.0 && this.notOnGroundMaxY >= yOnGround) {
            return false;
        }
        return this.isOnGround(yOnGround, xzMargin, yMargin, 0L);
    }

    public boolean isOnGround(double yOnGround, double xzMargin, double yMargin, long ignoreFlags) {
        if (ignoreFlags == 0L) {
            if (xzMargin >= 0.0 && this.onGroundMinY <= yOnGround) {
                return true;
            }
            if (xzMargin <= 0.0 && yMargin == 0.0 && this.notOnGroundMaxY >= yOnGround) {
                return false;
            }
        }
        boolean onGround = BlockProperties.isOnGround(this.blockCache, this.minX - xzMargin, this.minY - yOnGround - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.minY + yMargin, this.maxZ + xzMargin, ignoreFlags);
        if (ignoreFlags == 0L) {
            if (onGround) {
                if (xzMargin <= 0.0 && yMargin == 0.0) {
                    this.onGroundMinY = Math.min(this.onGroundMinY, yOnGround);
                }
            } else if (xzMargin >= 0.0) {
                this.notOnGroundMaxY = Math.max(this.notOnGroundMaxY, yOnGround);
            }
        }
        return onGround;
    }

    public boolean standsOnBlock(int id) {
        if (!this.isOnGround()) {
            return false;
        }
        return BlockProperties.collidesBlock(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, id);
    }

    public boolean standsOnEntity(double yOnGround, double xzMargin, double yMargin) {
        return this.blockCache.standsOnEntity((Entity)this.player, this.minX - xzMargin, this.minY - yOnGround - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.minY + yMargin, this.maxZ + xzMargin);
    }

    public boolean isNextToSolid(double xzMargin, double yMargin) {
        return BlockProperties.collides(this.blockCache, this.minX - xzMargin, this.minY - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.maxY + yMargin, this.maxZ + xzMargin, 4L);
    }

    public boolean isNextToGround(double xzMargin, double yMargin) {
        return BlockProperties.collides(this.blockCache, this.minX - xzMargin, this.minY - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.maxY + yMargin, this.maxZ + xzMargin, 128L);
    }

    public boolean isResetCond() {
        return this.isInLiquid() || this.isOnClimbable() || this.isInWeb();
    }

    public boolean isHeadObstructed(double marginAboveEyeHeight) {
        return BlockProperties.collides(this.blockCache, this.x - this.width, this.y + this.eyeHeight, this.z - this.width, this.x + this.width, this.y + this.eyeHeight + marginAboveEyeHeight, this.z + this.width, 132L);
    }

    public boolean isHeadObstructed() {
        return this.isHeadObstructed(Math.max(0.0, 2.0 - this.eyeHeight) + this.yOnGround);
    }

    public boolean isHeadObstructedMax(double marginAboveEyeHeight) {
        return this.isHeadObstructed(Math.max(marginAboveEyeHeight, 2.0 - this.eyeHeight) + this.yOnGround);
    }

    public boolean isOnGroundOrResetCond() {
        return this.isOnGround() || this.isResetCond();
    }

    public double getyOnGround() {
        return this.yOnGround;
    }

    public void setyOnGround(double yOnGround) {
        this.yOnGround = yOnGround;
        this.onGround = null;
        this.blockFlags = null;
    }

    public boolean isPassable() {
        if (this.passable == null) {
            this.passable = BlockProperties.isPassable(this.blockCache, this.x, this.y, this.z, this.getTypeId());
        }
        return this.passable;
    }

    public boolean isDownStream(double xDistance, double zDistance) {
        return BlockProperties.isDownStream(this.blockCache, this.blockX, this.blockY, this.blockZ, this.getData(), xDistance, zDistance);
    }

    public Integer getTypeId() {
        if (this.typeId == null) {
            this.typeId = this.getTypeId(this.blockX, this.blockY, this.blockZ);
        }
        return this.typeId;
    }

    public Integer getTypeIdBelow() {
        if (this.typeIdBelow == null) {
            this.typeIdBelow = this.getTypeId(this.blockX, this.blockY - 1, this.blockZ);
        }
        return this.typeIdBelow;
    }

    public Integer getData() {
        if (this.data == null) {
            this.data = this.getData(this.blockX, this.blockY, this.blockZ);
        }
        return this.data;
    }

    public final int getTypeId(int x, int y, int z) {
        return this.blockCache.getTypeId(x, y, z);
    }

    public final int getData(int x, int y, int z) {
        return this.blockCache.getData(x, y, z);
    }

    public void setBlockCache(BlockCache cache) {
        this.blockCache = cache;
    }

    public final BlockCache getBlockCache() {
        return this.blockCache;
    }

    public void set(Location location, Player player) {
        this.set(location, player, 0.001);
    }

    public void set(Location location, Player player, double yOnGround) {
        this.player = player;
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.width = this.mcAccess.getWidth((Entity)player);
        this.height = this.mcAccess.getHeight((Entity)player);
        this.eyeHeight = player.getEyeHeight();
        double dxz = (double)Math.round(this.width * 500.0) / 1000.0;
        this.minX = this.x - dxz;
        this.minY = this.y;
        this.minZ = this.z - dxz;
        this.maxX = this.x + dxz;
        this.maxY = this.y + this.eyeHeight;
        this.maxZ = this.z + dxz;
        this.world = location.getWorld();
        if (this.world == null) {
            throw new NullPointerException("World is null.");
        }
        this.data = null;
        this.typeIdBelow = null;
        this.typeId = null;
        this.passable = null;
        this.onClimbable = null;
        this.onIce = null;
        this.onGround = null;
        this.inWeb = null;
        this.inWater = null;
        this.inLava = null;
        this.aboveStairs = null;
        this.onGroundMinY = Double.MAX_VALUE;
        this.notOnGroundMaxY = Double.MIN_VALUE;
        this.blockFlags = null;
        this.yOnGround = yOnGround;
    }

    public void collectBlockFlags() {
        if (this.blockFlags == null) {
            this.collectBlockFlags(this.yOnGround);
        }
    }

    public void collectBlockFlags(double maxYonGround) {
        maxYonGround = Math.max(this.yOnGround, maxYonGround);
        double yExtra = 0.6;
        double xzM = 0.0;
        this.blockFlags = BlockProperties.collectFlagsSimple(this.blockCache, this.minX - 0.0, this.minY - 0.6 - maxYonGround, this.minZ - 0.0, this.maxX + 0.0, Math.max(this.maxY, this.minY + 1.5), this.maxZ + 0.0);
    }

    public int ensureChunksLoaded() {
        return this.ensureChunksLoaded(1.0);
    }

    public int ensureChunksLoaded(double xzMargin) {
        return BlockCache.ensureChunksLoaded(this.world, this.x, this.z, xzMargin);
    }

    public void cleanup() {
        this.player = null;
        this.world = null;
        this.blockCache = null;
    }

    public boolean isIllegal() {
        if (this.hasIllegalCoords()) {
            return true;
        }
        return this.hasIllegalStance();
    }

    public boolean hasIllegalStance() {
        return this.mcAccess.isIllegalBounds(this.player).decide();
    }

    public boolean hasIllegalCoords() {
        return CheckUtils.isBadCoordinate(this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    public Long getBlockFlags() {
        return this.blockFlags;
    }

    public void setBlockFlags(Long blockFlags) {
        this.blockFlags = blockFlags;
    }

    public int getTypeIdAbove() {
        return this.blockCache.getTypeId(this.blockX, this.blockY + 1, this.blockZ);
    }

    public long getBlockChangeIdPush(BlockChangeTracker blockChangeTracker, long oldChangeId, BlockChangeTracker.Direction direction, double coverDistance) {
        int tick = TickTask.getTick();
        UUID worldId = this.world.getUID();
        int iMinX = Location.locToBlock((double)this.minX);
        int iMaxX = Location.locToBlock((double)this.maxX);
        int iMinY = Location.locToBlock((double)this.minY);
        int iMaxY = Location.locToBlock((double)this.maxY);
        int iMinZ = Location.locToBlock((double)this.minZ);
        int iMaxZ = Location.locToBlock((double)this.maxZ);
        long minId = Long.MAX_VALUE;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    long tempId = blockChangeTracker.getChangeIdPush(oldChangeId, (long)tick, worldId, x, y, z, direction);
                    if (tempId == -1L || tempId >= minId || !(coverDistance > 0.0) || !this.coversDistance(x, y, z, direction, coverDistance)) continue;
                    minId = tempId;
                }
            }
        }
        return minId == Long.MAX_VALUE ? -1L : minId;
    }

    private boolean coversDistance(int x, int y, int z, BlockChangeTracker.Direction direction, double coverDistance) {
        switch (direction) {
            case Y_POS: {
                return (double)y + 1.0 - Math.max(this.minY, (double)y) >= coverDistance;
            }
            case Y_NEG: {
                return Math.min(this.maxY, (double)y + 1.0) - (double)y >= coverDistance;
            }
            case X_POS: {
                return (double)x + 1.0 - Math.max(this.minX, (double)x) >= coverDistance;
            }
            case X_NEG: {
                return Math.min(this.maxX, (double)x + 1.0) - (double)x >= coverDistance;
            }
            case Z_POS: {
                return (double)z + 1.0 - Math.max(this.minZ, (double)z) >= coverDistance;
            }
            case Z_NEG: {
                return Math.min(this.maxZ, (double)z + 1.0) - (double)z >= coverDistance;
            }
        }
        return true;
    }

    public void prepare(PlayerLocation other) {
        this.onGround = other.isOnGround();
        this.inWater = other.isInWater();
        this.inLava = other.isInLava();
        this.inWeb = other.isInWeb();
        this.onClimbable = other.isOnClimbable();
        if (!this.onGround.booleanValue() && !this.isResetCond()) {
            this.aboveStairs = other.isAboveStairs();
        }
        this.onIce = other.isOnIce();
        this.passable = other.passable;
        this.typeId = other.getTypeId();
        this.typeIdBelow = other.getTypeIdBelow();
        this.notOnGroundMaxY = other.notOnGroundMaxY;
        this.onGroundMinY = other.onGroundMinY;
        this.blockFlags = other.blockFlags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("PlayerLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

