/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.order.SetupOrder;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.LoggerID;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.logging.details.AbstractLogManager;
import fr.neatmonster.nocheatplus.logging.details.BukkitLogNodeDispatcher;
import fr.neatmonster.nocheatplus.logging.details.ContentLogger;
import fr.neatmonster.nocheatplus.logging.details.FileLoggerAdapter;
import fr.neatmonster.nocheatplus.logging.details.LogOptions;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SetupOrder(priority=-2147483648)
public class BukkitLogManager
extends AbstractLogManager
implements INotifyReload {
    private static ContentLogger<String> serverLogger = new ContentLogger<String>(){

        @Override
        public void log(Level level, String content) {
            try {
                Bukkit.getLogger().log(level, "[NoCheatPlus] " + content);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    };
    protected final Plugin plugin;

    public BukkitLogManager(Plugin plugin) {
        super(new BukkitLogNodeDispatcher(plugin), "default.", Streams.INIT);
        this.plugin = plugin;
        ConfigFile config = ConfigManager.getConfigFile();
        this.createDefaultLoggers(config);
        this.getLogNodeDispatcher().setMaxQueueSize(config.getInt("logging.maxqueuesize"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerInitLogger() {
        Object object = this.registryCOWLock;
        synchronized (object) {
            if (!this.hasStream(Streams.INIT)) {
                this.createInitStream();
            } else if (this.hasLogger(Streams.INIT.name)) {
                return;
            }
            boolean bukkitLoggerAsynchronous = ConfigManager.getConfigFile().getBoolean("logging.backend.console.asynchronous");
            LoggerID initLoggerID = this.registerStringLogger(serverLogger, new LogOptions(Streams.INIT.name, bukkitLoggerAsynchronous ? LogOptions.CallContext.ANY_THREAD_DIRECT : LogOptions.CallContext.PRIMARY_THREAD_ONLY));
            this.attachStringLogger(initLoggerID, Streams.INIT);
        }
    }

    protected void createDefaultLoggers(ConfigFile config) {
        for (StreamID streamID : new StreamID[]{Streams.STATUS, Streams.SERVER_LOGGER, Streams.PLUGIN_LOGGER, Streams.NOTIFY_INGAME, Streams.DEFAULT_FILE, Streams.TRACE_FILE}) {
            this.createStringStream(streamID);
        }
        final String prefixIngame = ColorUtil.replaceColors(config.getString("logging.backend.ingamechat.prefix"));
        String prefixFile = config.getString("logging.backend.file.prefix");
        boolean bukkitLoggerAsynchronous = config.getBoolean("logging.backend.console.asynchronous");
        LogOptions.CallContext defaultAsynchronousContext = LogOptions.CallContext.ASYNCHRONOUS_TASK;
        LoggerID tempID = this.registerStringLogger(serverLogger, new LogOptions(Streams.SERVER_LOGGER.name, bukkitLoggerAsynchronous ? defaultAsynchronousContext : LogOptions.CallContext.PRIMARY_THREAD_TASK));
        this.attachStringLogger(tempID, Streams.SERVER_LOGGER);
        tempID = this.registerStringLogger(this.plugin.getLogger(), new LogOptions(Streams.PLUGIN_LOGGER.name, bukkitLoggerAsynchronous ? defaultAsynchronousContext : LogOptions.CallContext.PRIMARY_THREAD_TASK));
        this.attachStringLogger(tempID, Streams.PLUGIN_LOGGER);
        tempID = this.registerStringLogger(new ContentLogger<String>(){

            @Override
            public void log(Level level, String content) {
                NCPAPIProvider.getNoCheatPlusAPI().sendAdminNotifyMessage(prefixIngame == null ? content : prefixIngame + content);
            }
        }, new LogOptions(Streams.NOTIFY_INGAME.name, LogOptions.CallContext.PRIMARY_THREAD_DIRECT));
        this.attachStringLogger(tempID, Streams.NOTIFY_INGAME);
        this.attachStringLogger(this.getLoggerID(Streams.SERVER_LOGGER.name), Streams.STATUS);
        String fileName = config.getString("logging.backend.file.filename").trim();
        ContentLogger<String> defaultFileLogger = null;
        if (!fileName.isEmpty() && !fileName.equalsIgnoreCase("none")) {
            defaultFileLogger = this.newFileLogger(fileName, this.plugin.getDataFolder(), prefixFile);
        }
        Object traceFileLogger = null;
        if (defaultFileLogger != null) {
            tempID = this.registerStringLogger(defaultFileLogger, new LogOptions(Streams.DEFAULT_FILE.name, defaultAsynchronousContext));
            this.attachStringLogger(tempID, Streams.DEFAULT_FILE);
            if (traceFileLogger == null) {
                this.attachStringLogger(this.getLoggerID(Streams.DEFAULT_FILE.name), Streams.TRACE_FILE);
            }
            tempID = this.registerStringLogger(defaultFileLogger, new LogOptions(Streams.DEFAULT_FILE.name + ".init", LogOptions.CallContext.ANY_THREAD_DIRECT));
            this.attachStringLogger(tempID, Streams.INIT);
            this.attachStringLogger(this.getLoggerID(Streams.DEFAULT_FILE.name), Streams.STATUS);
        }
    }

    protected ContentLogger<String> newFileLogger(String fileName, File defaultDir, String prefix) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(defaultDir, file.getPath());
        }
        try {
            FileLoggerAdapter logger = new FileLoggerAdapter(file, prefix);
            if (logger.isInoperable()) {
                logger.detachLogger();
                return null;
            }
            return logger;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public void onReload() {
        this.clear(0L, true);
        this.createDefaultLoggers(ConfigManager.getConfigFile());
    }

    public void startTasks() {
        ((BukkitLogNodeDispatcher)this.getLogNodeDispatcher()).startTasks();
    }
}

