/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.APIUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class NCPExemptionManager {
    private static final Map<CheckType, Set<UUID>> exempted = new HashMap<CheckType, Set<UUID>>();

    public static final void clear() {
        for (CheckType checkType : CheckType.values()) {
            if (APIUtils.needsSynchronization(checkType)) {
                exempted.put(checkType, Collections.synchronizedSet(new HashSet()));
                continue;
            }
            exempted.put(checkType, new HashSet());
        }
    }

    public static final void exemptPermanently(UUID id) {
        NCPExemptionManager.exemptPermanently(id, CheckType.ALL);
    }

    public static final void exemptPermanently(UUID id, CheckType checkType) {
        exempted.get((Object)checkType).add(id);
        for (CheckType child : APIUtils.getChildren(checkType)) {
            exempted.get((Object)child).add(id);
        }
    }

    public static final void exemptPermanently(Player player) {
        NCPExemptionManager.exemptPermanently(player, CheckType.ALL);
    }

    public static final void exemptPermanently(Player player, CheckType checkType) {
        NCPExemptionManager.exemptPermanently(player.getUniqueId(), checkType);
    }

    public static final boolean isExempted(UUID id, CheckType checkType) {
        return exempted.get((Object)checkType).contains(id);
    }

    public static final boolean isExempted(Player player, CheckType checkType) {
        return NCPExemptionManager.isExempted(player.getUniqueId(), checkType) || player.hasMetadata("nocheat.exempt");
    }

    public static final void unexempt(UUID id) {
        NCPExemptionManager.unexempt(id, CheckType.ALL);
    }

    public static final void unexempt(UUID id, CheckType checkType) {
        exempted.get((Object)checkType).remove(id);
        for (CheckType child : APIUtils.getChildren(checkType)) {
            exempted.get((Object)child).remove(id);
        }
    }

    public static final void unexempt(Player player) {
        NCPExemptionManager.unexempt(player, CheckType.ALL);
    }

    public static final void unexempt(Player player, CheckType checkType) {
        NCPExemptionManager.unexempt(player.getUniqueId(), checkType);
    }

    static {
        NCPExemptionManager.clear();
    }
}

