/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.yaml.snakeyaml.DumperOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawConfigFile
extends YamlConfiguration {
    private static String prepareMatchMaterial(String content) {
        return content.replace(' ', '_').replace('-', '_').replace('.', '_');
    }

    public static Integer parseTypeId(String content) {
        content = content.trim().toUpperCase();
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Material mat = Material.matchMaterial((String)RawConfigFile.prepareMatchMaterial(content));
                if (mat != null) {
                    return mat.getId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static Material parseMaterial(String content) {
        content = content.trim().toUpperCase();
        try {
            Integer id = Integer.parseInt(content);
            return Material.getMaterial((int)id);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Material.matchMaterial((String)RawConfigFile.prepareMatchMaterial(content));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public void setVersionDependent(String path, String cmpVersion, Object valueLT, Object valueEQ, Object valueGT, Object valueUnknown) {
        this.set(path, ServerVersion.select(cmpVersion, valueLT, valueEQ, valueGT, valueUnknown));
    }

    public double getDouble(String path, double min, double max, double preset) {
        double value = this.getDouble(path, preset);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public long getLong(String path, long min, long max, long preset) {
        long value = this.getLong(path, preset);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public long getInt(String path, int min, int max, int preset) {
        int value = this.getInt(path, preset);
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    @Deprecated
    public Integer getTypeId(String path) {
        return this.getTypeId(path, null);
    }

    @Deprecated
    public Integer getTypeId(String path, Integer preset) {
        Integer id;
        String content = this.getString(path, null);
        if (content != null && (id = RawConfigFile.parseTypeId(content)) != null) {
            return id;
        }
        int id2 = this.getInt(path, Integer.MAX_VALUE);
        return id2 == Integer.MAX_VALUE ? preset : id2;
    }

    public void readMaterialIdsFromList(String path, Collection<Integer> target) {
        List content = this.getStringList(path);
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String entry : content) {
            Integer id = RawConfigFile.parseTypeId(entry);
            if (id == null) {
                StaticLog.logWarning("Bad material entry (" + path + "): " + entry);
                continue;
            }
            target.add(id);
        }
    }

    public AlmostBoolean getAlmostBoolean(String path, AlmostBoolean defaultValue) {
        AlmostBoolean choice = AlmostBoolean.match(this.getString(path, null));
        return choice == null ? defaultValue : choice;
    }

    public void readMaterialFromList(String path, Collection<Material> target) {
        List content = this.getStringList(path);
        if (content == null || content.isEmpty()) {
            return;
        }
        for (String entry : content) {
            Material mat = RawConfigFile.parseMaterial(entry);
            if (mat == null) {
                StaticLog.logWarning("Bad material entry (" + path + "): " + entry);
                continue;
            }
            target.add(mat);
        }
    }

    public String saveToString() {
        try {
            Field op = YamlConfiguration.class.getDeclaredField("yamlOptions");
            op.setAccessible(true);
            DumperOptions options = (DumperOptions)op.get((Object)this);
            options.setWidth(200);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.saveToString();
    }
}

