/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.versions;

import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerVersion {
    private static String minecraftVersion = "unknown";
    private static final String[][] versionTagsMatch = new String[][]{{"1.7.2-r", "1.7.2"}};

    public static boolean isMinecraftVersionUnknown() {
        return GenericVersion.isVersionUnknown(minecraftVersion);
    }

    public static String parseMinecraftVersion(String ... versionCandidates) {
        for (String serverVersion : versionCandidates) {
            serverVersion = serverVersion.trim();
            for (String minecraftVersion : new String[]{GenericVersion.collectVersion(serverVersion, 0), ServerVersion.parseMinecraftVersionGeneric(serverVersion), ServerVersion.parseMinecraftVersionTokens(serverVersion)}) {
                if (minecraftVersion == null || !ServerVersion.validateMinecraftVersion(minecraftVersion)) continue;
                return minecraftVersion;
            }
        }
        return null;
    }

    private static boolean validateMinecraftVersion(String minecraftVersion) {
        return GenericVersion.collectVersion(minecraftVersion, 0) != null;
    }

    private static String parseMinecraftVersionTokens(String serverVersion) {
        serverVersion = serverVersion.trim().toLowerCase();
        for (String[] entry : versionTagsMatch) {
            if (!serverVersion.contains(entry[0])) continue;
            return entry[1];
        }
        return null;
    }

    private static String parseMinecraftVersionGeneric(String serverVersion) {
        String lcServerVersion = serverVersion.trim().toLowerCase();
        for (String candidate : new String[]{GenericVersion.parseVersionDelimiters(lcServerVersion, "(mc:", ")"), GenericVersion.parseVersionDelimiters(lcServerVersion, "mcpc-plus-", "-"), GenericVersion.parseVersionDelimiters(lcServerVersion, "git-bukkit-", "-r"), GenericVersion.parseVersionDelimiters(lcServerVersion, "", "-r")}) {
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public static String setMinecraftVersion(String version) {
        minecraftVersion = version == null ? "unknown" : ((version = version.trim().toLowerCase()).isEmpty() || version.equals("unknown") ? "unknown" : version);
        return minecraftVersion;
    }

    public static String getMinecraftVersion() {
        return minecraftVersion;
    }

    public static int compareMinecraftVersion(String toVersion) {
        return GenericVersion.compareVersions(ServerVersion.getMinecraftVersion(), toVersion);
    }

    public static boolean isMinecraftVersionBetween(String versionLow, boolean includeLow, String versionHigh, boolean includeHigh) {
        String minecraftVersion = ServerVersion.getMinecraftVersion();
        if (includeLow ? GenericVersion.compareVersions(minecraftVersion, versionLow) == -1 : GenericVersion.compareVersions(minecraftVersion, versionLow) <= 0) {
            return false;
        }
        return !(includeHigh ? GenericVersion.compareVersions(minecraftVersion, versionHigh) == 1 : GenericVersion.compareVersions(minecraftVersion, versionHigh) >= 0);
    }

    public static <V> V select(String cmpVersion, V valueLT, V valueEQ, V valueGT, V valueUnknown) {
        String mcVersion = ServerVersion.getMinecraftVersion();
        if (mcVersion == "unknown") {
            return valueUnknown;
        }
        int cmp = GenericVersion.compareVersions(mcVersion, cmpVersion);
        if (cmp == 0) {
            return valueEQ;
        }
        if (cmp < 0) {
            return valueLT;
        }
        return valueGT;
    }
}

