/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.LinkedCoordHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockChangeTracker {
    public static long F_MOVABLE_IGNORE = 2L;
    public static long F_MOVABLE = 132L;
    private long maxChangeId = 0L;
    private int expirationAgeTicks = 80;
    private int worldNodeSkipSize = 500;
    private final Map<UUID, WorldNode> worldMap = new LinkedHashMap<UUID, WorldNode>();
    private final Set<Block> processBlocks = new HashSet<Block>();

    public void addPistonBlocks(Block pistonBlock, BlockFace blockFace, List<Block> movedBlocks) {
        int tick = TickTask.getTick();
        UUID worldId = pistonBlock.getWorld().getUID();
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            worldNode = new WorldNode(worldId);
            this.worldMap.put(worldId, worldNode);
        }
        long changeId = ++this.maxChangeId;
        if (pistonBlock != null) {
            this.processBlocks.add(pistonBlock);
        }
        if (movedBlocks != null) {
            for (Block movedBlock : movedBlocks) {
                this.processBlocks.add(movedBlock);
                this.processBlocks.add(movedBlock.getRelative(blockFace));
            }
        }
        for (Block block : this.processBlocks) {
            this.addPistonBlock(changeId, tick, worldNode, block, blockFace);
        }
        this.processBlocks.clear();
    }

    private void addPistonBlock(long changeId, int tick, WorldNode worldNode, Block targetBlock, BlockFace blockFace) {
        this.addBlockChange(changeId, tick, worldNode, targetBlock.getX(), targetBlock.getY(), targetBlock.getZ(), Direction.getDirection(blockFace));
    }

    private void addBlockChange(long changeId, int tick, WorldNode worldNode, int x, int y, int z, Direction direction) {
        worldNode.lastChangeTick = tick;
        BlockChangeEntry entry = new BlockChangeEntry(changeId, tick, x, y, z, direction);
        LinkedList<BlockChangeEntry> entries = worldNode.blocks.get(x, y, z, LinkedCoordHashMap.MoveOrder.END);
        if (entries == null) {
            entries = new LinkedList();
            worldNode.blocks.put(x, y, z, entries, LinkedCoordHashMap.MoveOrder.END);
        } else if (!entries.isEmpty() && entries.getFirst().tick < tick - this.expirationAgeTicks) {
            worldNode.size -= this.expireEntries(tick - this.expirationAgeTicks, entries);
        }
        entries.add(entry);
        ++worldNode.size;
    }

    private int expireEntries(int olderThanTick, LinkedList<BlockChangeEntry> entries) {
        int removed = 0;
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            if (((BlockChangeEntry)it.next()).tick < olderThanTick) {
                it.remove();
                ++removed;
                continue;
            }
            return removed;
        }
        return removed;
    }

    public void checkExpiration(int currentTick) {
        int olderThanTick = currentTick - this.expirationAgeTicks;
        Iterator<Map.Entry<UUID, WorldNode>> it = this.worldMap.entrySet().iterator();
        while (it.hasNext()) {
            WorldNode worldNode = it.next().getValue();
            if (worldNode.lastChangeTick < olderThanTick) {
                worldNode.clear();
                it.remove();
                continue;
            }
            if (worldNode.size < this.worldNodeSkipSize) continue;
            Iterator blockIt = worldNode.blocks.iterator();
            while (blockIt.hasNext()) {
                LinkedList entries = (LinkedList)((CoordMap.Entry)blockIt.next()).getValue();
                if (!entries.isEmpty() && ((BlockChangeEntry)entries.getFirst()).tick < olderThanTick) {
                    worldNode.size -= this.expireEntries(olderThanTick, entries);
                }
                if (!entries.isEmpty()) continue;
                blockIt.remove();
            }
            if (worldNode.size != 0) continue;
            it.remove();
        }
    }

    public long getChangeIdPush(long gtChangeId, long tick, UUID worldId, int x, int y, int z, Direction direction) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            return -1L;
        }
        return this.getChangeIdPush(gtChangeId, tick, worldNode, x, y, z, direction);
    }

    private long getChangeIdPush(long gtChangeId, long tick, WorldNode worldNode, int x, int y, int z, Direction direction) {
        long olderThanTick = tick - (long)this.expirationAgeTicks;
        if ((long)worldNode.lastChangeTick < olderThanTick) {
            worldNode.clear();
            this.worldMap.remove(worldNode.worldId);
            return -1L;
        }
        LinkedList entries = (LinkedList)worldNode.blocks.get(x, y, z);
        if (entries == null) {
            return -1L;
        }
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            BlockChangeEntry entry = (BlockChangeEntry)it.next();
            if ((long)entry.tick < olderThanTick) {
                it.remove();
                continue;
            }
            if (entry.id <= gtChangeId || direction != null && entry.direction != direction) continue;
            return entry.id;
        }
        if (entries.isEmpty()) {
            worldNode.blocks.remove(x, y, z);
            if (worldNode.size == 0) {
                this.worldMap.remove(worldNode.worldId);
            }
        }
        return -1L;
    }

    public void clear() {
        for (WorldNode worldNode : this.worldMap.values()) {
            worldNode.clear();
        }
        this.worldMap.clear();
    }

    public int size() {
        int size = 0;
        for (WorldNode worldNode : this.worldMap.values()) {
            size += worldNode.size;
        }
        return size;
    }

    public static class BlockChangeListener
    implements Listener {
        private final BlockChangeTracker tracker;
        private final boolean retractHasBlocks;
        private boolean enabled = true;

        public BlockChangeListener(BlockChangeTracker tracker) {
            this.tracker = tracker;
            if (ReflectionUtil.getMethodNoArgs(BlockPistonRetractEvent.class, "getBlocks", new Class[0]) == null) {
                this.retractHasBlocks = false;
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Assume legacy piston behavior.");
            } else {
                this.retractHasBlocks = true;
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        private BlockFace getDirection(Block pistonBlock) {
            MaterialData data = pistonBlock.getState().getData();
            if (data instanceof Directional) {
                Directional directional = (Directional)data;
                return directional.getFacing();
            }
            return null;
        }

        private BlockFace getRetractDirection(Block pistonBlock, BlockFace eventDirection) {
            BlockFace pistonDirection = this.getDirection(pistonBlock);
            if (pistonDirection == null) {
                return eventDirection;
            }
            return eventDirection.getOppositeFace();
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onPistonExtend(BlockPistonExtendEvent event) {
            if (!this.enabled) {
                return;
            }
            BlockFace direction = event.getDirection();
            this.tracker.addPistonBlocks(event.getBlock().getRelative(direction), direction, event.getBlocks());
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onPistonRetract(BlockPistonRetractEvent event) {
            ArrayList<Block> blocks;
            if (!this.enabled) {
                return;
            }
            if (this.retractHasBlocks) {
                blocks = event.getBlocks();
            } else {
                Location retLoc = event.getRetractLocation();
                if (retLoc == null) {
                    blocks = null;
                } else {
                    Block retBlock = retLoc.getBlock();
                    long flags = BlockProperties.getBlockFlags(retBlock.getType());
                    if ((flags & F_MOVABLE_IGNORE) == 0L && (flags & F_MOVABLE) != 0L) {
                        blocks = new ArrayList<Block>(1);
                        blocks.add(retBlock);
                    } else {
                        blocks = null;
                    }
                }
            }
            Block pistonBlock = event.getBlock();
            BlockFace direction = this.getRetractDirection(pistonBlock, event.getDirection());
            this.tracker.addPistonBlocks(pistonBlock.getRelative(direction.getOppositeFace()), direction, (List<Block>)blocks);
        }
    }

    public static class BlockChangeEntry {
        public final long id;
        public final int tick;
        public final int x;
        public final int y;
        public final int z;
        public final Direction direction;

        public BlockChangeEntry(long id, int tick, int x, int y, int z, Direction direction) {
            this.id = id;
            this.tick = tick;
            this.x = x;
            this.y = y;
            this.z = z;
            this.direction = direction;
        }
    }

    public static class WorldNode {
        public final LinkedCoordHashMap<LinkedList<BlockChangeEntry>> blocks = new LinkedCoordHashMap();
        public int lastChangeTick = 0;
        public int size = 0;
        public final UUID worldId;

        public WorldNode(UUID worldId) {
            this.worldId = worldId;
        }

        public void clear() {
            this.blocks.clear();
            this.size = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NONE,
        X_POS,
        X_NEG,
        Y_POS,
        Y_NEG,
        Z_POS,
        Z_NEG;


        public static Direction getDirection(BlockFace blockFace) {
            int x = blockFace.getModX();
            if (x == 1) {
                return X_POS;
            }
            if (x == -1) {
                return X_NEG;
            }
            int y = blockFace.getModY();
            if (y == 1) {
                return Y_POS;
            }
            if (y == -1) {
                return Y_NEG;
            }
            int z = blockFace.getModZ();
            if (z == 1) {
                return Z_POS;
            }
            if (z == -1) {
                return Z_NEG;
            }
            return NONE;
        }
    }
}

