/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.model;

import fr.neatmonster.nocheatplus.checks.net.model.DataLocation;

public class DataPacketFlying
extends DataLocation {
    public final boolean onGround;
    public final boolean hasPos;
    public final boolean hasLook;
    public final long time;

    public DataPacketFlying(boolean onGround, long time) {
        super(0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.onGround = onGround;
        this.hasPos = false;
        this.hasLook = false;
        this.time = time;
    }

    public DataPacketFlying(boolean onGround, float yaw, float pitch, long time) {
        super(0.0, 0.0, 0.0, yaw, pitch);
        this.onGround = onGround;
        this.hasPos = false;
        this.hasLook = true;
        this.time = time;
    }

    public DataPacketFlying(boolean onGround, double x, double y, double z, long time) {
        super(x, y, z, 0.0f, 0.0f);
        this.onGround = onGround;
        this.hasPos = true;
        this.hasLook = false;
        this.time = time;
    }

    public DataPacketFlying(boolean onGround, double x, double y, double z, float yaw, float pitch, long time) {
        super(x, y, z, yaw, pitch);
        this.onGround = onGround;
        this.hasPos = true;
        this.hasLook = true;
        this.time = time;
    }

    public boolean containsSameLocation(DataPacketFlying other) {
        return this.hasPos && other.hasPos && this.hasLook && other.hasLook && this.isSameLocation(other);
    }

    public boolean containsSameLocation(DataLocation other) {
        return this.hasPos && this.hasLook && this.isSameLocation(other);
    }

    public boolean matches(double x, double y, double z, float yaw, float pitch) {
        return this.hasPos && this.hasLook && this.isSameLocation(x, y, z, yaw, pitch);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("Flying(ground=");
        builder.append(this.onGround);
        if (this.hasPos) {
            builder.append(",x=");
            builder.append(this.x);
            builder.append(",y=");
            builder.append(this.y);
            builder.append(",z=");
            builder.append(this.z);
        }
        if (this.hasLook) {
            builder.append(",pitch=");
            builder.append(this.pitch);
            builder.append(",yaw=");
            builder.append(this.yaw);
        }
        builder.append(")");
        return builder.toString();
    }
}

