/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.model.LocationData;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;

public class MoveData {
    public static final MoveData alwaysInvalidated = new MoveData();
    public boolean valid = false;
    public final LocationData from = new LocationData();
    public boolean toIsValid = false;
    public final LocationData to = new LocationData();
    public double yDistance;
    public double hDistance;
    public double walkSpeed;
    public boolean headObstructed;
    public boolean downStream;
    public boolean touchedGround;
    public boolean touchedGroundWorkaround;
    public double hAllowedDistanceBase;
    public double hAllowedDistance;
    public boolean bunnyHop;
    public CheckType flyCheck;
    public boolean mightBeMultipleMoves;

    private void setPositions(PlayerLocation from, PlayerLocation to) {
        this.from.setLocation(from);
        this.to.setLocation(to);
        this.yDistance = this.to.y - this.from.y;
        this.hDistance = TrigUtil.distance(this.from.x, this.from.z, this.to.x, this.to.z);
        this.toIsValid = true;
    }

    private void setPositions(double x, double y, double z, float yaw, float pitch) {
        this.from.setLocation(x, y, z, yaw, pitch);
        this.toIsValid = false;
    }

    private void resetBase() {
        this.from.extraPropertiesValid = false;
        this.to.extraPropertiesValid = false;
        this.walkSpeed = 0.2;
        this.headObstructed = false;
        this.downStream = false;
        this.touchedGround = false;
        this.touchedGroundWorkaround = false;
        this.bunnyHop = false;
        this.hAllowedDistanceBase = 0.0;
        this.hAllowedDistance = 0.0;
        this.flyCheck = CheckType.UNKNOWN;
        this.mightBeMultipleMoves = false;
        this.valid = true;
    }

    public void set(PlayerLocation from, PlayerLocation to) {
        this.setPositions(from, to);
        this.resetBase();
    }

    public void set(PlayerLocation loc) {
        this.setPositions(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        this.resetBase();
    }

    public void setWithExtraProperties(PlayerLocation loc) {
        this.set(loc);
        this.from.setExtraProperties(loc);
        if (this.from.onGround) {
            this.touchedGround = true;
        }
    }

    public void setExtraProperties(PlayerLocation from, PlayerLocation to) {
        this.from.setExtraProperties(from);
        this.to.setExtraProperties(to);
        if (this.from.onGround || this.to.onGround) {
            this.touchedGround = true;
        }
    }

    public void invalidate() {
        this.valid = false;
        this.toIsValid = false;
        this.from.extraPropertiesValid = false;
        this.to.extraPropertiesValid = false;
    }
}

