/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.InteractRayTracing;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visible
extends Check {
    private BlockCache blockCache;
    private final InteractRayTracing rayTracing = new InteractRayTracing(false);
    private final List<String> tags = new ArrayList<String>();

    public Visible() {
        super(CheckType.BLOCKINTERACT_VISIBLE);
        this.blockCache = this.mcAccess.getBlockCache(null);
        this.rayTracing.setMaxSteps(60);
    }

    @Override
    public void setMCAccess(MCAccess mcAccess) {
        super.setMCAccess(mcAccess);
        this.blockCache = mcAccess.getBlockCache(null);
    }

    public boolean check(Player player, Location loc, Block block, BlockFace face, Action action, BlockInteractData data, BlockInteractConfig cc) {
        boolean collides;
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        double eyeX = loc.getX();
        double eyeY = loc.getY() + player.getEyeHeight();
        double eyeZ = loc.getZ();
        this.tags.clear();
        if (TrigUtil.isSameBlock(blockX, blockY, blockZ, eyeX, eyeY, eyeZ)) {
            collides = false;
        } else {
            Vector direction = loc.getDirection();
            this.blockCache.setAccess(loc.getWorld());
            this.rayTracing.setBlockCache(this.blockCache);
            collides = this.checkRayTracing(eyeX, eyeY, eyeZ, direction.getX(), direction.getY(), direction.getZ(), blockX, blockY, blockZ, face, this.tags, data.debug);
            this.rayTracing.cleanup();
            this.blockCache.cleanup();
        }
        boolean cancel = false;
        if (collides) {
            data.visibleVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.visibleVL, 1.0, cc.visibleActions);
            if (data.debug || vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            if (this.executeActions(vd)) {
                cancel = true;
            }
        } else {
            data.visibleVL *= 0.99;
        }
        return cancel;
    }

    private boolean checkRayTracing(double eyeX, double eyeY, double eyeZ, double dirX, double dirY, double dirZ, int blockX, int blockY, int blockZ, BlockFace face, List<String> tags, boolean debug) {
        boolean collides;
        int eyeBlockX = Location.locToBlock((double)eyeX);
        int eyeBlockY = Location.locToBlock((double)eyeY);
        int eyeBlockZ = Location.locToBlock((double)eyeZ);
        int bdX = blockX - eyeBlockX;
        int bdY = blockY - eyeBlockY;
        int bdZ = blockZ - eyeBlockZ;
        if (bdX != 0 && dirX * (double)bdX <= 0.0 || bdY != 0 && dirY * (double)bdY <= 0.0 || bdZ != 0 && dirZ * (double)bdZ <= 0.0) {
            tags.add("coarse_orient");
            return true;
        }
        double tMinX = this.getMinTime(eyeX, eyeBlockX, dirX, bdX);
        double tMinY = this.getMinTime(eyeY, eyeBlockY, dirY, bdY);
        double tMinZ = this.getMinTime(eyeZ, eyeBlockZ, dirZ, bdZ);
        double tMaxX = this.getMaxTime(eyeX, eyeBlockX, dirX, tMinX);
        double tMaxY = this.getMaxTime(eyeY, eyeBlockY, dirY, tMinY);
        double tMaxZ = this.getMaxTime(eyeZ, eyeBlockZ, dirZ, tMinZ);
        if (tMinX > tMaxY && tMinX > tMaxZ || tMinY > tMaxX && tMinY > tMaxZ || tMinZ > tMaxX && tMaxZ > tMaxY) {
            tags.add("block_miss");
            return true;
        }
        double tCollide = Math.max(tMinX, Math.max(tMinY, tMinZ));
        double collideX = this.toBlock(eyeX + dirX * tCollide, blockX);
        double collideY = this.toBlock(eyeY + dirY * tCollide, blockY);
        double collideZ = this.toBlock(eyeZ + dirZ * tCollide, blockZ);
        if (tMinX == tCollide) {
            collideX = Math.round(collideX);
        }
        if (tMinY == tCollide) {
            collideY = Math.round(collideY);
        }
        if (tMinZ == tCollide) {
            collideZ = Math.round(collideZ);
        }
        this.rayTracing.set(eyeX, eyeY, eyeZ, collideX, collideY, collideZ, blockX, blockY, blockZ);
        this.rayTracing.loop();
        if (this.rayTracing.collides()) {
            tags.add("raytracing");
            collides = true;
        } else if (this.rayTracing.getStepsDone() > this.rayTracing.getMaxSteps()) {
            tags.add("raytracing_maxsteps");
            collides = true;
        } else {
            collides = false;
        }
        if (!collides || debug) {
            // empty if block
        }
        return collides;
    }

    private double getMinTime(double eye, int eyeBlock, double dir, int blockDiff) {
        if (blockDiff == 0) {
            return 0.0;
        }
        double eyeOffset = Math.abs(eye - (double)eyeBlock);
        return ((dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) + (double)(Math.abs(blockDiff) - 1)) / Math.abs(dir);
    }

    private double getMaxTime(double eye, int eyeBlock, double dir, double tMin) {
        if (dir == 0.0) {
            return Double.MAX_VALUE;
        }
        if (tMin == 0.0) {
            double eyeOffset = Math.abs(eye - (double)eyeBlock);
            return (dir < 0.0 ? eyeOffset : 1.0 - eyeOffset) / Math.abs(dir);
        }
        return tMin + 1.0 / Math.abs(dir);
    }

    private double toBlock(double coord, int block) {
        int blockDiff = block - Location.locToBlock((double)coord);
        if (blockDiff == 0) {
            return coord;
        }
        return Math.round(coord);
    }
}

