/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakData;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Reach
extends Check {
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    public static final double CREATIVE_DISTANCE = 5.6;
    public static final double SURVIVAL_DISTANCE = 5.2;

    public Reach() {
        super(CheckType.BLOCKBREAK_REACH);
    }

    public boolean check(Player player, Block block, BlockBreakData data) {
        boolean cancel = false;
        double distanceLimit = player.getGameMode() == GameMode.CREATIVE ? 5.6 : 5.2;
        Location loc = player.getLocation(this.useLoc);
        loc.setY(loc.getY() + player.getEyeHeight());
        double distance = TrigUtil.distance(loc, block) - distanceLimit;
        this.useLoc.setWorld(null);
        if (distance > 0.0) {
            data.reachVL += distance;
            data.reachDistance = distance;
            ViolationData vd = new ViolationData(this, player, data.reachVL, distance, BlockBreakConfig.getConfig((Player)player).reachActions);
            vd.setParameter(ParameterName.REACH_DISTANCE, String.valueOf(Math.round(data.reachDistance)));
            cancel = this.executeActions(vd);
        } else {
            data.reachVL *= 0.9;
        }
        return cancel;
    }
}

