/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakListener;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractListener;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceListener;
import fr.neatmonster.nocheatplus.checks.chat.ChatListener;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedListener;
import fr.neatmonster.nocheatplus.checks.fight.FightListener;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryListener;
import fr.neatmonster.nocheatplus.checks.moving.MovingListener;
import fr.neatmonster.nocheatplus.clients.ModUtil;
import fr.neatmonster.nocheatplus.command.NoCheatPlusCommand;
import fr.neatmonster.nocheatplus.command.admin.VersionCommand;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.DefaultComponentFactory;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.MCAccessConfig;
import fr.neatmonster.nocheatplus.compat.MCAccessFactory;
import fr.neatmonster.nocheatplus.compat.blocks.BlockChangeTracker;
import fr.neatmonster.nocheatplus.compat.versions.BukkitVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.ComponentRegistry;
import fr.neatmonster.nocheatplus.components.ComponentWithName;
import fr.neatmonster.nocheatplus.components.ConsistencyChecker;
import fr.neatmonster.nocheatplus.components.DisableListener;
import fr.neatmonster.nocheatplus.components.IHoldSubComponents;
import fr.neatmonster.nocheatplus.components.INeedConfig;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.MCAccessHolder;
import fr.neatmonster.nocheatplus.components.NCPListener;
import fr.neatmonster.nocheatplus.components.NameSetPermState;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.PermStateReceiver;
import fr.neatmonster.nocheatplus.components.TickListener;
import fr.neatmonster.nocheatplus.components.order.SetupOrder;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.event.IHaveMethodOrder;
import fr.neatmonster.nocheatplus.event.ListenerManager;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.hooks.allviolations.AllViolationsConfig;
import fr.neatmonster.nocheatplus.hooks.allviolations.AllViolationsHook;
import fr.neatmonster.nocheatplus.logging.BukkitLogManager;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.permissions.PermissionUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.players.PlayerMessageSender;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.updates.Updates;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.OnDemandTickListener;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoCheatPlus
extends JavaPlugin
implements NoCheatPlusAPI {
    private static final String MSG_NOTIFY_OFF = ChatColor.RED + "NCP: " + ChatColor.WHITE + "Notifications are turned " + ChatColor.RED + "OFF" + ChatColor.WHITE + ".";
    private BukkitLogManager logManager = null;
    protected final NameSetPermState nameSetPerms = new NameSetPermState("nocheatplus.notify");
    private final Map<String, Long> denyLoginNames = Collections.synchronizedMap(new HashMap());
    protected MCAccess mcAccess = null;
    protected String configProblems = null;
    protected final DataManager dataMan = new DataManager();
    private int dataManTaskId = -1;
    final LinkedList<PermissionUtil.CommandProtectionEntry> changedCommands = new LinkedList();
    private final ListenerManager listenerManager = new ListenerManager((Plugin)this, false);
    private boolean manageListeners = true;
    protected boolean lateListenerRegistered = false;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final Map<Class<?>, Object> genericInstances = new HashMap();
    private final List<INotifyReload> notifyReload = new LinkedList<INotifyReload>();
    protected boolean useSubscriptions = false;
    protected final List<PermStateReceiver> permStateReceivers = new ArrayList<PermStateReceiver>();
    protected final List<ConsistencyChecker> consistencyCheckers = new ArrayList<ConsistencyChecker>();
    protected int consistencyCheckerIndex = 0;
    protected int consistencyCheckerTaskId = -1;
    protected final List<JoinLeaveListener> joinLeaveListeners = new ArrayList<JoinLeaveListener>();
    protected final List<ComponentRegistry<?>> subRegistries = new ArrayList();
    protected final List<IHoldSubComponents> subComponentholders = new ArrayList<IHoldSubComponents>(20);
    private final List<DisableListener> disableListeners = new ArrayList<DisableListener>();
    protected Set<Object> allComponents = new LinkedHashSet<Object>(50);
    private final LinkedHashMap<String, LinkedHashSet<String>> featureTags = new LinkedHashMap();
    protected final AllViolationsHook allViolationsHook = new AllViolationsHook();
    private final BlockChangeTracker blockChangeTracker = new BlockChangeTracker();
    private BlockChangeTracker.BlockChangeListener blockChangeListener = null;
    protected final OnDemandTickListener onDemandTickListener = new OnDemandTickListener(){

        public boolean delegateTick(int tick, long timeLast) {
            NoCheatPlus.this.processQueuedSubComponentHolders();
            return false;
        }
    };
    private final PlayerMessageSender playerMessageSender = new PlayerMessageSender();
    private boolean clearExemptionsOnJoin = true;
    private boolean clearExemptionsOnLeave = true;

    public static NoCheatPlusAPI getAPI() {
        return NCPAPIProvider.getNoCheatPlusAPI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDenyLoginsNames() {
        long ts = System.currentTimeMillis();
        LinkedList<String> rem = new LinkedList<String>();
        Map<String, Long> map = this.denyLoginNames;
        synchronized (map) {
            for (Map.Entry<String, Long> entry : this.denyLoginNames.entrySet()) {
                if (entry.getValue() >= ts) continue;
                rem.add(entry.getKey());
            }
            for (String name : rem) {
                this.denyLoginNames.remove(name);
            }
        }
    }

    @Override
    public boolean allowLogin(String playerName) {
        Long time = this.denyLoginNames.remove(playerName = playerName.trim().toLowerCase());
        if (time == null) {
            return false;
        }
        return System.currentTimeMillis() <= time;
    }

    @Override
    public int allowLoginAll() {
        int denied = 0;
        long now = System.currentTimeMillis();
        for (String playerName : this.denyLoginNames.keySet()) {
            Long time = this.denyLoginNames.get(playerName);
            if (time == null || time <= now) continue;
            ++denied;
        }
        this.denyLoginNames.clear();
        return denied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void denyLogin(String playerName, long duration) {
        long ts = System.currentTimeMillis() + duration;
        playerName = playerName.trim().toLowerCase();
        Map<String, Long> map = this.denyLoginNames;
        synchronized (map) {
            Long oldTs = this.denyLoginNames.get(playerName);
            if (oldTs != null && ts < oldTs) {
                return;
            }
            this.denyLoginNames.put(playerName, ts);
        }
        this.checkDenyLoginsNames();
    }

    @Override
    public boolean isLoginDenied(String playerName) {
        return this.isLoginDenied(playerName, System.currentTimeMillis());
    }

    @Override
    public String[] getLoginDeniedPlayers() {
        this.checkDenyLoginsNames();
        String[] kicked = new String[this.denyLoginNames.size()];
        this.denyLoginNames.keySet().toArray(kicked);
        return kicked;
    }

    @Override
    public boolean isLoginDenied(String playerName, long time) {
        Long oldTs = this.denyLoginNames.get(playerName = playerName.trim().toLowerCase());
        if (oldTs == null) {
            return false;
        }
        return time < oldTs;
    }

    @Override
    public int sendAdminNotifyMessage(String message) {
        if (this.useSubscriptions) {
            return this.sendAdminNotifyMessageSubscriptions(message);
        }
        return this.sendAdminNotifyMessageStored(message);
    }

    private boolean hasTurnedOffNotifications(String playerName) {
        PlayerData data = DataManager.getPlayerData(playerName, false);
        return data != null && data.getNotifyOff();
    }

    public int sendAdminNotifyMessageStored(String message) {
        Set<String> names = this.nameSetPerms.getPlayers("nocheatplus.notify");
        if (names == null) {
            return 0;
        }
        int done = 0;
        for (String name : names) {
            Player player;
            if (this.hasTurnedOffNotifications(name) || (player = DataManager.getPlayerExact(name)) == null) continue;
            player.sendMessage(message);
            ++done;
        }
        return done;
    }

    public int sendAdminNotifyMessageSubscriptions(String message) {
        Set permissibles = Bukkit.getPluginManager().getPermissionSubscriptions("nocheatplus.notify");
        Set<String> names = this.nameSetPerms.getPlayers("nocheatplus.notify");
        HashSet<String> done = new HashSet<String>(permissibles.size() + (names == null ? 0 : names.size()));
        for (Permissible permissible : permissibles) {
            CommandSender sender;
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission("nocheatplus.notify") || (sender = (CommandSender)permissible) instanceof Player && this.hasTurnedOffNotifications(((Player)sender).getName())) continue;
            sender.sendMessage(message);
            done.add(sender.getName());
        }
        if (names != null) {
            for (String name : names) {
                Player player;
                if (done.contains(name) || (player = DataManager.getPlayerExact(name)) == null || !player.hasPermission("nocheatplus.notify") || this.hasTurnedOffNotifications(player.getName())) continue;
                player.sendMessage(message);
                done.add(name);
            }
        }
        return done.size();
    }

    @Override
    public void sendMessageOnTick(String playerName, String message) {
        this.playerMessageSender.sendMessageThreadSafe(playerName, message);
    }

    @Override
    public <T> Collection<ComponentRegistry<T>> getComponentRegistries(Class<ComponentRegistry<T>> clazz) {
        LinkedList<ComponentRegistry<T>> result = new LinkedList<ComponentRegistry<T>>();
        for (ComponentRegistry<?> registry : this.subRegistries) {
            if (!clazz.isAssignableFrom(registry.getClass())) continue;
            try {
                result.add(registry);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @Override
    public boolean addComponent(Object obj) {
        return this.addComponent(obj, true);
    }

    @Override
    public boolean addComponent(Object obj, boolean allowComponentRegistry) {
        if (obj == this) {
            throw new IllegalArgumentException("Can not register NoCheatPlus with itself.");
        }
        if (this.allComponents.contains(obj)) {
            return false;
        }
        boolean added = false;
        if (obj instanceof Listener) {
            this.addListener((Listener)obj);
            added = true;
        }
        if (obj instanceof INotifyReload) {
            this.notifyReload.add((INotifyReload)obj);
            if (obj instanceof INeedConfig) {
                ((INeedConfig)obj).onReload();
            }
            added = true;
        }
        if (obj instanceof TickListener) {
            TickTask.addTickListener((TickListener)obj);
            added = true;
        }
        if (obj instanceof PermStateReceiver) {
            this.permStateReceivers.add((PermStateReceiver)obj);
            added = true;
        }
        if (obj instanceof MCAccessHolder) {
            ((MCAccessHolder)obj).setMCAccess(this.getMCAccess());
            added = true;
        }
        if (obj instanceof ConsistencyChecker) {
            this.consistencyCheckers.add((ConsistencyChecker)obj);
            added = true;
        }
        if (obj instanceof JoinLeaveListener) {
            this.joinLeaveListeners.add((JoinLeaveListener)obj);
            added = true;
        }
        if (obj instanceof DisableListener) {
            this.disableListeners.add((DisableListener)obj);
            added = true;
        }
        for (ComponentRegistry<?> registry : this.subRegistries) {
            Object res = ReflectionUtil.invokeGenericMethodOneArg(registry, "addComponent", obj);
            if (res == null || !(res instanceof Boolean) || !((Boolean)res).booleanValue()) continue;
            added = true;
        }
        if (allowComponentRegistry && obj instanceof ComponentRegistry) {
            this.subRegistries.add((ComponentRegistry)obj);
            added = true;
        }
        if (obj instanceof IHoldSubComponents) {
            this.subComponentholders.add((IHoldSubComponents)obj);
            this.onDemandTickListener.register();
            added = true;
        }
        if (added) {
            this.allComponents.add(obj);
        }
        return added;
    }

    private void addListener(Listener listener) {
        if (this.manageListeners) {
            String tag = "NoCheatPlus";
            if (listener instanceof ComponentWithName) {
                tag = ((ComponentWithName)listener).getComponentName();
            }
            this.listenerManager.registerAllEventHandlers(listener, tag);
            this.listeners.add(listener);
        } else {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
            if (listener instanceof IHaveMethodOrder) {
                this.logManager.warning(Streams.INIT, "Listener demands registration order, but listeners are not managed: " + listener.getClass().getName());
            }
        }
    }

    public boolean doesManageListeners() {
        return this.manageListeners;
    }

    @Override
    public void removeComponent(Object obj) {
        if (obj instanceof Listener) {
            this.listeners.remove((Listener)obj);
            this.listenerManager.remove((Listener)obj);
        }
        if (obj instanceof PermStateReceiver) {
            this.permStateReceivers.remove((PermStateReceiver)obj);
        }
        if (obj instanceof TickListener) {
            TickTask.removeTickListener((TickListener)obj);
        }
        if (obj instanceof INotifyReload) {
            this.notifyReload.remove((INotifyReload)obj);
        }
        if (obj instanceof ConsistencyChecker) {
            this.consistencyCheckers.remove((ConsistencyChecker)obj);
        }
        if (obj instanceof JoinLeaveListener) {
            this.joinLeaveListeners.remove((JoinLeaveListener)obj);
        }
        if (obj instanceof DisableListener) {
            this.disableListeners.remove((DisableListener)obj);
        }
        if (obj instanceof ComponentRegistry) {
            this.subRegistries.remove((ComponentRegistry)obj);
        }
        for (ComponentRegistry<?> registry : this.subRegistries) {
            ReflectionUtil.invokeGenericMethodOneArg(registry, "removeComponent", obj);
        }
        this.allComponents.remove(obj);
    }

    public void onDisable() {
        boolean verbose = ConfigManager.getConfigFile().getBoolean("logging.extended.status");
        if (verbose) {
            if (this.listenerManager.hasListenerMethods()) {
                this.logManager.info(Streams.INIT, "Cleanup ListenerManager...");
            } else {
                this.logManager.info(Streams.INIT, "(ListenerManager not in use, prevent registering...)");
            }
        }
        this.listenerManager.setRegisterDirectly(false);
        this.listenerManager.clear();
        this.lateListenerRegistered = false;
        BukkitScheduler sched = this.getServer().getScheduler();
        if (this.dataManTaskId != -1) {
            sched.cancelTask(this.dataManTaskId);
            this.dataManTaskId = -1;
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Stop TickTask...");
        }
        TickTask.setLocked(true);
        TickTask.purge();
        TickTask.cancel();
        TickTask.removeAllTickListeners();
        if (this.consistencyCheckerTaskId != -1) {
            sched.cancelTask(this.consistencyCheckerTaskId);
            this.consistencyCheckerTaskId = -1;
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Stop all remaining tasks...");
        }
        sched.cancelTasks((Plugin)this);
        this.allViolationsHook.unregister();
        NCPHookManager.removeAllHooks();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Reset ExemptionManager...");
        }
        NCPExemptionManager.clear();
        if (verbose) {
            this.logManager.info(Streams.INIT, "onDisable calls (include DataManager cleanup)...");
        }
        for (DisableListener dl : this.disableListeners) {
            try {
                dl.onDisable();
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "DisableListener (" + dl.getClass().getName() + "): " + t.getClass().getSimpleName() + " / " + t.getMessage());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        Counters counters = this.getGenericInstance(Counters.class);
        if (counters != null) {
            if (verbose) {
                this.logManager.info(Streams.INIT, counters.getMergedCountsString(true));
            } else {
                this.logManager.debug(Streams.TRACE_FILE, counters.getMergedCountsString(true));
            }
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Unregister all registered components...");
        }
        ArrayList<Object> components = new ArrayList<Object>(this.allComponents);
        for (int i = components.size() - 1; i >= 0; --i) {
            this.removeComponent(components.get(i));
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup BlockProperties...");
        }
        BlockProperties.cleanup();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup some mappings...");
        }
        this.listeners.clear();
        this.notifyReload.clear();
        this.permStateReceivers.clear();
        this.subRegistries.clear();
        this.subComponentholders.clear();
        this.genericInstances.clear();
        this.featureTags.clear();
        this.blockChangeTracker.clear();
        if (this.blockChangeListener != null) {
            this.blockChangeListener.setEnabled(false);
            this.blockChangeListener = null;
        }
        this.changedCommands.clear();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup ConfigManager...");
        }
        ConfigManager.cleanup();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Shutdown LogManager...");
        }
        StaticLog.setUseLogManager(false);
        StaticLog.setStreamID(Streams.INIT);
        this.logManager.shutdown();
        if (verbose) {
            Bukkit.getLogger().info("All cleanup done.");
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        Bukkit.getLogger().info("Version " + pdfFile.getVersion() + " is disabled.");
    }

    public void undoCommandChanges() {
        if (!this.changedCommands.isEmpty()) {
            Iterator<PermissionUtil.CommandProtectionEntry> it = this.changedCommands.descendingIterator();
            while (it.hasNext()) {
                it.next().restore();
            }
            this.changedCommands.clear();
        }
    }

    protected void setupCommandProtection() {
        List noCommand;
        ConfigFile config = ConfigManager.getConfigFile();
        List noPerm = config.getStringList("protection.plugins.hide.nopermission.commands");
        if (noPerm != null && !noPerm.isEmpty()) {
            String noPermMsg = ColorUtil.replaceColors(ConfigManager.getConfigFile().getString("protection.plugins.hide.nopermission.message"));
            this.changedCommands.addAll(PermissionUtil.protectCommands("nocheatplus.filter.command", noPerm, true, false, noPermMsg));
        }
        if ((noCommand = config.getStringList("protection.plugins.hide.unknowncommand.commands")) != null && !noCommand.isEmpty()) {
            String noCommandMsg = ColorUtil.replaceColors(ConfigManager.getConfigFile().getString("protection.plugins.hide.unknowncommand.message"));
            this.changedCommands.addAll(PermissionUtil.protectCommands("nocheatplus.filter.command", noCommand, true, false, noCommandMsg));
        }
    }

    public void onLoad() {
        Bukkit.getLogger().info("onLoad: Early set up of static API, configuration, logging.");
        this.setupBasics();
    }

    private void setupBasics() {
        if (NCPAPIProvider.getNoCheatPlusAPI() == null) {
            NCPAPIProvider.setNoCheatPlusAPI(this);
        }
        if (ServerVersion.getMinecraftVersion() == "unknown") {
            BukkitVersion.init();
        }
        if (!ConfigManager.isInitialized()) {
            ConfigManager.init((Plugin)this);
        }
        if (this.logManager == null || this.logManager.getStreamID(Streams.STATUS.name) != Streams.STATUS) {
            this.logManager = new BukkitLogManager((Plugin)this);
            StaticLog.setStreamID(Streams.INIT);
            StaticLog.setUseLogManager(true);
            this.logManager.info(Streams.INIT, "Logging system initialized.");
            this.logManager.info(Streams.INIT, "Detected Minecraft version: " + ServerVersion.getMinecraftVersion());
        }
    }

    public void onEnable() {
        TickTask.setLocked(true);
        TickTask.purge();
        TickTask.cancel();
        TickTask.reset();
        TickTask.setLocked(false);
        this.setupBasics();
        this.logManager.startTasks();
        ConfigFile config = ConfigManager.getConfigFile();
        this.setInstanceMembers(config);
        this.manageListeners = config.getBoolean("compatibility.managelisteners");
        if (this.manageListeners) {
            this.listenerManager.setRegisterDirectly(true);
            this.listenerManager.registerAllWithBukkit();
        } else {
            this.listenerManager.setRegisterDirectly(false);
            this.listenerManager.clear();
        }
        this.registerGenericInstance(new Counters());
        this.initMCAccess(config);
        this.initBlockProperties(config);
        this.disableListeners.add(0, this.dataMan);
        this.dataMan.onEnable();
        @SetupOrder(priority=-100)
        class ReloadHook
        implements INotifyReload {
            ReloadHook() {
            }

            public void onReload() {
                NoCheatPlus.this.processReload();
            }
        }
        for (Object obj : new Object[]{this.nameSetPerms, this.getCoreListener(), new ReloadHook(), this.dataMan}) {
            this.addComponent(obj);
            this.processQueuedSubComponentHolders();
        }
        this.updateBlockChangeTracker(config);
        for (Object obj : new Object[]{new BlockInteractListener(), new BlockBreakListener(), new BlockPlaceListener(), new ChatListener(), new CombinedListener(), new FightListener(), new InventoryListener(), new MovingListener()}) {
            this.addComponent(obj);
            this.processQueuedSubComponentHolders();
        }
        DefaultComponentFactory dcf = new DefaultComponentFactory();
        for (Object obj : dcf.getAvailableComponentsOnEnable(this)) {
            this.addComponent(obj);
            this.processQueuedSubComponentHolders();
        }
        PluginCommand command = this.getCommand("nocheatplus");
        NoCheatPlusCommand commandHandler = new NoCheatPlusCommand(this, this.notifyReload);
        command.setExecutor((CommandExecutor)commandHandler);
        TickTask.start((Plugin)this);
        this.dataManTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            public void run() {
                NoCheatPlus.this.dataMan.checkExpiration();
            }
        }, 1207L, 1207L);
        this.scheduleConsistencyCheckers();
        this.allViolationsHook.setConfig(new AllViolationsConfig(config));
        if (this.configProblems != null && config.getBoolean("configversion.notify")) {
            this.logManager.warning(Streams.INIT, "" + this.configProblems);
        }
        Player[] onlinePlayers = BridgeMisc.getOnlinePlayers();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new PostEnableTask(commandHandler, onlinePlayers));
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            public void run() {
                NoCheatPlus.this.midTermCleanup();
            }
        }, 83L, 83L);
        StaticLog.setStreamID(Streams.STATUS);
        this.logManager.info(Streams.INIT, "Version " + this.getDescription().getVersion() + " is enabled.");
    }

    protected void postEnable(NoCheatPlusCommand commandHandler, Player[] onlinePlayers) {
        this.logManager.info(Streams.INIT, "Post-enable running...");
        try {
            PermissionUtil.addChildPermission(commandHandler.getAllSubCommandPermissions(), "nocheatplus.filter.command.nocheatplus", PermissionDefault.OP);
        }
        catch (Throwable t) {
            this.logManager.severe(Streams.INIT, "Failed to complement permissions: " + t.getClass().getSimpleName());
            this.logManager.severe(Streams.INIT, t);
        }
        try {
            if (ConfigManager.getConfigFile().getBoolean("protection.plugins.hide.active")) {
                this.setupCommandProtection();
            }
        }
        catch (Throwable t) {
            this.logManager.severe(Streams.INIT, "Failed to apply command protection: " + t.getClass().getSimpleName());
            this.logManager.severe(Streams.INIT, t);
        }
        for (Player player : onlinePlayers) {
            this.updatePermStateReceivers(player);
            if (!player.isSleeping()) continue;
            CombinedData.getData((Player)player).wasInBed = true;
        }
        if (onlinePlayers.length > 0) {
            this.logManager.info(Streams.INIT, "Updated data for " + onlinePlayers.length + " players (post-enable).");
        }
        Bukkit.getPluginManager().registerEvents(this.getLateListener(), (Plugin)this);
        this.lateListenerRegistered = true;
        this.logManager.info(Streams.INIT, "Post-enable finished.");
        this.logManager.info(Streams.DEFAULT_FILE, StringUtil.join(VersionCommand.getVersionInfo(), "\n"));
    }

    protected void processQueuedSubComponentHolders() {
        if (this.subComponentholders.isEmpty()) {
            return;
        }
        ArrayList<IHoldSubComponents> copied = new ArrayList<IHoldSubComponents>(this.subComponentholders);
        this.subComponentholders.clear();
        for (IHoldSubComponents holder : copied) {
            for (Object component : holder.getSubComponents()) {
                this.addComponent(component);
            }
        }
    }

    protected void processReload() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.setInstanceMembers(config);
        this.initMCAccess(config);
        this.initBlockProperties(config);
        this.undoCommandChanges();
        if (config.getBoolean("protection.plugins.hide.active")) {
            this.setupCommandProtection();
        }
        this.scheduleConsistencyCheckers();
        this.allViolationsHook.setConfig(new AllViolationsConfig(config));
        this.updateBlockChangeTracker(config);
    }

    private void setInstanceMembers(ConfigFile config) {
        this.configProblems = Updates.isConfigUpToDate(config);
        this.useSubscriptions = config.getBoolean("logging.backend.ingamechat.subscriptions");
        this.clearExemptionsOnJoin = config.getBoolean("compatibility.exemptions.remove.join");
        this.clearExemptionsOnLeave = config.getBoolean("compatibility.exemptions.remove.leave");
    }

    private void updateBlockChangeTracker(ConfigFile config) {
        if (config.getBoolean("compatibility.blocks.changetracker.active") && config.getBoolean("compatibility.blocks.changetracker.pistons")) {
            if (this.blockChangeListener == null) {
                this.blockChangeListener = new BlockChangeTracker.BlockChangeListener(this.blockChangeTracker);
                this.addComponent(this.blockChangeListener);
            }
            this.blockChangeListener.setEnabled(true);
        } else if (this.blockChangeListener != null) {
            this.blockChangeListener.setEnabled(false);
            this.blockChangeTracker.clear();
        }
    }

    @Override
    public LogManager getLogManager() {
        return this.logManager;
    }

    @Override
    public MCAccess getMCAccess() {
        if (this.mcAccess == null) {
            this.initMCAccess();
        }
        return this.mcAccess;
    }

    private void initMCAccess() {
        this.getServer().getScheduler().callSyncMethod((Plugin)this, (Callable)new Callable<MCAccess>(){

            @Override
            public MCAccess call() throws Exception {
                if (NoCheatPlus.this.mcAccess != null) {
                    return NoCheatPlus.this.mcAccess;
                }
                return NoCheatPlus.this.initMCAccess(ConfigManager.getConfigFile());
            }
        });
    }

    public MCAccess initMCAccess(ConfigFile config) {
        MCAccess mcAccess = new MCAccessFactory().getMCAccess(new MCAccessConfig(config));
        this.setMCAccess(mcAccess);
        return mcAccess;
    }

    @Override
    public void setMCAccess(MCAccess mcAccess) {
        this.mcAccess = mcAccess;
        for (Object obj : this.allComponents) {
            if (!(obj instanceof MCAccessHolder)) continue;
            try {
                ((MCAccessHolder)obj).setMCAccess(mcAccess);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "MCAccessHolder(" + obj.getClass().getName() + ") failed to set MCAccess: " + t.getClass().getSimpleName());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        this.logManager.info(Streams.INIT, "McAccess set to: " + mcAccess.getMCVersion() + " / " + mcAccess.getServerVersionTag());
    }

    protected void initBlockProperties(ConfigFile config) {
        BlockProperties.init(this.getMCAccess(), ConfigManager.getWorldConfigProvider());
        BlockProperties.applyConfig(config, "compatibility.blocks.");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            public void run() {
                ConfigFile config = ConfigManager.getConfigFile();
                BlockProperties.dumpBlocks(config.getBoolean("checks.blockbreak.debug", config.getBoolean("checks.debug", false)));
            }
        });
    }

    private Listener getLateListener() {
        return new NCPListener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public void onPlayerJoinLowestLate(PlayerJoinEvent event) {
                NoCheatPlus.this.updatePermStateReceivers(event.getPlayer());
            }
        };
    }

    private Listener getCoreListener() {
        return new NCPListener(){

            @EventHandler(priority=EventPriority.NORMAL)
            public void onPlayerLogin(PlayerLoginEvent event) {
                if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
                    return;
                }
                Player player = event.getPlayer();
                NoCheatPlus.this.checkDenyLoginsNames();
                if (player.hasPermission("nocheatplus.bypassdenylogin")) {
                    return;
                }
                if (NoCheatPlus.this.isLoginDenied(player.getName())) {
                    event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
                    event.setKickMessage("You are temporarily denied to join this server.");
                }
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onPlayerJoinLowest(PlayerJoinEvent event) {
                Player player = event.getPlayer();
                if (!NoCheatPlus.this.lateListenerRegistered) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Player " + player.getName() + " joins before the post-enable task has run.");
                } else {
                    NoCheatPlus.this.updatePermStateReceivers(player);
                }
                if (NoCheatPlus.this.clearExemptionsOnJoin) {
                    NCPExemptionManager.unexempt(player);
                }
            }

            @EventHandler(priority=EventPriority.LOW)
            public void onPlayerJoinLow(PlayerJoinEvent event) {
                NoCheatPlus.this.onJoinLow(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onPlayerchangedWorld(PlayerChangedWorldEvent event) {
                NoCheatPlus.this.updatePermStateReceivers(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onPlayerKick(PlayerKickEvent event) {
                NoCheatPlus.this.onLeave(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public void onPlayerQuit(PlayerQuitEvent event) {
                NoCheatPlus.this.onLeave(event.getPlayer());
            }
        };
    }

    protected void onJoinLow(Player player) {
        String playerName = player.getName();
        if (this.nameSetPerms.hasPermission(playerName, "nocheatplus.notify")) {
            PlayerData data = DataManager.getPlayerData(playerName, true);
            if (this.configProblems != null && ConfigManager.getConfigFile().getBoolean("configversion.notify")) {
                this.sendMessageOnTick(playerName, ChatColor.RED + "NCP: " + ChatColor.WHITE + this.configProblems);
            }
            if (data.getNotifyOff()) {
                this.sendMessageOnTick(playerName, MSG_NOTIFY_OFF);
            }
        }
        for (JoinLeaveListener jlListener : this.joinLeaveListeners) {
            try {
                jlListener.playerJoins(player);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "JoinLeaveListener(" + jlListener.getClass().getName() + ") generated an exception (join): " + t.getClass().getSimpleName());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        ModUtil.motdOnJoin(player);
    }

    protected void onLeave(Player player) {
        for (PermStateReceiver pr : this.permStateReceivers) {
            pr.removePlayer(player.getName());
        }
        for (JoinLeaveListener jlListener : this.joinLeaveListeners) {
            try {
                jlListener.playerLeaves(player);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "JoinLeaveListener(" + jlListener.getClass().getName() + ") generated an exception (leave): " + t.getClass().getSimpleName());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        if (this.clearExemptionsOnLeave) {
            NCPExemptionManager.unexempt(player);
        }
    }

    protected void updatePermStateReceivers(Player player) {
        HashMap<String, Boolean> checked = new HashMap<String, Boolean>(20);
        String name = player.getName();
        for (PermStateReceiver pr : this.permStateReceivers) {
            for (String permission : pr.getDefaultPermissions()) {
                Boolean state = (Boolean)checked.get(permission);
                if (state == null) {
                    state = player.hasPermission(permission);
                    checked.put(permission, state);
                }
                pr.setPermission(name, permission, state);
            }
        }
    }

    protected void scheduleConsistencyCheckers() {
        ConfigFile config;
        BukkitScheduler sched = this.getServer().getScheduler();
        if (this.consistencyCheckerTaskId != -1) {
            sched.cancelTask(this.consistencyCheckerTaskId);
        }
        if (!(config = ConfigManager.getConfigFile()).getBoolean("data.consistencychecks.active", true)) {
            return;
        }
        long delay = 20L * config.getInt("data.consistencychecks.interval", 1, 3600, 10);
        this.consistencyCheckerTaskId = sched.scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            public void run() {
                NoCheatPlus.this.runConsistencyChecks();
            }
        }, delay, delay);
    }

    protected void midTermCleanup() {
        if (this.blockChangeListener != null && this.blockChangeListener.isEnabled()) {
            this.blockChangeTracker.checkExpiration(TickTask.getTick());
        }
    }

    protected void runConsistencyChecks() {
        long tStart = System.currentTimeMillis();
        ConfigFile config = ConfigManager.getConfigFile();
        if (!config.getBoolean("data.consistencychecks.active") || this.consistencyCheckers.isEmpty()) {
            this.consistencyCheckerIndex = 0;
            return;
        }
        long tEnd = tStart + config.getLong("data.consistencychecks.maxtime", 1L, 50L, 2L);
        if (this.consistencyCheckerIndex >= this.consistencyCheckers.size()) {
            this.consistencyCheckerIndex = 0;
        }
        Player[] onlinePlayers = BridgeMisc.getOnlinePlayers();
        while (this.consistencyCheckerIndex < this.consistencyCheckers.size()) {
            ConsistencyChecker checker = this.consistencyCheckers.get(this.consistencyCheckerIndex);
            try {
                checker.checkConsistency(onlinePlayers);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "ConsistencyChecker(" + checker.getClass().getName() + ") encountered an exception:");
                this.logManager.severe(Streams.INIT, t);
            }
            ++this.consistencyCheckerIndex;
            long now = System.currentTimeMillis();
            if (now >= tStart && now < tEnd) continue;
            break;
        }
        if (this.consistencyCheckerIndex < this.consistencyCheckers.size()) {
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                public void run() {
                    NoCheatPlus.this.runConsistencyChecks();
                }
            });
            if (config.getBoolean("logging.extended.status")) {
                this.logManager.info(Streams.STATUS, "Interrupted consistency checking until next tick.");
            }
        }
    }

    @Override
    public <T> T registerGenericInstance(T instance) {
        Class<?> clazz = instance.getClass();
        Object registered = this.getGenericInstance(clazz);
        this.genericInstances.put(clazz, instance);
        return (T)registered;
    }

    @Override
    public <T, TI extends T> T registerGenericInstance(Class<T> registerFor, TI instance) {
        T registered = this.getGenericInstance(registerFor);
        this.genericInstances.put(registerFor, instance);
        return registered;
    }

    @Override
    public <T> T getGenericInstance(Class<T> registeredFor) {
        return (T)this.genericInstances.get(registeredFor);
    }

    @Override
    public <T> T unregisterGenericInstance(Class<T> registeredFor) {
        T registered = this.getGenericInstance(registeredFor);
        this.genericInstances.remove(registeredFor);
        return registered;
    }

    @Override
    public void addFeatureTags(String key, Collection<String> featureTags) {
        LinkedHashSet<String> present = this.featureTags.get(key);
        if (present == null) {
            present = new LinkedHashSet();
            this.featureTags.put(key, present);
        }
        present.addAll(featureTags);
    }

    @Override
    public void setFeatureTags(String key, Collection<String> featureTags) {
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        this.featureTags.put(key, present);
        present.addAll(featureTags);
    }

    @Override
    public boolean hasFeatureTag(String key, String feature) {
        Collection features = this.featureTags.get(key);
        return features == null ? false : features.contains(feature);
    }

    @Override
    public Map<String, Set<String>> getAllFeatureTags() {
        LinkedHashMap allTags = new LinkedHashMap();
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.featureTags.entrySet()) {
            allTags.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        return Collections.unmodifiableMap(allTags);
    }

    @Override
    public BlockChangeTracker getBlockChangeTracker() {
        return this.blockChangeTracker;
    }

    private class PostEnableTask
    implements Runnable {
        private final NoCheatPlusCommand commandHandler;
        private final Player[] onlinePlayers;

        protected PostEnableTask(NoCheatPlusCommand commandHandler, Player[] onlinePlayers) {
            this.commandHandler = commandHandler;
            this.onlinePlayers = onlinePlayers;
        }

        public void run() {
            NoCheatPlus.this.postEnable(this.commandHandler, this.onlinePlayers);
        }
    }
}

