/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.utilities.ds.corw.LinkedHashMapCOW;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigCache<K, C> {
    private final Map<K, C> configs;
    private final boolean cow;

    public ConfigCache(boolean cow, int initialCapacity) {
        this.cow = cow;
        this.configs = cow ? new LinkedHashMapCOW<K, C>(initialCapacity) : new HashMap<K, C>(initialCapacity);
    }

    public boolean hasConfig(K key) {
        return this.configs.containsKey(key);
    }

    public C getConfig(K key) {
        C config = this.configs.get(key);
        if (config == null) {
            return this.createConfig(key);
        }
        return config;
    }

    private C createConfig(K key) {
        C config = this.newConfig(key);
        if (!this.cow) {
            this.configs.put(key, config);
            return config;
        }
        return this.addConfigCOW(key, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C addConfigCOW(K key, C config) {
        Map<K, C> map = this.configs;
        synchronized (map) {
            if (this.configs.containsKey(key)) {
                return this.configs.get(key);
            }
            this.configs.put(key, config);
            return config;
        }
    }

    public void clearAllConfigs() {
        this.configs.clear();
    }

    protected abstract C newConfig(K var1);
}

