/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.NoCheatPlusCommand;
import fr.neatmonster.nocheatplus.command.admin.VersionCommand;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.order.Order;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadCommand
extends BaseCommand {
    private final List<INotifyReload> notifyReload;

    public ReloadCommand(JavaPlugin plugin, List<INotifyReload> notifyReload) {
        super(plugin, "reload", "nocheatplus.command.reload");
        this.notifyReload = notifyReload;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            return false;
        }
        this.handleReloadCommand(sender);
        return true;
    }

    private void handleReloadCommand(CommandSender sender) {
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        if (!sender.equals(Bukkit.getConsoleSender())) {
            sender.sendMessage(TAG + "Reloading configuration...");
        }
        logManager.info(Streams.INIT, TAG + "Reloading configuration...");
        ConfigManager.cleanup();
        ConfigManager.init((Plugin)this.access);
        if (logManager instanceof INotifyReload) {
            ((INotifyReload)((Object)logManager)).onReload();
        }
        DataManager.clearConfigs();
        for (CheckType checkType : new CheckType[]{CheckType.BLOCKBREAK, CheckType.FIGHT}) {
            DataManager.clearData(checkType);
        }
        DataManager.restoreDefaultDebugFlags();
        Collections.sort(this.notifyReload, Order.cmpSetupOrder);
        for (INotifyReload component : this.notifyReload) {
            component.onReload();
        }
        Bukkit.getPluginManager().callEvent((Event)new NoCheatPlusCommand.NCPReloadEvent());
        if (!sender.equals(Bukkit.getConsoleSender())) {
            sender.sendMessage(TAG + "Configuration reloaded!");
        }
        logManager.info(Streams.INIT, TAG + "Configuration reloaded.");
        logManager.info(Streams.DEFAULT_FILE, StringUtil.join(VersionCommand.getVersionInfo(), "\n"));
    }
}

