/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetConfigCache;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SoundDistance
extends BaseAdapter {
    private static final Set<String> effectNames = new HashSet<String>(Arrays.asList("ambient.weather.thunder", "wither-spawn-sound-radius", "mob.wither.spawn", "mob.wither.shoot", "mob.wither.idle", "mob.wither.hurt", "mob.wither.death", "dragon-death-sound-radius", "mob.enderdragon.wings", "mob.enderdragon.grow", "mob.enderdragon.growl", "mob.enderdragon.hit", "mob.enderdragon.end", "game.neutral.die"));
    private final Integer idSoundEffectCancel;
    private final NetConfigCache configs;
    private final Location useLoc;

    public SoundDistance(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, PacketType.Play.Server.NAMED_SOUND_EFFECT);
        this.idSoundEffectCancel = this.counters.registerKey("packet.sound.cancel");
        this.useLoc = new Location(null, 0.0, 0.0, 0.0);
        this.configs = (NetConfigCache)CheckType.NET.getConfigFactory();
    }

    public void onPacketSending(PacketEvent event) {
        PacketContainer packetContainer = event.getPacket();
        String soundName = (String)packetContainer.getStrings().read(0);
        if (!effectNames.contains(soundName)) {
            return;
        }
        Player player = event.getPlayer();
        NetConfig cc = (NetConfig)this.configs.getConfig(player.getWorld());
        if (!cc.soundDistanceActive) {
            return;
        }
        Location loc = player.getLocation(this.useLoc);
        StructureModifier ints = packetContainer.getIntegers();
        double dSq = TrigUtil.distanceSquared((Integer)ints.read(0) / 8, (Integer)ints.read(2) / 8, loc.getX(), loc.getZ());
        if (dSq > cc.soundDistanceSq) {
            event.setCancelled(true);
            this.counters.add(this.idSoundEffectCancel, 1);
        }
        this.useLoc.setWorld(null);
    }
}

