/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.logging.Streams;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class OutgoingPosition
extends BaseAdapter {
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;

    public OutgoingPosition(Plugin plugin) {
        super(plugin, ListenerPriority.HIGHEST, PacketType.Play.Server.POSITION);
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        NetConfig cc = this.configFactory.getConfig(player);
        if (cc.flyingFrequencyActive) {
            NetData data = this.dataFactory.getData(player);
            DataPacketFlying packetData = this.interpretPacket(event.getPacket(), time, data);
            if (packetData != null && data.debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Expect ACK on outgoing position: " + packetData);
            }
        }
    }

    private DataPacketFlying interpretPacket(PacketContainer packet, long time, NetData data) {
        StructureModifier doubles = packet.getDoubles();
        StructureModifier floats = packet.getFloat();
        if (doubles.size() != 3 || floats.size() != 2) {
            this.packetMismatch(packet);
            return null;
        }
        double x = (Double)doubles.read(0);
        double y = (Double)doubles.read(1);
        double z = (Double)doubles.read(2);
        float yaw = ((Float)floats.read(0)).floatValue();
        float pitch = ((Float)floats.read(1)).floatValue();
        return data.teleportQueue.onOutgoingTeleport(x, y, z, yaw, pitch);
    }

    private void packetMismatch(PacketContainer packet) {
    }
}

