/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.model;

public class DataPacketFlying {
    public final boolean onGround;
    public final boolean hasPos;
    public final boolean hasLook;
    public final double x;
    public final double y;
    public final double z;
    public final float yaw;
    public final float pitch;
    public final long time;

    public DataPacketFlying(boolean onGround, long time) {
        this.onGround = onGround;
        this.hasPos = false;
        this.hasLook = false;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
        this.time = time;
    }

    public DataPacketFlying(boolean onGround, float yaw, float pitch, long time) {
        this.onGround = onGround;
        this.hasPos = false;
        this.hasLook = true;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.yaw = yaw;
        this.pitch = pitch;
        this.time = time;
    }

    public DataPacketFlying(boolean onGround, double x, double y, double z, long time) {
        this.onGround = onGround;
        this.hasPos = true;
        this.hasLook = false;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
        this.time = time;
    }

    public DataPacketFlying(boolean onGround, double x, double y, double z, float yaw, float pitch, long time) {
        this.onGround = onGround;
        this.hasPos = true;
        this.hasLook = true;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.time = time;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("Flying(ground=");
        builder.append(this.onGround);
        if (this.hasPos) {
            builder.append(",x=");
            builder.append(this.x);
            builder.append(",y=");
            builder.append(this.y);
            builder.append(",z=");
            builder.append(this.z);
        }
        if (this.hasLook) {
            builder.append(",pitch=");
            builder.append(this.pitch);
            builder.append(",yaw=");
            builder.append(this.yaw);
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean containsSameLocation(DataPacketFlying other) {
        return this.hasPos && other.hasPos && this.hasLook && other.hasLook && this.y == other.y && this.x == other.x && this.z == other.z && this.pitch == other.pitch && this.yaw == other.yaw;
    }

    public boolean matches(double x, double y, double z, float yaw, float pitch) {
        return this.hasPos && this.hasLook && x == this.x && y == this.y && z == this.z && yaw == this.yaw && pitch == this.pitch;
    }
}

