/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveData;
import fr.neatmonster.nocheatplus.compat.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.blocks.BlockChangeTracker;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionAccumulator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurvivalFly
extends Check {
    private static final String DOUBLE_BUNNY = "doublebunny";
    public static final double walkSpeed = 0.221;
    public static final double modSneak = 0.5882352941176471;
    public static final double modBlock = 0.7239819004524887;
    public static final double modSwim = 0.5203619909502263;
    public static final double[] modDepthStrider = new double[]{1.0, 1.4304347826086956, 1.734782608695652, 1.9217391304347824};
    public static final double modWeb = 0.4751131221719457;
    public static final double modIce = 2.5;
    public static final double modDownStream = 1.6521739130434783;
    public static final double hBufMax = 1.0;
    public static final double climbSpeed = 0.2873;
    private static final int bunnyHopMax = 10;
    private static final double bunnyDivFriction = 160.0;
    public static final double GRAVITY_MAX = 0.0834;
    public static final double GRAVITY_MIN = 0.0624;
    public static final double GRAVITY_SPAN = 0.021000000000000005;
    public static final double GRAVITY_ODD = 0.05;
    public static final float GRAVITY_VACC = 0.03744f;
    public static final double FRICTION_MEDIUM_AIR = 0.98;
    public static final double FRICTION_MEDIUM_WATER = 0.89;
    public static final double FRICTION_MEDIUM_LAVA = 0.535;
    private final ArrayList<String> tags = new ArrayList(15);
    private final Set<String> reallySneaking = new HashSet<String>(30);
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final BlockChangeTracker blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();

    public SurvivalFly() {
        super(CheckType.MOVING_SURVIVALFLY);
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, boolean isSamePos, MoveData moveData, MovingData data, MovingConfig cc, long now) {
        int tagsLength;
        double[] pushResult;
        double[] res;
        boolean downStream;
        boolean sprinting;
        boolean resetTo;
        boolean hasHdist;
        double xDistance;
        double yDistance;
        double zDistance;
        double hDistance;
        this.tags.clear();
        if (isSamePos) {
            hDistance = 0.0;
            zDistance = 0.0;
            yDistance = 0.0;
            xDistance = 0.0;
            hasHdist = false;
        } else {
            xDistance = to.getX() - from.getX();
            yDistance = moveData.yDistance;
            zDistance = to.getZ() - from.getZ();
            if (xDistance == 0.0 && zDistance == 0.0) {
                hDistance = 0.0;
                hasHdist = false;
            } else {
                hasHdist = true;
                hDistance = moveData.hDistance;
            }
        }
        if (!data.hasSetBack()) {
            data.setSetBack(from);
        } else if (data.joinOrRespawn && from.getY() > data.getSetBackY() && TrigUtil.isSamePos(from.getX(), from.getZ(), data.getSetBackX(), data.getSetBackZ()) && (from.isOnGround() || from.isResetCond())) {
            if (data.debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " SurvivalFly\nAdjust set-back after join/respawn: " + from.getLocation());
            }
            data.setSetBack(from);
            data.resetPositions(from);
        }
        boolean fromOnGround = from.isOnGround();
        boolean toOnGround = to.isOnGround();
        boolean bl = resetTo = toOnGround || to.isResetCond();
        if (data.lostSprintCount > 0) {
            if (resetTo && (fromOnGround || from.isResetCond()) || hDistance <= 0.221) {
                data.lostSprintCount = 0;
                this.tags.add("invalidate_lostsprint");
                sprinting = now <= data.timeSprinting + cc.sprintingGrace;
            } else {
                this.tags.add("lostsprint");
                sprinting = true;
                data.lostSprintCount = data.lostSprintCount < 3 && to.isOnGround() || to.isResetCond() ? 0 : --data.lostSprintCount;
            }
        } else if (now <= data.timeSprinting + cc.sprintingGrace) {
            if (now != data.timeSprinting) {
                this.tags.add("sprintgrace");
            }
            sprinting = true;
        } else {
            sprinting = false;
        }
        double walkSpeed = 0.221 * ((double)data.walkSpeed / 0.2);
        this.setNextFriction(from, to, data, cc);
        boolean resetFrom = fromOnGround || from.isResetCond() ? true : (isSamePos ? (data.lastHDist != Double.MAX_VALUE && data.lastHDist > 0.0 && data.lastYDist < -0.3 ? this.lostGroundStill(player, from, to, hDistance, yDistance, sprinting, data, cc) : false) : this.lostGround(player, from, to, hDistance, yDistance, sprinting, data, cc));
        if (data.noFallAssumeGround) {
            data.resetVelocityJumpPhase();
        }
        if (data.isVelocityJumpPhase() || data.resetVelocityJumpPhase()) {
            this.tags.add("dirty");
        }
        --data.bunnyhopDelay;
        boolean bl2 = downStream = hDistance > walkSpeed * 0.5203619909502263 && from.isInLiquid() && from.isDownStream(xDistance, zDistance);
        if (from.isOnIce() || to.isOnIce()) {
            data.sfOnIce = 20;
        } else if (data.sfOnIce > 0) {
            --data.sfOnIce;
        }
        double hAllowedDistance = 0.0;
        double hDistanceAboveLimit = 0.0;
        double hFreedom = 0.0;
        if (hasHdist) {
            hAllowedDistance = this.getAllowedhDist(player, from, to, sprinting, downStream, hDistance, walkSpeed, data, cc, false);
            hDistanceAboveLimit = hDistance - hAllowedDistance;
            if (hDistanceAboveLimit > 0.0) {
                double[] res2 = this.hDistAfterFailure(player, from, to, walkSpeed, hAllowedDistance, hDistance, hDistanceAboveLimit, yDistance, sprinting, downStream, data, cc, false);
                hAllowedDistance = res2[0];
                hDistanceAboveLimit = res2[1];
                hFreedom = res2[2];
            } else {
                data.clearActiveHorVel();
                hFreedom = 0.0;
                if (resetFrom && data.bunnyhopDelay <= 6) {
                    data.bunnyhopDelay = 0;
                }
            }
            if (hDistanceAboveLimit <= 0.0 && hDistance > 0.1 && yDistance == 0.0 && data.lastYDist == 0.0 && !toOnGround && !fromOnGround && BlockProperties.isLiquid(to.getTypeId()) && BlockProperties.isLiquid(from.getTypeId()) && !from.isHeadObstructed() && !to.isHeadObstructed()) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
                this.tags.add("waterwalk");
            }
            if (sprinting && data.lostSprintCount == 0 && !cc.assumeSprint && hDistance > walkSpeed && !data.hasActiveHorVel() && TrigUtil.isMovingBackwards(xDistance, zDistance, from.getYaw()) && !player.hasPermission("nocheatplus.checks.moving.survivalfly.sprinting")) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, hDistance);
                this.tags.add("sprintback");
            }
        } else {
            data.clearActiveHorVel();
        }
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        if (yDistance >= 0.0 && yDistance <= cc.sfStepHeight && toOnGround && fromOnGround) {
            vAllowedDistance = cc.sfStepHeight;
        } else if (from.isInWeb()) {
            res = this.vDistWeb(player, from, to, toOnGround, hDistanceAboveLimit, yDistance, now, data, cc);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
            if (res[0] == Double.MIN_VALUE && res[1] == Double.MIN_VALUE) {
                if (data.debug) {
                    this.tags.add("silentsbcobweb");
                    this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo);
                }
                return data.getSetBack(to);
            }
        } else if (from.isOnClimbable()) {
            vDistanceAboveLimit = this.vDistClimbable(player, from, fromOnGround, toOnGround, yDistance, data);
        } else if (from.isInLiquid()) {
            res = this.vDistLiquid(from, to, toOnGround, yDistance, data);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
            if (vDistanceAboveLimit <= 0.0 && yDistance > 0.0 && Math.abs(yDistance) > SurvivalFly.swimBaseSpeedV()) {
                data.setFrictionJumpPhase();
            }
        } else {
            res = this.vDistAir(now, player, from, fromOnGround, resetFrom, to, toOnGround, resetTo, hDistanceAboveLimit, yDistance, data, cc);
            vAllowedDistance = res[0];
            vDistanceAboveLimit = res[1];
        }
        if (vDistanceAboveLimit > 0.0 && Math.abs(yDistance) <= 1.0 && cc.blockChangeTrackerPush && (pushResult = this.getPushResultVertical(yDistance, from, to, data)) != null) {
            vAllowedDistance = pushResult[0];
            vDistanceAboveLimit = pushResult[1];
        }
        if (data.debug) {
            this.outputDebug(player, to, data, cc, hDistance, hAllowedDistance, hFreedom, yDistance, vAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo);
            tagsLength = this.tags.size();
        } else {
            tagsLength = 0;
        }
        double result = (Math.max(hDistanceAboveLimit, 0.0) + Math.max(vDistanceAboveLimit, 0.0)) * 100.0;
        if (result > 0.0) {
            Location vLoc = this.handleViolation(now, result, player, from, to, data, cc);
            if (vLoc != null) {
                return vLoc;
            }
        } else {
            if (now - data.sfVLTime > cc.survivalFlyVLFreeze) {
                data.survivalFlyVL *= 0.95;
            }
            if (hDistanceAboveLimit < 0.0 && result <= 0.0 && !isSamePos && data.sfHorizontalBuffer < 1.0) {
                this.hBufRegain(hDistance, Math.min(0.2, Math.abs(hDistanceAboveLimit)), data);
            }
        }
        LiftOffEnvelope oldLiftOffEnvelope = data.liftOffEnvelope;
        if (to.isInLiquid()) {
            if (!fromOnGround || toOnGround || data.liftOffEnvelope != LiftOffEnvelope.NORMAL || data.sfJumpPhase > 0 || from.isInLiquid()) {
                data.liftOffEnvelope = to.isNextToGround(0.15, 0.4) ? LiftOffEnvelope.LIMIT_NEAR_GROUND : LiftOffEnvelope.LIMIT_LIQUID;
            }
        } else if (to.isInWeb()) {
            data.liftOffEnvelope = LiftOffEnvelope.NO_JUMP;
        } else if (resetTo) {
            data.liftOffEnvelope = LiftOffEnvelope.NORMAL;
        } else if (from.isInLiquid()) {
            if (resetTo || data.liftOffEnvelope != LiftOffEnvelope.NORMAL || data.sfJumpPhase > 0) {
                data.liftOffEnvelope = to.isNextToGround(0.15, 0.4) ? LiftOffEnvelope.LIMIT_NEAR_GROUND : LiftOffEnvelope.LIMIT_LIQUID;
            }
        } else if (from.isInWeb()) {
            data.liftOffEnvelope = LiftOffEnvelope.NO_JUMP;
        } else if (resetFrom || data.noFallAssumeGround) {
            data.liftOffEnvelope = LiftOffEnvelope.NORMAL;
        }
        data.insideMediumCount = !resetFrom || !resetTo || oldLiftOffEnvelope != data.liftOffEnvelope ? 0 : ++data.insideMediumCount;
        if (resetTo) {
            if (toOnGround && data.bunnyhopDelay > 0 && yDistance > 0.0 && to.getY() > data.getSetBackY() + 0.12 && !from.isResetCond() && !to.isResetCond()) {
                data.bunnyhopDelay = 0;
                this.tags.add("resetbunny");
            }
            data.setSetBack(to);
            data.sfJumpPhase = 0;
            data.clearAccounting();
            data.sfNoLowJump = false;
            if (data.sfLowJump && resetFrom) {
                data.sfLowJump = false;
            }
            if (hFreedom <= 0.0 && data.verVelUsed == null) {
                data.resetVelocityJumpPhase();
            }
        } else if (resetFrom) {
            data.setSetBack(from);
            data.sfJumpPhase = 1;
            data.clearAccounting();
            data.sfLowJump = false;
        } else {
            ++data.sfJumpPhase;
            if (to.getY() < 0.0 && cc.sfSetBackPolicyVoid) {
                data.setSetBack(to);
            }
        }
        double d = cc.velocityStrictInvalidation ? hAllowedDistance : hAllowedDistance / 2.0;
        if (hDistance <= d) {
            data.clearActiveHorVel();
        }
        data.toWasReset = resetTo || data.noFallAssumeGround;
        data.fromWasReset = resetFrom || data.noFallAssumeGround;
        data.lastFrictionHorizontal = data.nextFrictionHorizontal;
        data.lastFrictionVertical = data.nextFrictionVertical;
        data.sfZeroVdist = yDistance == 0.0 && hDistance < 0.125 ? ++data.sfZeroVdist : 0;
        if (data.debug && this.tags.size() > tagsLength) {
            this.logPostViolationTags(player);
        }
        return null;
    }

    private double[] getPushResultVertical(double yDistance, PlayerLocation from, PlayerLocation to, MovingData data) {
        long oldChangeId = data.blockChangeId;
        if (yDistance > 0.0) {
            double maxDistYPos = 1.0 - (from.getY() - (double)from.getBlockY());
            long changeIdYPos = from.getBlockChangeIdPush(this.blockChangeTracker, oldChangeId, BlockChangeTracker.Direction.Y_POS, yDistance);
            if (changeIdYPos != -1L) {
                data.blockChangeId = Math.max(data.blockChangeId, changeIdYPos);
                this.tags.add("push_y_pos");
                return new double[]{maxDistYPos, 0.0};
            }
        } else if (yDistance < 0.0) {
            double maxDistYPos = from.getY() - (double)from.getBlockY();
            long changeIdYPos = from.getBlockChangeIdPush(this.blockChangeTracker, oldChangeId, BlockChangeTracker.Direction.Y_NEG, -yDistance);
            if (changeIdYPos != -1L) {
                data.blockChangeId = Math.max(data.blockChangeId, changeIdYPos);
                this.tags.add("push_y_neg");
                return new double[]{maxDistYPos, 0.0};
            }
        }
        return null;
    }

    private void setNextFriction(PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        if (from.isInWeb() || to.isInWeb()) {
            data.nextFrictionVertical = 0.0;
            data.nextFrictionHorizontal = 0.0;
        } else if (from.isOnClimbable() || to.isOnClimbable()) {
            data.nextFrictionVertical = 0.0;
            data.nextFrictionHorizontal = 0.0;
        } else if (from.isInLiquid()) {
            if (from.isInLava()) {
                data.nextFrictionVertical = 0.535;
                data.nextFrictionHorizontal = 0.535;
            } else {
                data.nextFrictionVertical = 0.89;
                data.nextFrictionHorizontal = 0.89;
            }
        } else if (!from.isOnGround() && !to.isOnGround()) {
            data.nextFrictionVertical = 0.98;
            data.nextFrictionHorizontal = 0.98;
        } else {
            data.nextFrictionHorizontal = 0.0;
            data.nextFrictionVertical = 0.98;
        }
    }

    private double getAllowedhDist(Player player, PlayerLocation from, PlayerLocation to, boolean sprinting, boolean downStream, double hDistance, double walkSpeed, MovingData data, MovingConfig cc, boolean checkPermissions) {
        double hAllowedDistance = 0.0;
        boolean sfDirty = data.isVelocityJumpPhase();
        double friction = data.lastFrictionHorizontal;
        boolean useBaseModifiers = false;
        if (from.isInWeb()) {
            data.sfOnIce = 0;
            hAllowedDistance = 0.4751131221719457 * walkSpeed * (double)cc.survivalFlyWalkingSpeed / 100.0;
            friction = 0.0;
        } else if (from.isInLiquid() && to.isInLiquid()) {
            int level;
            hAllowedDistance = 0.5203619909502263 * walkSpeed * (double)cc.survivalFlySwimmingSpeed / 100.0;
            if ((from.isInWater() || !from.isInLava()) && (level = BridgeEnchant.getDepthStriderLevel(player)) > 0) {
                hAllowedDistance *= modDepthStrider[level];
                useBaseModifiers = true;
            }
        } else if (!sfDirty && from.isOnGround() && player.isSneaking() && this.reallySneaking.contains(player.getName()) && (!checkPermissions || !player.hasPermission("nocheatplus.checks.moving.survivalfly.sneaking"))) {
            hAllowedDistance = 0.5882352941176471 * walkSpeed * (double)cc.survivalFlySneakingSpeed / 100.0;
            friction = 0.0;
        } else if (!(sfDirty || !from.isOnGround() || !player.isBlocking() || checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.blocking"))) {
            hAllowedDistance = 0.7239819004524887 * walkSpeed * (double)cc.survivalFlyBlockingSpeed / 100.0;
            friction = 0.0;
        } else {
            useBaseModifiers = true;
            hAllowedDistance = sprinting ? walkSpeed * (double)cc.survivalFlySprintingSpeed / 100.0 : walkSpeed * (double)cc.survivalFlyWalkingSpeed / 100.0;
            friction = 0.0;
        }
        if (useBaseModifiers) {
            double attrMod;
            if (sprinting) {
                hAllowedDistance *= data.multSprinting;
            }
            if ((attrMod = this.mcAccess.getSpeedAttributeMultiplier(player)) == Double.MAX_VALUE) {
                double speedAmplifier = this.mcAccess.getFasterMovementAmplifier(player);
                if (speedAmplifier != Double.NEGATIVE_INFINITY) {
                    hAllowedDistance *= 1.0 + 0.2 * (speedAmplifier + 1.0);
                }
            } else {
                hAllowedDistance *= attrMod;
            }
        }
        if (downStream) {
            hAllowedDistance *= 1.6521739130434783;
        }
        if (data.sfOnIce > 0) {
            hAllowedDistance *= 2.5;
        }
        if (checkPermissions && player.hasPermission("nocheatplus.checks.moving.survivalfly.speeding")) {
            hAllowedDistance *= (double)cc.survivalFlySpeedingSpeed / 100.0;
        }
        if (hDistance <= hAllowedDistance) {
            data.nextFrictionHorizontal = 1.0;
        }
        if (data.lastHDist != Double.MAX_VALUE && friction > 0.0) {
            return Math.max(hAllowedDistance, data.lastHDist * friction);
        }
        return hAllowedDistance;
    }

    public boolean isReallySneaking(Player player) {
        return this.reallySneaking.contains(player.getName());
    }

    private boolean lostGround(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        if (yDistance >= -0.7 && yDistance <= Math.max(cc.sfStepHeight, LiftOffEnvelope.NORMAL.getMaxJumpGain(data.jumpAmplifier) + 0.174)) {
            if (yDistance >= 0.0 && this.lostGroundAscend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                return true;
            }
            if (yDistance <= 0.0 && this.lostGroundDescend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
                return true;
            }
        } else if (yDistance < -0.7 && hDistance <= 0.5 && this.lostGroundFastDescend(player, from, to, hDistance, yDistance, sprinting, data, cc)) {
            return true;
        }
        return false;
    }

    private double[] vDistAir(long now, Player player, PlayerLocation from, boolean fromOnGround, boolean resetFrom, PlayerLocation to, boolean toOnGround, boolean resetTo, double hDistance, double yDistance, MovingData data, MovingConfig cc) {
        boolean strictVdistRel;
        boolean envelopeHack;
        double yDistChange;
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        double d = yDistChange = data.lastYDist == Double.MAX_VALUE ? Double.MAX_VALUE : yDistance - data.lastYDist;
        if (!resetFrom && !resetTo && SurvivalFly.venvHacks(from, to, yDistance, yDistChange, data)) {
            envelopeHack = true;
            this.tags.add("hack_venv");
        } else {
            envelopeHack = false;
        }
        double maxJumpGain = data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier);
        double jumpGainMargin = 0.005;
        if (SurvivalFly.fallingEnvelope(yDistance, data.lastYDist, data.lastFrictionVertical, 0.0)) {
            vAllowedDistance = data.lastYDist * data.lastFrictionVertical - 0.0624;
            strictVdistRel = true;
        } else if (resetFrom) {
            vAllowedDistance = toOnGround ? cc.sfStepHeight : (yDistance < 0.0 || yDistance > cc.sfStepHeight || !this.tags.contains("lostground_couldstep") ? maxJumpGain + 0.005 : yDistance);
            strictVdistRel = false;
        } else if (data.lastYDist != Double.MAX_VALUE) {
            if (data.lastYDist >= -Math.max(0.0417, 1.3 * Math.abs(yDistance)) && data.lastYDist <= 0.0 && data.fromWasReset) {
                vAllowedDistance = resetTo ? cc.sfStepHeight : maxJumpGain + 0.005;
                strictVdistRel = false;
            } else {
                vAllowedDistance = data.lastYDist * data.lastFrictionVertical - 0.0624;
                strictVdistRel = true;
            }
        } else {
            vAllowedDistance = yDistance;
            strictVdistRel = true;
            this.tags.add("data_missing");
        }
        boolean vDistRelVL = false;
        double yDistDiffEx = yDistance - vAllowedDistance;
        if (envelopeHack) {
            vDistRelVL = false;
        } else if (yDistDiffEx > 0.0) {
            if (!(yDistance <= 0.0 && (resetTo || data.noFallAssumeGround) || yDistance < 0.0 && data.lastYDist < 0.0 && yDistChange > -0.0834 && (from.isOnGround(Math.abs(yDistance) + 0.001) || BlockProperties.isLiquid(to.getTypeId(to.getBlockX(), Location.locToBlock((double)(to.getY() - 0.5)), to.getBlockZ()))) || yDistDiffEx < 0.0312 && data.sfJumpPhase == 1 && to.getY() - data.getSetBackY() <= data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) && data.lastYDist <= maxJumpGain && yDistance > -0.0834 && yDistance < data.lastYDist && data.lastYDist - yDistance > 0.016666666666666666 || yDistDiffEx < 0.0624 && data.sfJumpPhase == 1 && data.liftOffEnvelope != LiftOffEnvelope.NORMAL && data.fromWasReset && data.lastYDist < -0.025 && data.lastYDist > -0.1044 && yDistance < data.lastYDist - 0.001 || SurvivalFly.oddLiquid(yDistance, yDistDiffEx, maxJumpGain, resetTo, data) || SurvivalFly.oddGravity(from, to, yDistance, yDistChange, data) || SurvivalFly.oddSlope(to, yDistance, maxJumpGain, yDistDiffEx, data))) {
                vDistRelVL = true;
            }
        } else if (yDistance >= 0.0) {
            if (!(!strictVdistRel || Math.abs(yDistDiffEx) <= 0.021000000000000005 || vAllowedDistance <= 0.2 || SurvivalFly.oddGravity(from, to, yDistance, yDistChange, data) || SurvivalFly.oddSlope(to, yDistance, maxJumpGain, yDistDiffEx, data) || SurvivalFly.oddLiquid(yDistance, yDistDiffEx, maxJumpGain, resetTo, data) || yDistance > 0.0 && data.lastYDist != Double.MAX_VALUE && data.lastYDist > yDistance && data.lastYDist - yDistance <= data.lastYDist / 4.0 && data.isVelocityJumpPhase() || to.isHeadObstructed() || data.lastYDist > 0.0 && yDistance == 0.0 && from.isHeadObstructed())) {
                vDistRelVL = true;
            }
        } else if (!(!(Math.abs(yDistDiffEx) > 0.021000000000000005) || yDistance < -3.0 && data.lastYDist < -3.0 && Math.abs(yDistDiffEx) < 0.41700000000000004 || resetTo && (yDistDiffEx > -0.021000000000000005 || !fromOnGround && !data.noFallAssumeGround && yDistChange >= 0.0) || yDistance > data.lastYDist - 0.0834 - 0.021000000000000005 && (resetTo || data.noFallAssumeGround) || resetFrom && yDistance >= -0.5 && (yDistance > -0.31 || (resetTo || to.isAboveStairs()) && data.lastYDist < 0.0) || data.liftOffEnvelope == LiftOffEnvelope.LIMIT_LIQUID && data.sfJumpPhase == 1 && data.fromWasReset && !data.toWasReset && !resetFrom && resetTo && data.lastYDist > 0.0 && data.lastYDist < 0.025 && yDistance < 0.0 && Math.abs(Math.abs(yDistance) - data.lastYDist) < 0.010500000000000002 || SurvivalFly.oddGravity(from, to, yDistance, yDistChange, data) || data.lastYDist >= 0.0 && yDistance <= 0.0 && yDistance > -0.1044 && from.isHeadObstructed())) {
            vDistRelVL = true;
        }
        if (vDistRelVL && data.getOrUseVerticalVelocity(yDistance) == null) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance - vAllowedDistance));
            this.tags.add("vdistrel");
        }
        if (!(!(yDistance > 0.0) || data.isVelocityJumpPhase() || (fromOnGround || data.noFallAssumeGround) && toOnGround && yDistance <= cc.sfStepHeight)) {
            double vAllowedAbsoluteDistance = data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier);
            double totalVDistViolation = to.getY() - data.getSetBackY() - vAllowedAbsoluteDistance;
            if (totalVDistViolation > 0.0 && (yDistance > cc.sfStepHeight || !this.tags.contains("lostground_couldstep")) && data.getOrUseVerticalVelocity(yDistance) == null) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, totalVDistViolation);
                this.tags.add("vdistsb");
            }
        }
        if (data.sfLowJump) {
            this.tags.add("lowjump");
        }
        if (!(envelopeHack || resetFrom || resetTo)) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, this.inAirChecks(now, from, to, hDistance, yDistance, data, cc));
        }
        if ((resetFrom || data.noFallAssumeGround) && resetTo && vDistanceAboveLimit <= 0.0 && yDistance > cc.sfStepHeight && yDistance > maxJumpGain + 0.1) {
            double vl;
            boolean step = true;
            if (data.noFallAssumeGround && data.lastYDist != Double.MAX_VALUE && data.lastYDist <= 0.0 && yDistance > 0.0 && yDistance + Math.abs(data.lastYDist) <= 2.0 * (maxJumpGain + 0.1)) {
                step = false;
            }
            if (step && !player.hasPermission("nocheatplus.checks.moving.survivalfly.step") && (vl = Math.max(vDistanceAboveLimit, Math.abs(from.isOnClimbable() ? yDistance : yDistance - (maxJumpGain + 0.1)))) > 0.0 && data.getOrUseVerticalVelocity(yDistance) == null) {
                vDistanceAboveLimit = vl;
                this.tags.add("step");
            }
        }
        int maxJumpPhase = data.liftOffEnvelope.getMaxJumpPhase(data.jumpAmplifier);
        if (!(envelopeHack || data.sfJumpPhase <= maxJumpPhase || data.isVelocityJumpPhase() || yDistance < 0.0 || resetFrom || data.getOrUseVerticalVelocity(yDistance) != null)) {
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.max(yDistance, 0.15));
            this.tags.add("maxphase");
        }
        return new double[]{vAllowedDistance, vDistanceAboveLimit};
    }

    private static boolean venvHacks(PlayerLocation from, PlayerLocation to, double yDistance, double yDistChange, MovingData data) {
        return data.liftOffEnvelope == LiftOffEnvelope.NO_JUMP && data.sfJumpPhase < 60 && (data.lastYDist < 0.0 && (yDistance == 0.0 && data.lastYDist < -0.016666666666666666 && data.lastYDist > -0.0624 || yDistChange < -0.0208 && yDistChange > -0.0834 || yDistChange == 0.0 && data.lastYDist > -0.0834 && data.lastYDist < -0.016666666666666666) || yDistance == 0.0 && data.sfZeroVdist > 0 && data.sfZeroVdist < 10) || yDistance == 0.0 && data.sfZeroVdist == 1 && (data.isVelocityJumpPhase() || data.hasSetBack() && to.getY() - data.getSetBackY() < 1.35);
    }

    private static boolean oddSlope(PlayerLocation to, double yDistance, double maxJumpGain, double yDistDiffEx, MovingData data) {
        return data.sfJumpPhase == 1 && Math.abs(yDistDiffEx) < 0.04200000000000001 && data.lastYDist != Double.MAX_VALUE && data.lastYDist > 0.0 && yDistance < data.lastYDist && to.getY() - data.getSetBackY() <= data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) && (data.lastYDist > maxJumpGain && data.lastYDist < 1.1 * maxJumpGain || data.lastYDist > 0.5 * maxJumpGain && data.lastYDist < 0.84 * maxJumpGain && data.lastYDist - yDistance <= 0.1044);
    }

    private static boolean fallingEnvelope(double yDistance, double lastYDist, double lastFrictionVertical, double extraGravity) {
        if (lastYDist == Double.MAX_VALUE || yDistance >= lastYDist) {
            return false;
        }
        double frictDist = lastYDist * lastFrictionVertical - 0.0624;
        return yDistance <= frictDist + extraGravity && yDistance > frictDist - 0.021000000000000005 - extraGravity;
    }

    private static boolean oddLiquid(double yDistance, double yDistDiffEx, double maxJumpGain, boolean resetTo, MovingData data) {
        return (data.sfJumpPhase == 1 || data.sfJumpPhase == 2) && (data.lastYDist > 0.0 && yDistance < data.lastYDist - 0.0834 && yDistDiffEx > 0.0 && yDistDiffEx < 0.13340000000000002 && (data.liftOffEnvelope == LiftOffEnvelope.LIMIT_LIQUID || data.liftOffEnvelope == LiftOffEnvelope.LIMIT_NEAR_GROUND) || yDistDiffEx > 0.0 && data.liftOffEnvelope != LiftOffEnvelope.NORMAL && data.lastYDist >= -0.14579999999999999 && data.lastYDist < 0.1044 && yDistance > data.lastYDist && yDistance < 0.84 * maxJumpGain || yDistDiffEx < 0.0 && (data.liftOffEnvelope != LiftOffEnvelope.NORMAL || data.isVelocityJumpPhase()) && SurvivalFly.fallingEnvelope(yDistance, data.lastYDist, data.lastFrictionVertical, 0.025) || yDistDiffEx > 0.0 && data.liftOffEnvelope == LiftOffEnvelope.LIMIT_LIQUID && (data.lastYDist != Double.MAX_VALUE && data.lastYDist > -0.2168 && yDistance < data.lastYDist && data.lastYDist - yDistance < 0.0834 && data.lastYDist - yDistance > 0.0156 || data.lastYDist != Double.MAX_VALUE && data.lastYDist > 0.0 && yDistance < data.lastYDist && yDistance > 0.0 && data.sfJumpPhase == 1 && data.lastYDist - yDistance > 0.0834 && yDistDiffEx < 0.1044 && data.isVelocityJumpPhase()));
    }

    private static boolean oddGravity(PlayerLocation from, PlayerLocation to, double yDistance, double yDistChange, MovingData data) {
        return yDistance > -0.22920000000000001 && yDistance < 0.22920000000000001 && (data.lastYDist < 0.3126 && yDistChange < -0.0624 && yDistChange > -0.27090000000000003 || data.lastYDist > 0.025 && data.lastYDist < 0.0624 && yDistance == 0.0 || data.lastYDist <= 0.14579999999999999 && data.lastYDist > 0.05 && yDistance < 0.05 && yDistance > -0.1918 || data.lastYDist >= 0.0 && (from.isHeadObstructed(from.getyOnGround()) || data.fromWasReset && from.isHeadObstructed()) || data.lastYDist < 0.0 && data.toWasReset && yDistance >= -0.1044 && yDistance <= 0.0624 || data.lastYDist < -0.0834 && yDistChange < -0.025 && yDistChange > -0.0624 || data.lastYDist == 0.0 && yDistance < -0.02 && yDistance > -0.0624 && to.isOnGround(0.0624)) || data.isVelocityJumpPhase() && (data.lastYDist > 0.05 && data.lastYDist < 0.14579999999999999 && yDistance <= -data.lastYDist && yDistance > -data.lastYDist - 0.0834 - 0.05 || data.lastYDist < -0.204 && yDistance > -0.26 && yDistChange > -0.0624 && yDistChange < -0.0125 || data.lastYDist < -0.05 && data.lastYDist > -0.0624 && yDistance > -0.29159999999999997 && yDistance < -0.0834 || yDistChange > -0.0624 && yDistChange < -0.05 && data.lastYDist < 0.5 && data.lastYDist > 0.4 || data.lastYDist == 0.0 && yDistance > -0.0624 && yDistance < -0.05) || data.hasSetBack() && Math.abs(data.getSetBackY() - from.getY()) < 1.0 && data.lastYDist > 0.0834 && data.lastYDist < 0.2502 && yDistChange > -0.0624 && yDistChange < -0.05 || data.jumpAmplifier > 0.0 && data.lastYDist < 0.11460000000000001 && data.lastYDist > -0.198 && yDistance > -0.29159999999999997 && yDistance < 0.0624 && yDistChange < -0.021000000000000005 || data.lastYDist > -0.0834 && data.lastYDist < 0.0624 && !data.toWasReset && yDistance < data.lastYDist - 0.0312 && yDistance > data.lastYDist - 0.0834 - 0.0312 || data.liftOffEnvelope != LiftOffEnvelope.NORMAL && (data.lastYDist > -0.25 && data.lastYDist < 0.5 && yDistance < data.lastYDist - 0.0312 && yDistance > data.lastYDist - 0.0834 || data.lastYDist < 0.1044 && data.lastYDist > 0.05 && yDistance > 0.020000000000000004 && yDistance - data.lastYDist < -0.025 || data.lastYDist < 0.2 && data.lastYDist >= 0.0 && yDistance > -0.2 && yDistance < 0.1668 || data.lastYDist > 0.020000000000000004 && data.lastYDist < 0.0624 && yDistance == 0.0 || data.sfJumpPhase == 1 && data.lastYDist > -0.05 && data.lastYDist <= 0.1044 && yDistance - data.lastYDist < 0.0114 || data.sfJumpPhase == 1 && Math.abs(yDistance) <= SurvivalFly.swimBaseSpeedV() && yDistance == data.lastYDist);
    }

    private double inAirChecks(long now, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, MovingData data, MovingConfig cc) {
        boolean yDirChange;
        double vDistanceAboveLimit = 0.0;
        boolean bl = yDirChange = data.lastYDist != Double.MAX_VALUE && data.lastYDist != yDistance && (yDistance <= 0.0 && data.lastYDist >= 0.0 || yDistance >= 0.0 && data.lastYDist <= 0.0);
        if (yDirChange) {
            vDistanceAboveLimit = this.yDirChange(from, to, yDistance, vDistanceAboveLimit, data);
        }
        if (cc.survivalFlyAccountingV) {
            if (yDirChange && data.lastYDist > 0.0) {
                data.vDistAcc.clear();
                data.vDistAcc.add((float)yDistance);
            } else if (data.verVelUsed == null) {
                if (yDistance != 0.0) {
                    data.vDistAcc.add((float)yDistance);
                    double accAboveLimit = SurvivalFly.verticalAccounting(yDistance, data.vDistAcc, this.tags, "vacc" + (data.isVelocityJumpPhase() ? "dirty" : ""));
                    if (accAboveLimit > vDistanceAboveLimit && data.getOrUseVerticalVelocity(yDistance) == null) {
                        vDistanceAboveLimit = accAboveLimit;
                    }
                }
            } else {
                data.vDistAcc.clear();
            }
        }
        return vDistanceAboveLimit;
    }

    private static final double verticalAccounting(double yDistance, ActionAccumulator acc, ArrayList<String> tags, String tag) {
        float sc1;
        int cap;
        float sc0;
        int count1;
        int count0 = acc.bucketCount(0);
        if (count0 > 0 && (count1 = acc.bucketCount(1)) > 0 && (double)(sc0 = count0 == (cap = acc.bucketCapacity()) ? acc.bucketScore(0) : acc.bucketScore(0) * (float)cap / (float)count0 - 0.03744f * (float)(cap - count0)) > (double)(sc1 = acc.bucketScore(1)) - 0.11231999471783638) {
            if (yDistance <= -1.05 && (double)sc1 < -8.0 && (double)sc0 < -8.0) {
                tags.add(tag + "grace");
                return 0.0;
            }
            tags.add(tag);
            return (double)sc0 - ((double)sc1 - 0.11231999471783638);
        }
        return 0.0;
    }

    private double yDirChange(PlayerLocation from, PlayerLocation to, double yDistance, double vDistanceAboveLimit, MovingData data) {
        if (yDistance > 0.0) {
            if (data.toWasReset) {
                this.tags.add("ychinc");
            } else if (!(data.bunnyhopDelay >= 9 || data.fromWasReset && data.lastYDist == 0.0 || data.getOrUseVerticalVelocity(yDistance) != null)) {
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance));
                this.tags.add("ychincfly");
            } else {
                this.tags.add("ychincair");
            }
        } else {
            double setBackYDistance;
            this.tags.add("ychdec");
            if (!data.sfLowJump && !data.sfNoLowJump && data.liftOffEnvelope == LiftOffEnvelope.NORMAL && data.lastYDist != Double.MAX_VALUE && data.lastYDist > 0.0 && !data.isVelocityJumpPhase() && (setBackYDistance = from.getY() - data.getSetBackY()) > 0.0) {
                Player player = from.getPlayer();
                double estimate = 1.15;
                if (data.jumpAmplifier > 0.0) {
                    estimate += 0.5 * this.getJumpAmplifier(player);
                }
                if (setBackYDistance < estimate && !from.isHeadObstructed() && !to.isHeadObstructed()) {
                    this.tags.add("lowjump_set");
                    data.sfLowJump = true;
                }
            }
        }
        return vDistanceAboveLimit;
    }

    private double[] hDistAfterFailure(Player player, PlayerLocation from, PlayerLocation to, double walkSpeed, double hAllowedDistance, double hDistance, double hDistanceAboveLimit, double yDistance, boolean sprinting, boolean downStream, MovingData data, MovingConfig cc, boolean skipPermChecks) {
        if ((hDistanceAboveLimit = this.bunnyHop(from, to, hDistance, hAllowedDistance, hDistanceAboveLimit, yDistance, sprinting, data, cc)) > 0.0 && !skipPermChecks) {
            hAllowedDistance = this.getAllowedhDist(player, from, to, sprinting, downStream, hDistance, walkSpeed, data, cc, true);
            hDistanceAboveLimit = hDistance - hAllowedDistance;
            this.tags.add("permchecks");
        }
        double hFreedom = 0.0;
        if (hDistanceAboveLimit > 0.0) {
            hFreedom = data.getHorizontalFreedom();
            if (hFreedom < hDistanceAboveLimit) {
                hFreedom += data.useHorizontalVelocity(hDistanceAboveLimit - hFreedom);
            }
            if (hFreedom > 0.0) {
                this.tags.add("hvel");
                hDistanceAboveLimit = Math.max(0.0, hDistanceAboveLimit - hFreedom);
            }
        }
        if (hDistanceAboveLimit > 0.0) {
            hDistanceAboveLimit = this.bunnyHop(from, to, hDistance, hAllowedDistance, hDistanceAboveLimit, yDistance, sprinting, data, cc);
        }
        if (hDistanceAboveLimit > 0.0 && data.sfHorizontalBuffer > 0.0) {
            this.tags.add("hbufuse");
            double amount = Math.min(data.sfHorizontalBuffer, hDistanceAboveLimit);
            hDistanceAboveLimit -= amount;
            data.sfHorizontalBuffer = Math.max(0.0, data.sfHorizontalBuffer - amount);
        }
        if (hDistanceAboveLimit > 0.0) {
            this.tags.add("hspeed");
        }
        return new double[]{hAllowedDistance, hDistanceAboveLimit, hFreedom};
    }

    private double bunnyHop(PlayerLocation from, PlayerLocation to, double hDistance, double hAllowedDistance, double hDistanceAboveLimit, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        boolean allowHop = true;
        boolean double_bunny = false;
        if (data.lastHDist != Double.MAX_VALUE && data.bunnyhopDelay > 0 && hDistance > 0.221) {
            allowHop = false;
            int hopTime = 10 - data.bunnyhopDelay;
            if (data.lastHDist != Double.MAX_VALUE && data.lastHDist > hDistance) {
                double hDistDiff = data.lastHDist - hDistance;
                if (data.bunnyhopDelay == 9) {
                    if (hDistDiff >= 0.66 * (data.lastHDist - hAllowedDistance)) {
                        this.tags.add("bunnyslope");
                        hDistanceAboveLimit = 0.0;
                    }
                } else if (hDistDiff >= data.lastHDist / 160.0 || hDistDiff >= hDistanceAboveLimit / 33.3 || hDistDiff >= (hDistance - hAllowedDistance) * 0.020000000000000018) {
                    this.tags.add("bunnyfriction");
                    hDistanceAboveLimit = 0.0;
                    if (data.bunnyhopDelay == 1 && !to.isOnGround() && !to.isResetCond()) {
                        ++data.bunnyhopDelay;
                        this.tags.add("bunnyfly(keep)");
                    } else {
                        this.tags.add("bunnyfly(" + data.bunnyhopDelay + ")");
                    }
                }
            }
            if (!allowHop && data.lastHDist != Double.MAX_VALUE && hDistance - data.lastHDist >= 0.1105 && hopTime == 1 && data.lastYDist >= -0.0417 && data.lastYDist <= 0.0 && (data.fromWasReset || data.toWasReset) && yDistance >= 0.4) {
                this.tags.add(DOUBLE_BUNNY);
                double_bunny = true;
                allowHop = true;
            }
            if (!allowHop && (from.isOnGround() || data.noFallAssumeGround) && (data.bunnyhopDelay <= 6 || yDistance >= 0.0 && from.isHeadObstructed() || to.isHeadObstructed())) {
                this.tags.add("ediblebunny");
                allowHop = true;
            }
        }
        if (allowHop && hDistance >= 0.221 && hDistance > (data.lastHDist == Double.MAX_VALUE || data.lastHDist == 0.0 && data.lastYDist == 0.0 ? 1.11 : 1.314) * hAllowedDistance && hDistance < 2.15 * hAllowedDistance || (yDistance > from.getyOnGround() || hDistance < 0.5746) && data.lastHDist != Double.MAX_VALUE && hDistance > 1.314 * data.lastHDist && hDistance < 2.15 * data.lastHDist) {
            if (data.liftOffEnvelope == LiftOffEnvelope.NORMAL && (!data.sfLowJump || data.sfNoLowJump) && (yDistance > 0.0 && yDistance > data.liftOffEnvelope.getMinJumpGain(data.jumpAmplifier) - 0.021000000000000005 || yDistance > 0.0 && from.isHeadObstructed(yDistance + from.getyOnGround()) || (cc.sfGroundHop && yDistance >= 0.0 || yDistance == 0.0 && !data.fromWasReset) && hAllowedDistance > 0.0 && hDistance / hAllowedDistance < 1.35) && (data.sfJumpPhase == 0 && from.isOnGround() || data.sfJumpPhase <= 1 && (data.noFallAssumeGround || data.fromWasReset) || double_bunny) && !from.isResetCond() && !to.isResetCond()) {
                data.bunnyhopDelay = 10;
                hDistanceAboveLimit = 0.0;
                this.tags.add("bunnyhop");
            } else {
                this.tags.add("bunnyenv");
            }
        }
        return hDistanceAboveLimit;
    }

    private void hBufRegain(double hDistance, double amount, MovingData data) {
        data.sfHorizontalBuffer = Math.min(1.0, data.sfHorizontalBuffer + amount);
    }

    private static double swimBaseSpeedV() {
        return 0.135;
    }

    private double[] vDistLiquid(PlayerLocation from, PlayerLocation to, boolean toOnGround, double yDistance, MovingData data) {
        double frictDist;
        data.sfNoLowJump = true;
        double baseSpeed = SurvivalFly.swimBaseSpeedV();
        double yDistAbs = Math.abs(yDistance);
        if (yDistAbs <= baseSpeed) {
            return new double[]{baseSpeed, 0.0};
        }
        double d = frictDist = data.lastYDist == Double.MAX_VALUE ? baseSpeed : Math.abs(data.lastYDist) * data.lastFrictionVertical;
        if (data.lastYDist != Double.MAX_VALUE) {
            if (data.lastYDist < 0.0 && yDistance < 0.0 && yDistAbs < frictDist + 0.0834 + 0.021000000000000005) {
                return new double[]{-frictDist - 0.0834 - 0.021000000000000005, 0.0};
            }
            if (data.lastYDist > 0.0 && yDistance > 0.0 && yDistance < frictDist - 0.0624) {
                return new double[]{frictDist - 0.0624, 0.0};
            }
        }
        if (yDistance >= 0.0) {
            if (yDistance <= 0.5) {
                double vAllowedDistance;
                double vDistanceAboveLimit;
                if (data.lastYDist != Double.MAX_VALUE && yDistance < data.lastYDist && data.lastYDist - yDistance > Math.max(0.001, yDistance - baseSpeed)) {
                    return new double[]{yDistance, 0.0};
                }
                if ((yDistance <= data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier) && !BlockProperties.isLiquid(from.getTypeIdAbove()) || !to.isInLiquid() || toOnGround || data.lastYDist != Double.MAX_VALUE && data.lastYDist - yDistance >= 0.01 || to.isAboveStairs()) && (vDistanceAboveLimit = yDistance - (vAllowedDistance = 0.615)) <= 0.0) {
                    return new double[]{vAllowedDistance, 0.0};
                }
            }
        } else {
            if (yDistance > -0.9 && data.lastYDist != Double.MAX_VALUE && yDistance < data.lastYDist && Math.abs(yDistance - data.lastYDist) <= 0.14579999999999999 && yDistance - data.lastYDist < -0.0624) {
                return new double[]{data.lastYDist - 0.0834 - 0.0624, 0.0};
            }
            if (!(data.insideMediumCount <= 1 && data.lastYDist < 0.8 && yDistance < data.lastYDist - 0.05 && yDistance > data.lastYDist - 0.0834)) {
                if (data.lastYDist >= 0.0417 && data.lastYDist <= 0.11460000000000001 && yDistance < 0.0 && yDistance > -0.198 && data.isVelocityJumpPhase() && to.isInLiquid() && data.fromWasReset && data.toWasReset) {
                    return new double[]{yDistance, 0.0};
                }
                if (data.lastFrictionVertical < 0.65 && (data.lastYDist < 0.0 && yDistance > -0.5 && yDistance < data.lastYDist && data.lastYDist - yDistance < 0.0624 && BlockProperties.isDownStream(from, to) || data.lastYDist < 0.0 && yDistance > -baseSpeed - 0.0834 && yDistance < data.lastYDist && data.lastYDist - yDistance > 0.021000000000000005 && Math.abs(data.lastYDist + baseSpeed) < 0.25 * baseSpeed || data.insideMediumCount == 1 || data.insideMediumCount == 2 && data.lastYDist < 0.0 && yDistance < data.lastYDist && yDistance - data.lastYDist > -0.0624 && yDistance > -0.65)) {
                    return new double[]{yDistance, 0.0};
                }
            }
        }
        if (data.getOrUseVerticalVelocity(yDistance) != null) {
            return new double[]{yDistance, 0.0};
        }
        this.tags.add(yDistance < 0.0 ? "swimdown" : "swimup");
        double vl1 = yDistAbs - baseSpeed;
        double vl2 = Math.abs(yDistAbs - frictDist - (yDistance < 0.0 ? 0.1044 : 0.0624));
        if (vl1 <= vl2) {
            return new double[]{yDistance < 0.0 ? -baseSpeed : baseSpeed, vl1};
        }
        return new double[]{yDistance < 0.0 ? -frictDist - 0.0834 - 0.021000000000000005 : frictDist - 0.0624, vl2};
    }

    private double vDistClimbable(Player player, PlayerLocation from, boolean fromOnGround, boolean toOnGround, double yDistance, MovingData data) {
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        data.clearActiveHorVel();
        double jumpHeight = 1.35 + (data.jumpAmplifier > 0.0 ? 0.6 + data.jumpAmplifier - 1.0 : 0.0);
        if (Math.abs(yDistance) > 0.2873) {
            if (from.isOnGround(jumpHeight, 0.0, 0.0, 512L)) {
                if (yDistance > data.liftOffEnvelope.getMaxJumpGain(data.jumpAmplifier) + 0.1) {
                    this.tags.add("climbstep");
                    vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance) - 0.2873);
                }
            } else {
                this.tags.add("climbspeed");
                vDistanceAboveLimit = Math.max(vDistanceAboveLimit, Math.abs(yDistance) - 0.2873);
            }
        }
        if (!(!(yDistance > 0.0) || fromOnGround || toOnGround || data.noFallAssumeGround || from.canClimbUp(jumpHeight))) {
            this.tags.add("climbdetached");
            vDistanceAboveLimit = Math.max(vDistanceAboveLimit, yDistance);
        }
        return vDistanceAboveLimit;
    }

    private double[] vDistWeb(Player player, PlayerLocation from, PlayerLocation to, boolean toOnGround, double hDistanceAboveLimit, double yDistance, long now, MovingData data, MovingConfig cc) {
        double vAllowedDistance = 0.0;
        double vDistanceAboveLimit = 0.0;
        data.sfNoLowJump = true;
        data.jumpAmplifier = 0.0;
        if (yDistance >= 0.0) {
            if (toOnGround && yDistance <= 0.5) {
                vAllowedDistance = yDistance;
                if (yDistance > 0.0) {
                    this.tags.add("web_step");
                }
            } else {
                vAllowedDistance = from.isOnGround() ? 0.1 : 0.0;
            }
            vDistanceAboveLimit = yDistance - vAllowedDistance;
        }
        if (cc.survivalFlyCobwebHack && vDistanceAboveLimit > 0.0 && hDistanceAboveLimit <= 0.0 && this.hackCobweb(player, data, to, now, vDistanceAboveLimit)) {
            return new double[]{Double.MIN_VALUE, Double.MIN_VALUE};
        }
        if (vDistanceAboveLimit > 0.0) {
            this.tags.add("vweb");
        }
        return new double[]{vAllowedDistance, vDistanceAboveLimit};
    }

    private boolean lostGroundAscend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (yDistance <= cc.sfStepHeight && hDistance <= 1.5) {
            if (setBackYDistance <= Math.max(0.0, 1.3 + 0.2 * data.jumpAmplifier) && to.isOnGround() && (data.lastYDist < 0.0 || yDistance <= cc.sfStepHeight && from.isOnGround(cc.sfStepHeight - yDistance))) {
                return this.applyLostGround(player, from, true, data, "step");
            }
            if (data.lastYDist < 0.0) {
                if (BlockProperties.isOnGroundShuffled(to.getBlockCache(), from.getX(), from.getY() + cc.sfStepHeight, from.getZ(), to.getX(), to.getY(), to.getZ(), 0.1 + (double)Math.round(from.getWidth() * 500.0) / 1000.0, to.getyOnGround(), 0.0)) {
                    return this.applyLostGround(player, from, false, data, "couldstep");
                }
                if (!to.isOnGround()) {
                    if (data.fromX != Double.MAX_VALUE && data.lastHDist != Double.MAX_VALUE && data.lastYDist != Double.MAX_VALUE) {
                        if (this.lostGroundEdgeAsc(player, from.getBlockCache(), from.getWorld(), from.getX(), from.getY(), from.getZ(), from.getWidth(), from.getyOnGround(), data, "asc1")) {
                            return true;
                        }
                        if (yDistance == 0.0 && data.lastYDist <= -0.23 && hDistance <= data.lastHDist * 1.1 && this.lostGroundEdgeAsc(player, from.getBlockCache(), to.getWorld(), to.getX(), to.getY(), to.getZ(), from.getX(), from.getY(), from.getZ(), hDistance, to.getWidth(), 0.3, data, "asc5")) {
                            return true;
                        }
                    } else if (from.isOnGround(from.getyOnGround(), 0.0625, 0.0)) {
                        return this.applyLostGround(player, from, false, data, "edgeasc2");
                    }
                }
            }
        }
        return false;
    }

    private boolean lostGroundStill(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        return data.lastYDist <= -0.23 && this.lostGroundEdgeAsc(player, from.getBlockCache(), to.getWorld(), to.getX(), to.getY(), to.getZ(), from.getX(), from.getY(), from.getZ(), hDistance, to.getWidth(), 0.3, data, "asc7");
    }

    private final boolean lostGroundEdgeAsc(Player player, BlockCache blockCache, World world, double x1, double y1, double z1, double width, double yOnGround, MovingData data, String tag) {
        return this.lostGroundEdgeAsc(player, blockCache, world, x1, y1, z1, data.fromX, data.fromY, data.fromZ, data.lastHDist, width, yOnGround, data, tag);
    }

    private final boolean lostGroundEdgeAsc(Player player, BlockCache blockCache, World world, double x1, double y1, double z1, double x2, double y2, double z2, double hDistance2, double width, double yOnGround, MovingData data, String tag) {
        double xzMargin;
        x2 -= x1;
        z2 -= z1;
        double fMin = 1.0;
        if (Math.abs(x2) > hDistance2) {
            fMin = Math.min(fMin, hDistance2 / Math.abs(x2));
        }
        if (Math.abs(z2) > hDistance2) {
            fMin = Math.min(fMin, hDistance2 / Math.abs(z2));
        }
        if (BlockProperties.isOnGroundShuffled(blockCache, x1, y1, z1, x2 = fMin * x2 + x1, y1, z2 = fMin * z2 + z1, xzMargin = (double)Math.round(width * 500.0) / 1000.0, yOnGround, 0.0)) {
            return this.applyLostGround(player, new Location(world, x2, y2, z2), true, data, "edge" + tag);
        }
        return false;
    }

    private boolean lostGroundDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (yDistance < 0.0 && !to.isOnGround() && from.isOnGround(from.getY() - to.getY() + 0.001)) {
            Location ref = from.getLocation();
            ref.setY(to.getY());
            if (BlockProperties.isPassable(from.getLocation(), ref)) {
                return this.applyLostGround(player, from, false, data, "vcollide");
            }
        }
        if (data.sfJumpPhase <= 7) {
            if (data.lastYDist <= yDistance && setBackYDistance < 0.0 && !to.isOnGround() && from.isOnGround(0.6, 0.4, 0.0, 0L)) {
                return this.applyLostGround(player, from, true, data, "pyramid");
            }
            if (yDistance == 0.0 && data.lastYDist > 0.0 && data.lastYDist < 0.25 && (double)data.sfJumpPhase <= Math.max(0.0, 6.0 + data.jumpAmplifier * 3.0) && setBackYDistance > 1.0 && setBackYDistance < Math.max(0.0, 1.5 + 0.2 * data.jumpAmplifier) && !to.isOnGround() && from.isOnGround(0.25, 0.4, 0.0, 0L)) {
                return this.applyLostGround(player, from, true, data, "ministep");
            }
        }
        if (yDistance < 0.0 && hDistance <= 1.5 && data.lastYDist < 0.0 && yDistance > data.lastYDist && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.2, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return this.applyLostGround(player, from, true, data, "edgedesc");
        }
        return false;
    }

    private boolean lostGroundFastDescend(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, MovingData data, MovingConfig cc) {
        if (yDistance > data.lastYDist && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.3, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return this.applyLostGround(player, from, true, data, "fastedge");
        }
        return false;
    }

    private boolean applyLostGround(Player player, Location refLoc, boolean setBackSafe, MovingData data, String tag) {
        if (setBackSafe) {
            data.setSetBack(refLoc);
        }
        return this.applyLostGround(player, data, tag);
    }

    private boolean applyLostGround(Player player, PlayerLocation refLoc, boolean setBackSafe, MovingData data, String tag) {
        if (setBackSafe) {
            data.setSetBack(refLoc);
        }
        return this.applyLostGround(player, data, tag);
    }

    private boolean applyLostGround(Player player, MovingData data, String tag) {
        data.sfJumpPhase = 0;
        data.jumpAmplifier = this.getJumpAmplifier(player);
        data.clearAccounting();
        data.noFallAssumeGround = true;
        this.tags.add("lostground_" + tag);
        return true;
    }

    private final Location handleViolation(long now, double result, Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        data.survivalFlyVL += result;
        data.sfVLTime = now;
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, result, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        if (this.executeActions(vd)) {
            return data.getSetBack(to);
        }
        data.clearAccounting();
        data.sfJumpPhase = 0;
        return null;
    }

    protected final void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        data.survivalFlyVL += cc.sfHoverViolation;
        data.sfVLTime = System.currentTimeMillis();
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, cc.sfHoverViolation, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", loc.getX(), loc.getY(), loc.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, "(HOVER)");
            vd.setParameter(ParameterName.DISTANCE, "0.0(HOVER)");
            vd.setParameter(ParameterName.TAGS, "hover");
        }
        if (this.executeActions(vd)) {
            if (data.hasSetBack()) {
                Location newTo = data.getSetBack(loc);
                data.prepareSetBack(newTo);
                player.teleport(newTo, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                player.kickPlayer("Hovering?");
            }
        }
    }

    private final boolean hackCobweb(Player player, MovingData data, PlayerLocation to, long now, double vDistanceAboveLimit) {
        if (now - data.sfCobwebTime > 3000L) {
            data.sfCobwebTime = now;
            data.sfCobwebVL = vDistanceAboveLimit * 100.0;
        } else {
            data.sfCobwebVL += vDistanceAboveLimit * 100.0;
        }
        if (data.sfCobwebVL < 550.0) {
            if (!data.hasSetBack()) {
                data.setSetBack(player.getLocation(this.useLoc));
                this.useLoc.setWorld(null);
            }
            data.sfJumpPhase = 0;
            data.lastHDist = Double.MAX_VALUE;
            data.lastYDist = Double.MAX_VALUE;
            return true;
        }
        return false;
    }

    public void setReallySneaking(Player player, boolean sneaking) {
        if (sneaking) {
            this.reallySneaking.add(player.getName());
        } else {
            this.reallySneaking.remove(player.getName());
        }
    }

    protected final double getJumpAmplifier(Player player) {
        double amplifier = this.mcAccess.getJumpAmplifier(player);
        if (amplifier == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return 1.0 + amplifier;
    }

    private void outputDebug(Player player, PlayerLocation to, MovingData data, MovingConfig cc, double hDistance, double hAllowedDistance, double hFreedom, double yDistance, double vAllowedDistance, boolean fromOnGround, boolean resetFrom, boolean toOnGround, boolean resetTo) {
        StringBuilder builder = new StringBuilder(500);
        String hBuf = data.sfHorizontalBuffer < 1.0 ? " hbuf=" + StringUtil.fdec3.format(data.sfHorizontalBuffer) : "";
        String lostSprint = data.lostSprintCount > 0 ? " lostSprint=" + data.lostSprintCount : "";
        String hVelUsed = hFreedom > 0.0 ? " hVelUsed=" + StringUtil.fdec3.format(hFreedom) : "";
        builder.append(player.getName() + " SurvivalFly\nground: " + (data.noFallAssumeGround ? "(assumeonground) " : "") + (fromOnGround ? "onground -> " : (resetFrom ? "resetcond -> " : "--- -> ")) + (toOnGround ? "onground" : (resetTo ? "resetcond" : "---")) + ", jumpphase: " + data.sfJumpPhase + ", liftoff: " + data.liftOffEnvelope.name() + "(" + data.insideMediumCount + ")");
        String dHDist = data.lastHDist != Double.MAX_VALUE && Math.abs(data.lastHDist - hDistance) > 5.0E-4 ? "(" + (hDistance > data.lastHDist ? "+" : "") + StringUtil.fdec3.format(hDistance - data.lastHDist) + ")" : "";
        builder.append("\n hDist: " + StringUtil.fdec3.format(hDistance) + dHDist + " / " + StringUtil.fdec3.format(hAllowedDistance) + hBuf + lostSprint + hVelUsed + " , vDist: " + StringUtil.fdec3.format(yDistance) + (data.lastYDist == Double.MAX_VALUE ? "" : " (" + (yDistance > data.lastYDist ? "+" : "") + StringUtil.fdec3.format(yDistance - data.lastYDist) + ")") + " / " + StringUtil.fdec3.format(vAllowedDistance) + ", sby=" + (data.hasSetBack() ? data.getSetBackY() + " (" + StringUtil.fdec3.format(to.getY() - data.getSetBackY()) + " / " + data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) + ")" : "?"));
        if (data.verVelUsed != null) {
            builder.append(" vVelUsed= " + data.verVelUsed + " ");
        }
        data.addVerticalVelocity(builder);
        data.addHorizontalVelocity(builder);
        if (!resetFrom && !resetTo && cc.survivalFlyAccountingV && data.vDistAcc.count() > data.vDistAcc.bucketCapacity()) {
            builder.append("\n vacc=" + data.vDistAcc.toInformalString());
        }
        if (player.isSleeping()) {
            this.tags.add("sleeping");
        }
        if (player.getFoodLevel() <= 5 && player.isSprinting()) {
            this.tags.add("lowfoodsprint");
        }
        if (!this.tags.isEmpty()) {
            builder.append("\n tags: " + StringUtil.join(this.tags, "+"));
        }
        builder.append("\n");
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }

    private void logPostViolationTags(Player player) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " SurvivalFly Post violation handling tag update:\n" + StringUtil.join(this.tags, "+"));
    }
}

