/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MovingConfig
extends ACheckConfig {
    public static final CheckConfigFactory factory = new CheckConfigFactory(){

        public final ICheckConfig getConfig(Player player) {
            return MovingConfig.getConfig(player);
        }

        public void removeAllConfigs() {
            MovingConfig.clear();
        }
    };
    private static final Map<String, MovingConfig> worldsMap = new HashMap<String, MovingConfig>();
    public static final double Y_ON_GROUND_MIN = 1.0E-5;
    public static final double Y_ON_GROUND_MAX = 0.0626;
    public static final double Y_ON_GROUND_DEFAULT = 0.016;
    public final boolean ignoreCreative;
    public final boolean ignoreAllowFlight;
    public final boolean creativeFlyCheck;
    public final Map<GameMode, ModelFlying> flyingModels = new HashMap<GameMode, ModelFlying>();
    public final ActionList creativeFlyActions;
    public final boolean morePacketsCheck;
    public final float morePacketsEPSIdeal;
    public final float morePacketsEPSMax;
    public final int morePacketsEPSBuckets;
    public final float morePacketsBurstPackets;
    public final double morePacketsBurstDirect;
    public final double morePacketsBurstEPM;
    public final ActionList morePacketsActions;
    public final boolean morePacketsVehicleCheck;
    public final ActionList morePacketsVehicleActions;
    public final boolean noFallCheck;
    public final boolean noFallDealDamage;
    public final boolean noFallViolationReset;
    public final boolean noFallTpReset;
    public final boolean noFallVehicleReset;
    public final boolean noFallAntiCriticals;
    public final ActionList noFallActions;
    public final boolean passableCheck;
    public final boolean passableRayTracingCheck;
    public final boolean passableRayTracingBlockChangeOnly;
    public final ActionList passableActions;
    public final boolean passableUntrackedTeleportCheck;
    public final boolean passableUntrackedCommandCheck;
    public final boolean passableUntrackedCommandTryTeleport;
    public final SimpleCharPrefixTree passableUntrackedCommandPrefixes = new SimpleCharPrefixTree();
    public final boolean survivalFlyCheck;
    public final int survivalFlyBlockingSpeed;
    public final int survivalFlySneakingSpeed;
    public final int survivalFlySpeedingSpeed;
    public final int survivalFlySprintingSpeed;
    public final int survivalFlySwimmingSpeed;
    public final int survivalFlyWalkingSpeed;
    public final boolean survivalFlyCobwebHack;
    public final boolean sfGroundHop;
    public final boolean survivalFlyAccountingH;
    public final boolean survivalFlyAccountingV;
    public final boolean sfSetBackPolicyVoid;
    public final boolean sfSetBackPolicyFallDamage;
    public final double sfStepHeight;
    public final long survivalFlyVLFreeze;
    public final ActionList survivalFlyActions;
    public final boolean sfHoverCheck;
    public final int sfHoverTicks;
    public final int sfHoverLoginTicks;
    public final boolean sfHoverFallDamage;
    public final double sfHoverViolation;
    public final int velocityActivationCounter;
    public final int velocityActivationTicks;
    public final boolean velocityStrictInvalidation;
    public final double noFallyOnGround;
    public final double yOnGround;
    public final boolean ignoreStance;
    public final boolean tempKickIllegal;
    public final boolean loadChunksOnJoin;
    public final long sprintingGrace;
    public final boolean assumeSprint;
    public final int speedGrace;
    public final boolean enforceLocation;
    public final boolean blockChangeTrackerPush;
    public final boolean vehicleEnforceLocation;
    public final boolean vehiclePreventDestroyOwn;
    public final int traceSize;
    public final double traceMergeDist;

    public static void clear() {
        worldsMap.clear();
    }

    public static MovingConfig getConfig(Player player) {
        return MovingConfig.getConfig(player.getWorld().getName());
    }

    public static MovingConfig getConfig(String worldName) {
        MovingConfig cc = worldsMap.get(worldName);
        if (cc != null) {
            return cc;
        }
        MovingConfig ccNew = new MovingConfig(ConfigManager.getConfigFile(worldName));
        worldsMap.put(worldName, ccNew);
        return ccNew;
    }

    public MovingConfig(ConfigFile config) {
        super(config, "checks.moving.");
        this.ignoreCreative = config.getBoolean("checks.moving.creativefly.ignorecreative");
        this.ignoreAllowFlight = config.getBoolean("checks.moving.creativefly.ignoreallowflight");
        this.creativeFlyCheck = config.getBoolean("checks.moving.creativefly.active");
        ModelFlying defaultModel = new ModelFlying((ConfigurationSection)config, "checks.moving.creativefly.model.creative.", new ModelFlying());
        for (GameMode gameMode : GameMode.values()) {
            this.flyingModels.put(gameMode, new ModelFlying((ConfigurationSection)config, "checks.moving.creativefly.model." + gameMode.name().toLowerCase() + ".", defaultModel));
        }
        this.creativeFlyActions = (ActionList)config.getOptimizedActionList("checks.moving.creativefly.actions", "nocheatplus.checks.moving.creativefly");
        this.morePacketsCheck = config.getBoolean("checks.moving.morepackets.active");
        this.morePacketsEPSIdeal = config.getInt("checks.moving.morepackets.epsideal");
        this.morePacketsEPSMax = Math.max(this.morePacketsEPSIdeal, (float)config.getInt("checks.moving.morepackets.epsmax"));
        this.morePacketsEPSBuckets = 2 * Math.max(1, Math.min(60, config.getInt("checks.moving.morepackets.seconds")));
        this.morePacketsBurstPackets = config.getInt("checks.moving.morepackets.burst.epmviolation");
        this.morePacketsBurstDirect = config.getInt("checks.moving.morepackets.burst.directviolation");
        this.morePacketsBurstEPM = config.getInt("checks.moving.morepackets.burst.epmviolation");
        this.morePacketsActions = (ActionList)config.getOptimizedActionList("checks.moving.morepackets.actions", "nocheatplus.checks.moving.morepackets");
        this.morePacketsVehicleCheck = config.getBoolean("checks.moving.morepacketsvehicle.active");
        this.morePacketsVehicleActions = (ActionList)config.getOptimizedActionList("checks.moving.morepacketsvehicle.actions", "nocheatplus.checks.moving.morepackets");
        this.noFallCheck = config.getBoolean("checks.moving.nofall.active");
        this.noFallDealDamage = config.getBoolean("checks.moving.nofall.dealdamage");
        this.noFallViolationReset = config.getBoolean("checks.moving.nofall.resetonviolation");
        this.noFallTpReset = config.getBoolean("checks.moving.nofall.resetonteleport");
        this.noFallVehicleReset = config.getBoolean("checks.moving.nofall.resetonvehicle");
        this.noFallAntiCriticals = config.getBoolean("checks.moving.nofall.anticriticals");
        this.noFallActions = (ActionList)config.getOptimizedActionList("checks.moving.nofall.actions", "nocheatplus.checks.moving.nofall");
        this.passableCheck = config.getBoolean("checks.moving.passable.active");
        this.passableRayTracingCheck = config.getBoolean("checks.moving.passable.raytracing.active");
        this.passableRayTracingBlockChangeOnly = config.getBoolean("checks.moving.passable.raytracing.blockchangeonly");
        this.passableActions = (ActionList)config.getOptimizedActionList("checks.moving.passable.actions", "nocheatplus.checks.moving.passable");
        this.passableUntrackedTeleportCheck = config.getBoolean("checks.moving.passable.untracked.teleport.active");
        this.passableUntrackedCommandCheck = config.getBoolean("checks.moving.passable.untracked.command.active");
        this.passableUntrackedCommandTryTeleport = config.getBoolean("checks.moving.passable.untracked.command.tryteleport");
        CommandUtil.feedCommands(this.passableUntrackedCommandPrefixes, config, "checks.moving.passable.untracked.command.prefixes", true);
        this.survivalFlyCheck = config.getBoolean("checks.moving.survivalfly.active");
        this.survivalFlyBlockingSpeed = config.getInt("checks.moving.survivalfly.blockingspeed", 100);
        this.survivalFlySneakingSpeed = config.getInt("checks.moving.survivalfly.sneakingspeed", 100);
        this.survivalFlySpeedingSpeed = config.getInt("checks.moving.survivalfly.speedingspeed", 200);
        this.survivalFlySprintingSpeed = config.getInt("checks.moving.survivalfly.sprintingspeed", 100);
        this.survivalFlySwimmingSpeed = config.getInt("checks.moving.survivalfly.swimmingspeed", 100);
        this.survivalFlyWalkingSpeed = config.getInt("checks.moving.survivalfly.walkingspeed", 100);
        this.survivalFlyCobwebHack = config.getBoolean("checks.moving.survivalfly.cobwebhack", true);
        this.sfGroundHop = config.getBoolean("checks.moving.survivalfly.groundhop", ServerVersion.compareMinecraftVersion("1.7") == -1);
        this.survivalFlyAccountingH = config.getBoolean("checks.moving.survivalfly.extended.horizontal-accounting", false);
        this.survivalFlyAccountingV = config.getBoolean("checks.moving.survivalfly.extended.vertical-accounting");
        this.sfSetBackPolicyFallDamage = config.getBoolean("checks.moving.survivalfly.setbackpolicy.falldamage");
        this.sfSetBackPolicyVoid = config.getBoolean("checks.moving.survivalfly.setbackpolicy.voidtovoid");
        double sfStepHeight = config.getDouble("checks.moving.survivalfly.stepheight", Double.MAX_VALUE);
        if (sfStepHeight == Double.MAX_VALUE) {
            String ref = Bukkit.getVersion().toLowerCase().indexOf("spigot") != -1 ? "1.7.10" : "1.8";
            this.sfStepHeight = ServerVersion.select(ref, 0.5, 0.6, 0.6, 0.5);
        } else {
            this.sfStepHeight = sfStepHeight;
        }
        this.survivalFlyVLFreeze = config.getLong("checks.moving.survivalfly.vlfreeze", 2000L);
        this.survivalFlyActions = (ActionList)config.getOptimizedActionList("checks.moving.survivalfly.actions", "nocheatplus.checks.moving.survivalfly");
        this.sfHoverCheck = config.getBoolean("checks.moving.survivalfly.hover.active");
        this.sfHoverTicks = config.getInt("checks.moving.survivalfly.hover.ticks");
        this.sfHoverLoginTicks = Math.max(0, config.getInt("checks.moving.survivalfly.hover.loginticks"));
        this.sfHoverFallDamage = config.getBoolean("checks.moving.survivalfly.hover.falldamage");
        this.sfHoverViolation = config.getDouble("checks.moving.survivalfly.hover.sfviolation");
        this.velocityActivationCounter = config.getInt("checks.moving.velocity.activationcounter");
        this.velocityActivationTicks = config.getInt("checks.moving.velocity.activationticks");
        this.velocityStrictInvalidation = config.getBoolean("checks.moving.velocity.strictinvalidation");
        this.yOnGround = config.getDouble("checks.moving.yonground", 1.0E-5, 0.0626, 0.016);
        this.noFallyOnGround = config.getDouble("checks.moving.nofall.yonground", 1.0E-5, 0.0626, this.yOnGround);
        AlmostBoolean refIgnoreStance = config.getAlmostBoolean("checks.moving.ignorestance", AlmostBoolean.MAYBE);
        this.ignoreStance = refIgnoreStance == AlmostBoolean.MAYBE ? ServerVersion.compareMinecraftVersion("1.8") >= 0 : refIgnoreStance.decide();
        this.tempKickIllegal = config.getBoolean("checks.moving.tempkickillegal");
        this.loadChunksOnJoin = config.getBoolean("checks.moving.loadchunks.join");
        this.sprintingGrace = Math.max(0L, (long)(config.getDouble("checks.moving.sprintinggrace") * 1000.0));
        this.assumeSprint = config.getBoolean("checks.moving.assumesprint");
        this.speedGrace = Math.max(0, (int)Math.round(config.getDouble("checks.moving.speedgrace") * 20.0));
        AlmostBoolean ref = config.getAlmostBoolean("checks.moving.enforcelocation", AlmostBoolean.MAYBE);
        this.enforceLocation = ref == AlmostBoolean.MAYBE ? Bugs.shouldEnforceLocation() : ref.decide();
        this.blockChangeTrackerPush = config.getBoolean("compatibility.blocks.changetracker.active") && config.getBoolean("compatibility.blocks.changetracker.pistons");
        ref = config.getAlmostBoolean("checks.moving.vehicles.enforcelocation", AlmostBoolean.MAYBE);
        this.vehicleEnforceLocation = ref.decideOptimistically();
        this.vehiclePreventDestroyOwn = config.getBoolean("checks.moving.vehicles.preventdestroyown");
        this.traceSize = config.getInt("checks.moving.trace.size");
        this.traceMergeDist = config.getDouble("checks.moving.trace.mergedist");
    }

    public final boolean isEnabled(CheckType checkType) {
        switch (checkType) {
            case MOVING_NOFALL: {
                return this.noFallCheck;
            }
            case MOVING_SURVIVALFLY: {
                return this.survivalFlyCheck;
            }
            case MOVING_PASSABLE: {
                return this.passableCheck;
            }
            case MOVING_MOREPACKETS: {
                return this.morePacketsCheck;
            }
            case MOVING_MOREPACKETSVEHICLE: {
                return this.morePacketsVehicleCheck;
            }
            case MOVING_CREATIVEFLY: {
                return this.creativeFlyCheck;
            }
        }
        return true;
    }
}

