/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static void checkMembers(String prefix, String[] ... specs) {
        try {
            for (String[] spec : specs) {
                Class<?> clazz = Class.forName(prefix + spec[0]);
                for (int i = 1; i < spec.length; ++i) {
                    if (clazz.getField(spec[i]) != null) continue;
                    throw new NoSuchFieldException(prefix + spec[0] + " : " + spec[i]);
                }
            }
        }
        catch (SecurityException arr$) {
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void checkMethodReturnTypesNoArgs(Class<?> objClass, String[] methodNames, Class<?> returnType) {
        try {
            for (String methodName : methodNames) {
                Method m = objClass.getMethod(methodName, new Class[0]);
                if (m.getParameterTypes().length != 0) {
                    throw new RuntimeException("Expect method without arguments for " + objClass.getName() + "." + methodName);
                }
                if (m.getReturnType() == returnType) continue;
                throw new RuntimeException("Wrong return type for: " + objClass.getName() + "." + methodName);
            }
        }
        catch (SecurityException arr$) {
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object invokeGenericMethodOneArg(Object obj, String methodName, Object arg) {
        Class<?> objClass = obj.getClass();
        Class<?> argClass = arg.getClass();
        Method methodFound = null;
        boolean denyObject = false;
        for (Method method : objClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            if (parameterTypes[0] != Object.class && !parameterTypes[0].isAssignableFrom(argClass)) {
                denyObject = true;
            }
            if ((methodFound != null || !parameterTypes[0].isAssignableFrom(argClass)) && (methodFound == null || !methodFound.getParameterTypes()[0].isAssignableFrom(parameterTypes[0]))) continue;
            methodFound = method;
        }
        if (denyObject && methodFound.getParameterTypes()[0] == Object.class) {
            return null;
        }
        if (methodFound != null && methodFound.getParameterTypes()[0].isAssignableFrom(argClass)) {
            try {
                Object res = methodFound.invoke(obj, arg);
                return res;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public static Object invokeMethodNoArgs(Object obj, String methodName, Class<?> ... returnTypePreference) {
        Class<?> objClass = obj.getClass();
        Method methodFound = ReflectionUtil.getMethodNoArgs(objClass, methodName, returnTypePreference);
        if (methodFound == null) {
            methodFound = ReflectionUtil.seekMethodNoArgs(objClass, methodName, returnTypePreference);
        }
        if (methodFound != null) {
            try {
                Object res = methodFound.invoke(obj, new Object[0]);
                return res;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public static Object invokeMethodNoArgs(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static Method getMethodNoArgs(Class<?> objClass, String methodName, Class<?> ... returnTypePreference) {
        try {
            Method methodFound = objClass.getMethod(methodName, new Class[0]);
            if (methodFound != null) {
                if (returnTypePreference == null || returnTypePreference.length == 0) {
                    return methodFound;
                }
                Class<?> returnType = methodFound.getReturnType();
                for (int i = 0; i < returnTypePreference.length; ++i) {
                    if (returnType != returnTypePreference[i]) continue;
                    return methodFound;
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Method seekMethodNoArgs(Class<?> objClass, String methodName, Class<?>[] returnTypePreference) {
        Method methodFound = null;
        int returnTypeIndex = returnTypePreference.length;
        for (Method method : objClass.getMethods()) {
            int i;
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 0) continue;
            Class<?> returnType = method.getReturnType();
            if (methodFound == null) {
                methodFound = method;
                for (i = 0; i < returnTypeIndex; ++i) {
                    if (returnTypePreference[i] != returnType) continue;
                    returnTypeIndex = i;
                    break;
                }
            } else {
                for (i = 0; i < returnTypeIndex; ++i) {
                    if (returnTypePreference[i] != returnType) continue;
                    methodFound = method;
                    returnTypeIndex = i;
                    break;
                }
            }
            if (returnTypeIndex == 0) break;
        }
        return methodFound;
    }

    public static Field getField(Class<?> clazz, String fieldName, Class<?> type) {
        try {
            Field field = clazz.getField(fieldName);
            if (type == null || field.getType() == type) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static boolean set(Field field, Object object, Object value) {
        try {
            field.set(object, value);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    public static boolean getBoolean(Field field, Object object, boolean defaultValue) {
        try {
            return field.getBoolean(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static int getInt(Field field, Object object, int defaultValue) {
        try {
            return field.getInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Object get(Field field, Object object, Object defaultValue) {
        try {
            return field.get(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... arguments) {
        try {
            return clazz.getMethod(methodName, arguments);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] ... argumentLists) {
        Method method = null;
        for (Class<?>[] arguments : argumentLists) {
            method = ReflectionUtil.getMethod(clazz, methodName, arguments);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Object newInstance(Constructor<?> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

