/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.MCAccessConfig;
import fr.neatmonster.nocheatplus.compat.bukkit.MCAccessBukkit;
import fr.neatmonster.nocheatplus.compat.cbreflect.MCAccessCBReflect;
import fr.neatmonster.nocheatplus.compat.glowstone.MCAccessGlowstone;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCAccessFactory {
    private final String[] updateLocs = new String[]{" Check for updates and support at BukkitDev: http://dev.bukkit.org/server-mods/nocheatplus/", " Development builds (unsupported by the Bukkit Staff, use at your own risk): http://ci.md-5.net/job/NoCheatPlus/changes"};

    public MCAccess getMCAccess(MCAccessConfig config) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        MCAccess mcAccess = null;
        if (config.enableCBDedicated && (mcAccess = this.getMCAccessCraftBukkit(throwables)) != null) {
            return mcAccess;
        }
        if (config.enableCBReflect) {
            try {
                return new MCAccessCBReflect();
            }
            catch (Throwable t) {
                throwables.add(t);
            }
        }
        try {
            return new MCAccessGlowstone();
        }
        catch (Throwable t) {
            throwables.add(t);
            try {
                mcAccess = new MCAccessBukkit();
                String msg = "Running in Bukkit-API-only mode (" + Bukkit.getServer().getVersion() + "). If this is not intended, please check for updates and consider to request support.";
                StaticLog.logWarning(msg);
                for (String uMsg : this.updateLocs) {
                    StaticLog.logWarning(uMsg);
                }
                StaticLog.logWarning("Bukkit-API-only mode: Some features will likely not function properly, performance might suffer.");
                return mcAccess;
            }
            catch (Throwable t2) {
                throwables.add(t2);
                StaticLog.logSevere("Your version of NoCheatPlus is not compatible with the version of the server-mod (" + Bukkit.getServer().getVersion() + "). Please check for updates and consider to request support.");
                for (String msg : this.updateLocs) {
                    StaticLog.logSevere(msg);
                }
                StaticLog.logSevere(">>> Failed to set up MCAccess <<<");
                MCAccessFactory.log(throwables);
                throw new RuntimeException("Could not set up native access to the server mod, neither to the Bukkit-API.");
            }
        }
    }

    private static void log(Collection<Throwable> throwables) {
        for (Throwable t : throwables) {
            StaticLog.logSevere(t);
        }
    }

    private MCAccess getMCAccessCraftBukkit(List<Throwable> throwables) {
        String[] classNames;
        for (String className : classNames = new String[]{"fr.neatmonster.nocheatplus.compat.spigotcb1_8_R3.MCAccessSpigotCB1_8_R3", "fr.neatmonster.nocheatplus.compat.spigotcb1_8_R2.MCAccessSpigotCB1_8_R2", "fr.neatmonster.nocheatplus.compat.spigotcb1_8_R1.MCAccessSpigotCB1_8_R1", "fr.neatmonster.nocheatplus.compat.cb3100.MCAccessCB3100", "fr.neatmonster.nocheatplus.compat.cb3043.MCAccessCB3043", "fr.neatmonster.nocheatplus.compat.cb3026.MCAccessCB3026", "fr.neatmonster.nocheatplus.compat.cb2922.MCAccessCB2922", "fr.neatmonster.nocheatplus.compat.cb2882.MCAccessCB2882", "fr.neatmonster.nocheatplus.compat.cb2808.MCAccessCB2808", "fr.neatmonster.nocheatplus.compat.cb2794.MCAccessCB2794", "fr.neatmonster.nocheatplus.compat.cb2763.MCAccessCB2763", "fr.neatmonster.nocheatplus.compat.cb2691.MCAccessCB2691", "fr.neatmonster.nocheatplus.compat.cb2645.MCAccessCB2645", "fr.neatmonster.nocheatplus.compat.cb2602.MCAccessCB2602", "fr.neatmonster.nocheatplus.compat.cb2545.MCAccessCB2545", "fr.neatmonster.nocheatplus.compat.cb2512.MCAccessCB2512"}) {
            try {
                return (MCAccess)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                throwables.add(t);
            }
        }
        return null;
    }
}

