/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import org.bukkit.entity.Player;

public class FlyingFrequency
extends Check {
    public static final double minMoveDistSq = 0.00390625;
    public static final float minLookChange = 10.0f;

    public FlyingFrequency() {
        super(CheckType.NET_FLYINGFREQUENCY);
    }

    public boolean check(Player player, DataPacketFlying packetData, long time, NetData data, NetConfig cc) {
        data.flyingFrequencyAll.add(time, 1.0f);
        float allScore = data.flyingFrequencyAll.score(1.0f);
        return (double)(allScore / (float)cc.flyingFrequencySeconds) > cc.flyingFrequencyPPS && !CheckUtils.hasBypass(CheckType.NET_FLYINGFREQUENCY, player, data) && this.executeActions(player, (double)(allScore / (float)cc.flyingFrequencySeconds) - cc.flyingFrequencyPPS, 1.0 / (double)cc.flyingFrequencySeconds, cc.flyingFrequencyActions);
    }

    private boolean checkRedundantPackets(Player player, DataPacketFlying packetData, float allScore, long time, NetData data, NetConfig cc) {
        MovingData mData = MovingData.getData(player);
        if (mData.toX == Double.MAX_VALUE && mData.toYaw == Float.MAX_VALUE) {
            return false;
        }
        boolean onGroundSkip = false;
        if (packetData.onGround != data.flyingFrequencyOnGround) {
            long lastTime;
            if (packetData.onGround) {
                lastTime = data.flyingFrequencyTimeOnGround;
                data.flyingFrequencyTimeOnGround = time;
            } else {
                lastTime = data.flyingFrequencyTimeNotOnGround;
                data.flyingFrequencyTimeNotOnGround = time;
            }
            if (time < lastTime || time - lastTime > 1000L) {
                onGroundSkip = true;
            }
        }
        data.flyingFrequencyOnGround = packetData.onGround;
        if (packetData.hasPos && TrigUtil.distanceSquared(packetData.x, packetData.y, packetData.z, mData.toX, mData.toY, mData.toZ) > 0.00390625) {
            return false;
        }
        if (packetData.hasLook && (Math.abs(TrigUtil.yawDiff(packetData.yaw, mData.toYaw)) > 10.0f || Math.abs(TrigUtil.yawDiff(packetData.pitch, mData.toPitch)) > 10.0f)) {
            return false;
        }
        if (onGroundSkip) {
            return false;
        }
        if (allScore / (float)cc.flyingFrequencySeconds > 20.0f && !this.hasBypass(player)) {
            data.flyingFrequencyRedundantFreq.add(time, 1.0f);
            if (this.executeActions(player, data.flyingFrequencyRedundantFreq.score(1.0f) / (float)cc.flyingFrequencyRedundantSeconds, 1.0 / (double)cc.flyingFrequencyRedundantSeconds, cc.flyingFrequencyRedundantActions)) {
                return true;
            }
        }
        return false;
    }
}

