/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class FastPlace
extends Check {
    public FastPlace() {
        super(CheckType.BLOCKPLACE_FASTPLACE);
    }

    public boolean check(Player player, Block block, BlockPlaceData data, BlockPlaceConfig cc) {
        data.fastPlaceBuckets.add(System.currentTimeMillis(), 1.0f);
        float fullScore = data.fastPlaceBuckets.score(1.0f);
        int tick = TickTask.getTick();
        if (tick < data.fastPlaceShortTermTick) {
            data.fastPlaceShortTermTick = tick;
            data.fastPlaceShortTermCount = 1;
        } else if (tick - data.fastPlaceShortTermTick < cc.fastPlaceShortTermTicks) {
            if (!cc.lag || TickTask.getLag(50L * (long)(tick - data.fastPlaceShortTermTick), true) < 1.2f) {
                ++data.fastPlaceShortTermCount;
            } else {
                data.fastPlaceShortTermTick = tick;
                data.fastPlaceShortTermCount = 1;
            }
        } else {
            data.fastPlaceShortTermTick = tick;
            data.fastPlaceShortTermCount = 1;
        }
        float fullViolation = fullScore > (float)cc.fastPlaceLimit ? (cc.lag ? fullScore / TickTask.getLag(data.fastPlaceBuckets.bucketDuration() * (long)data.fastPlaceBuckets.numberOfBuckets(), true) - (float)cc.fastPlaceLimit : fullScore - (float)cc.fastPlaceLimit) : 0.0f;
        float shortTermViolation = data.fastPlaceShortTermCount - cc.fastPlaceShortTermLimit;
        float violation = Math.max(fullViolation, shortTermViolation);
        boolean cancel = false;
        if (violation > 0.0f) {
            double change = violation;
            data.fastPlaceVL += change;
            cancel = this.executeActions(player, data.fastPlaceVL, change, cc.fastPlaceActions);
        } else if (data.fastPlaceVL > 0.0 && (double)fullScore < (double)cc.fastPlaceLimit * 0.75) {
            data.fastPlaceVL *= 0.95;
        }
        return cancel;
    }
}

