/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.prefixtree;

import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.CharPrefixTree;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.PrefixTree;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedCharPrefixTree<N extends TimedCharNode<N>, L extends TimedCharLookupEntry<N>>
extends CharPrefixTree<N, L> {
    protected long ts;
    protected long[] timeInsertion = new long[200];
    protected final boolean access;
    protected boolean updateTime = false;
    protected int depth;
    protected float arrayGrowth = 1.3f;

    public TimedCharPrefixTree(PrefixTree.NodeFactory<Character, N> nodeFactory, PrefixTree.LookupEntryFactory<Character, N, L> resultFactory, boolean access) {
        super(nodeFactory, resultFactory);
        this.visit = true;
        this.access = access;
    }

    @Override
    public L lookup(List<Character> keys, boolean create) {
        this.ts = System.currentTimeMillis();
        this.updateTime = this.access || create;
        this.depth = 0;
        return (L)((TimedCharLookupEntry)super.lookup(keys, create));
    }

    @Override
    protected void visit(N node) {
        if (this.depth == this.timeInsertion.length) {
            this.timeInsertion = Arrays.copyOf(this.timeInsertion, (int)((float)this.timeInsertion.length * this.arrayGrowth));
        }
        this.timeInsertion[this.depth] = ((TimedCharNode)node).ts;
        if (this.updateTime) {
            ((TimedCharNode)node).ts = this.ts;
        }
        ++this.depth;
    }

    @Override
    protected void decorate(L result) {
        ((TimedCharLookupEntry)result).timeInsertion = Arrays.copyOf(this.timeInsertion, this.depth);
    }

    public static TimedCharPrefixTree<SimpleTimedCharNode, TimedCharLookupEntry<SimpleTimedCharNode>> newTimedCharPrefixTree(boolean access) {
        return new TimedCharPrefixTree<SimpleTimedCharNode, TimedCharLookupEntry<SimpleTimedCharNode>>(new PrefixTree.NodeFactory<Character, SimpleTimedCharNode>(){

            @Override
            public final SimpleTimedCharNode newNode(SimpleTimedCharNode parent) {
                long ts = parent == null ? System.currentTimeMillis() : parent.ts;
                return new SimpleTimedCharNode(ts);
            }
        }, new PrefixTree.LookupEntryFactory<Character, SimpleTimedCharNode, TimedCharLookupEntry<SimpleTimedCharNode>>(){

            @Override
            public final TimedCharLookupEntry<SimpleTimedCharNode> newLookupEntry(SimpleTimedCharNode node, SimpleTimedCharNode insertion, int depth, boolean hasPrefix) {
                return new TimedCharLookupEntry<SimpleTimedCharNode>(node, insertion, depth, hasPrefix);
            }
        }, access);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleTimedCharNode
    extends TimedCharNode<SimpleTimedCharNode> {
        public SimpleTimedCharNode(long ts) {
            super(ts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimedCharNode<N extends TimedCharNode<N>>
    extends CharPrefixTree.CharNode<N> {
        public long ts = 0L;

        public TimedCharNode(long ts) {
            this.ts = ts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimedCharLookupEntry<N extends TimedCharNode<N>>
    extends CharPrefixTree.CharLookupEntry<N> {
        public long[] timeInsertion = null;

        public TimedCharLookupEntry(N node, N insertion, int depth, boolean hasPrefix) {
            super(node, insertion, depth, hasPrefix);
        }
    }
}

