/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.corw;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMapCOW<K, V>
implements Map<K, V> {
    private LinkedHashMap<K, V> map;
    private final int initialCapacity;
    private final float loadFactor;

    public LinkedHashMapCOW() {
        this(16, 0.75f);
    }

    public LinkedHashMapCOW(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LinkedHashMapCOW(int initialCapacity, float loadFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.map = new LinkedHashMap(initialCapacity, loadFactor, false);
    }

    public LinkedHashMapCOW(Map<K, V> map) {
        this();
        this.map.putAll(map);
    }

    private LinkedHashMap<K, V> copyMap() {
        LinkedHashMap<K, V> newMap = new LinkedHashMap<K, V>(this.initialCapacity, this.loadFactor, false);
        newMap.putAll(this.map);
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedHashMapCOW linkedHashMapCOW = this;
        synchronized (linkedHashMapCOW) {
            this.map.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V out;
        LinkedHashMapCOW linkedHashMapCOW = this;
        synchronized (linkedHashMapCOW) {
            LinkedHashMap<K, V> newMap = this.copyMap();
            out = newMap.put(key, value);
            this.map = newMap;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        LinkedHashMapCOW linkedHashMapCOW = this;
        synchronized (linkedHashMapCOW) {
            LinkedHashMap<? extends K, ? extends V> newMap = this.copyMap();
            newMap.putAll(m);
            this.map = newMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object out;
        LinkedHashMapCOW linkedHashMapCOW = this;
        synchronized (linkedHashMapCOW) {
            LinkedHashMap<K, V> newMap = this.copyMap();
            out = newMap.remove(key);
            this.map = newMap;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<K> keys) {
        LinkedHashMapCOW linkedHashMapCOW = this;
        synchronized (linkedHashMapCOW) {
            LinkedHashMap<K, V> newMap = this.copyMap();
            for (K key : keys) {
                newMap.remove(key);
            }
            this.map = newMap;
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }
}

