/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.checks.access.CheckConfigFactory;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckConfig;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.ComponentRegistry;
import fr.neatmonster.nocheatplus.components.ComponentWithName;
import fr.neatmonster.nocheatplus.components.ConsistencyChecker;
import fr.neatmonster.nocheatplus.components.DisableListener;
import fr.neatmonster.nocheatplus.components.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.INeedConfig;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.IRemoveData;
import fr.neatmonster.nocheatplus.components.order.SetupOrder;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.hooks.APIUtils;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.ExecutionHistory;
import fr.neatmonster.nocheatplus.players.PlayerData;
import fr.neatmonster.nocheatplus.players.PlayerMap;
import fr.neatmonster.nocheatplus.utilities.IdUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SetupOrder(priority=-80)
public class DataManager
implements Listener,
INotifyReload,
INeedConfig,
ComponentRegistry<IRemoveData>,
ComponentWithName,
ConsistencyChecker,
DisableListener {
    protected static DataManager instance = null;
    private int foundInconsistencies = 0;
    protected final Map<String, PlayerData> playerData = new LinkedHashMap<String, PlayerData>(100);
    private final Map<String, Long> lastLogout = new LinkedHashMap<String, Long>(50, 0.75f, true);
    protected final PlayerMap playerMap;
    protected final ArrayList<IRemoveData> iRemoveData = new ArrayList();
    protected final Map<CheckType, Map<String, ExecutionHistory>> executionHistories = new HashMap<CheckType, Map<String, ExecutionHistory>>();
    protected boolean doExpireData = false;
    protected long durExpireData = 0L;
    protected boolean deleteData = true;
    protected boolean deleteHistory = false;

    public DataManager() {
        instance = this;
        String version = ServerVersion.getMinecraftVersion();
        this.playerMap = ServerVersion.compareVersions(version, "1.8") >= 0 || version.equals("1.7.10") && Bukkit.getServer().getVersion().toLowerCase().indexOf("spigot") != -1 ? new PlayerMap(false) : new PlayerMap(true);
    }

    public void checkExpiration() {
        Map.Entry<String, Long> entry;
        long ts;
        if (!this.doExpireData || this.durExpireData <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        LinkedHashSet<CheckDataFactory> factories = new LinkedHashSet<CheckDataFactory>();
        Set<Map.Entry<String, Long>> entries = this.lastLogout.entrySet();
        Iterator<Map.Entry<String, Long>> iterator = entries.iterator();
        while (iterator.hasNext() && now - (ts = (entry = iterator.next()).getValue().longValue()) > this.durExpireData) {
            String playerName = entry.getKey();
            if (this.deleteData) {
                factories.clear();
                for (CheckType type : CheckType.values()) {
                    CheckDataFactory factory = type.getDataFactory();
                    if (factory == null) continue;
                    factories.add(factory);
                }
                for (CheckDataFactory factory : factories) {
                    factory.removeData(playerName);
                }
                DataManager.clearComponentData(CheckType.ALL, playerName);
                this.playerData.remove(playerName.toLowerCase());
            }
            if (this.deleteData || this.deleteHistory) {
                DataManager.removeExecutionHistory(CheckType.ALL, playerName);
            }
            if (this.deleteHistory) {
                ViolationHistory.removeHistory(playerName);
            }
            iterator.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.lastLogout.remove(player.getName());
        CombinedData.getData((Player)player).lastJoinTime = System.currentTimeMillis();
        this.addOnlinePlayer(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onLeave(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        this.onLeave(event.getPlayer());
    }

    private final void onLeave(Player player) {
        long now = System.currentTimeMillis();
        this.lastLogout.put(player.getName(), now);
        CombinedData.getData((Player)player).lastLogoutTime = now;
        this.removeOnlinePlayer(player);
    }

    @Override
    public void onReload() {
        this.adjustSettings();
    }

    private void adjustSettings() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.doExpireData = config.getBoolean("data.expiration.active");
        this.durExpireData = config.getLong("data.expiration.duration", 1L, 1000000L, 60L) * 60000L;
        this.deleteData = config.getBoolean("data.expiration.data", true);
        this.deleteHistory = config.getBoolean("data.expiration.history");
    }

    public static void registerExecutionHistory(CheckType type, Map<String, ExecutionHistory> histories) {
        DataManager.instance.executionHistories.put(type, histories);
    }

    public static ExecutionHistory getExecutionHistory(CheckType type, String playerName) {
        Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)type);
        if (map != null) {
            return map.get(playerName);
        }
        return null;
    }

    public static boolean removeExecutionHistory(CheckType type, String playerName) {
        boolean removed = false;
        for (CheckType refType : APIUtils.getWithChildren(type)) {
            Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)refType);
            if (map == null || map.remove(playerName) == null) continue;
            removed = true;
        }
        return removed;
    }

    public static void clear(CheckType checkType) {
        DataManager.clearData(checkType);
    }

    public static void clearData(CheckType checkType) {
        HashSet<CheckDataFactory> factories = new HashSet<CheckDataFactory>();
        for (CheckType type : APIUtils.getWithChildren(checkType)) {
            CheckDataFactory factory;
            Map<String, ExecutionHistory> map = DataManager.instance.executionHistories.get((Object)type);
            if (map != null) {
                map.clear();
            }
            if ((factory = type.getDataFactory()) == null) continue;
            factories.add(factory);
        }
        for (CheckDataFactory factory : factories) {
            factory.removeAllData();
        }
        for (IRemoveData rmd : DataManager.instance.iRemoveData) {
            CheckType refType;
            if (checkType == CheckType.ALL) {
                rmd.removeAllData();
                continue;
            }
            if (!(rmd instanceof IHaveCheckType) || (refType = ((IHaveCheckType)((Object)rmd)).getCheckType()) != checkType && !APIUtils.isParent(checkType, refType)) continue;
            rmd.removeAllData();
        }
        ViolationHistory.clear(checkType);
        if (checkType == CheckType.ALL) {
            DataManager.instance.playerData.clear();
        }
    }

    public static void restoreDefaultDebugFlags() {
        Player[] players = BridgeMisc.getOnlinePlayers();
        for (CheckType checkType : CheckType.values()) {
            CheckDataFactory dataFactory;
            CheckConfigFactory configFactory = checkType.getConfigFactory();
            if (configFactory == null || (dataFactory = checkType.getDataFactory()) == null) continue;
            for (int i = 0; i < players.length; ++i) {
                ICheckData data;
                Player player = players[i];
                ICheckConfig config = configFactory.getConfig(player);
                if (config == null || (data = dataFactory.getData(player)) == null || config.getDebug() == data.getDebug()) continue;
                data.setDebug(config.getDebug());
            }
        }
    }

    public static boolean removeData(String playerName, CheckType checkType) {
        if (checkType == null) {
            checkType = CheckType.ALL;
        }
        boolean had = false;
        if (DataManager.clearComponentData(checkType, playerName)) {
            had = true;
        }
        HashSet<CheckDataFactory> factories = new HashSet<CheckDataFactory>();
        for (CheckType otherType : APIUtils.getWithChildren(checkType)) {
            CheckDataFactory otherFactory = otherType.getDataFactory();
            if (otherFactory == null) continue;
            factories.add(otherFactory);
        }
        for (CheckDataFactory otherFactory : factories) {
            if (otherFactory.removeData(playerName) == null) continue;
            had = true;
        }
        if (checkType == CheckType.ALL) {
            DataManager.instance.playerData.remove(playerName.toLowerCase());
        }
        return had;
    }

    public static boolean clearComponentData(CheckType checkType, String PlayerName) {
        boolean removed = false;
        for (IRemoveData rmd : DataManager.instance.iRemoveData) {
            CheckType refType;
            if (checkType == CheckType.ALL) {
                if (rmd.removeData(PlayerName) == null) continue;
                removed = true;
                continue;
            }
            if (!(rmd instanceof IHaveCheckType) || (refType = ((IHaveCheckType)((Object)rmd)).getCheckType()) != checkType && !APIUtils.isParent(checkType, refType) || rmd.removeData(PlayerName) == null) continue;
            removed = true;
        }
        return removed;
    }

    public static void clearConfigs() {
        LinkedHashSet<CheckConfigFactory> factories = new LinkedHashSet<CheckConfigFactory>();
        for (CheckType checkType : CheckType.values()) {
            CheckConfigFactory factory = checkType.getConfigFactory();
            if (factory == null) continue;
            factories.add(factory);
        }
        for (CheckConfigFactory factory : factories) {
            factory.removeAllConfigs();
        }
    }

    public static Player getPlayerExact(String playerName) {
        return DataManager.instance.playerMap.getPlayerExact(playerName);
    }

    public static UUID getUUID(String input) {
        Player player = DataManager.getPlayer(input);
        if (player != null) {
            return player.getUniqueId();
        }
        return IdUtil.UUIDFromStringSafe(input);
    }

    public static Player getPlayer(UUID id) {
        return DataManager.instance.playerMap.getPlayer(id);
    }

    public static Player getPlayer(String playerName) {
        return DataManager.instance.playerMap.getPlayer(playerName);
    }

    @Override
    public boolean addComponent(IRemoveData obj) {
        if (this.iRemoveData.contains(obj)) {
            return false;
        }
        this.iRemoveData.add(obj);
        return true;
    }

    @Override
    public void removeComponent(IRemoveData obj) {
        this.iRemoveData.remove(obj);
    }

    public void onEnable() {
        for (Player player : BridgeMisc.getOnlinePlayers()) {
            this.addOnlinePlayer(player);
        }
    }

    private void addOnlinePlayer(Player player) {
        this.playerMap.updatePlayer(player);
    }

    private void removeOnlinePlayer(Player player) {
        this.playerMap.remove(player);
    }

    @Override
    public void onDisable() {
        DataManager.clearData(CheckType.ALL);
        this.iRemoveData.clear();
        DataManager.clearConfigs();
        this.lastLogout.clear();
        this.executionHistories.clear();
        this.playerMap.clear();
        if (this.foundInconsistencies > 0) {
            StaticLog.logWarning("DataMan found " + this.foundInconsistencies + " inconsistencies (warnings suppressed).");
            this.foundInconsistencies = 0;
        }
    }

    @Override
    public String getComponentName() {
        return "NoCheatPlus_DataManager";
    }

    @Override
    public void checkConsistency(Player[] onlinePlayers) {
        int missing = 0;
        int changed = 0;
        for (int i = 0; i < onlinePlayers.length; ++i) {
            Player player = onlinePlayers[i];
            UUID id = player.getUniqueId();
            if (!this.playerMap.hasPlayerInfo(id)) {
                ++missing;
            }
            if (!this.playerMap.storesPlayerInstances() || player == this.playerMap.getPlayer(id)) continue;
            ++changed;
            this.addOnlinePlayer(player);
        }
        int storedSize = this.playerMap.size();
        if (missing != 0 || changed != 0 || onlinePlayers.length != storedSize) {
            ++this.foundInconsistencies;
            if (!ConfigManager.getConfigFile().getBoolean("data.consistencychecks.suppresswarnings")) {
                LinkedList<String> details = new LinkedList<String>();
                if (missing != 0) {
                    details.add("missing online players (" + missing + ")");
                }
                if (onlinePlayers.length != storedSize) {
                    details.add("wrong number of online players (" + storedSize + " instead of " + onlinePlayers.length + ")");
                }
                if (changed != 0) {
                    details.add("changed player instances (" + changed + ")");
                }
                StaticLog.logWarning("DataMan inconsistencies: " + StringUtil.join(details, " | "));
            }
        }
    }

    public static PlayerData getPlayerData(Player player) {
        return DataManager.getPlayerData(player.getName(), true);
    }

    public static PlayerData getPlayerData(String playerName, boolean create) {
        String lcName = playerName.toLowerCase();
        PlayerData data = DataManager.instance.playerData.get(lcName);
        if (data != null) {
            return data;
        }
        if (!create) {
            return null;
        }
        PlayerData newData = new PlayerData(lcName);
        DataManager.instance.playerData.put(lcName, newData);
        return newData;
    }
}

