/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.spigotcb1_8_R2;

import fr.neatmonster.nocheatplus.utilities.BlockCache;
import java.util.List;
import net.minecraft.server.v1_8_R2.AxisAlignedBB;
import net.minecraft.server.v1_8_R2.Block;
import net.minecraft.server.v1_8_R2.BlockPosition;
import net.minecraft.server.v1_8_R2.EntityBoat;
import net.minecraft.server.v1_8_R2.EnumDirection;
import net.minecraft.server.v1_8_R2.IBlockAccess;
import net.minecraft.server.v1_8_R2.IBlockData;
import net.minecraft.server.v1_8_R2.TileEntity;
import net.minecraft.server.v1_8_R2.WorldServer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class BlockCacheSpigotCB1_8_R2
extends BlockCache
implements IBlockAccess {
    protected WorldServer world;
    protected World bukkitWorld;

    public BlockCacheSpigotCB1_8_R2(World world) {
        this.setAccess(world);
    }

    public void setAccess(World world) {
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
            this.world = ((CraftWorld)world).getHandle();
            this.bukkitWorld = world;
        } else {
            this.world = null;
            this.bukkitWorld = null;
        }
    }

    public int fetchTypeId(int x, int y, int z) {
        return this.bukkitWorld.getBlockTypeIdAt(x, y, z);
    }

    public int fetchData(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getData();
    }

    public double[] fetchBounds(int x, int y, int z) {
        int id = this.getTypeId(x, y, z);
        Block block = Block.getById((int)id);
        if (block == null) {
            return null;
        }
        block.updateShape((IBlockAccess)this, new BlockPosition(x, y, z));
        return new double[]{block.B(), block.D(), block.F(), block.C(), block.E(), block.G()};
    }

    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            net.minecraft.server.v1_8_R2.Entity mcEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            List list = this.world.getEntities(mcEntity, box);
            for (net.minecraft.server.v1_8_R2.Entity other : list) {
                if (!(other instanceof EntityBoat)) continue;
                if (minY >= other.locY && minY - other.locY <= 0.7) {
                    return true;
                }
                AxisAlignedBB otherBox = other.getBoundingBox();
                if (box.a > otherBox.d || box.d < otherBox.a || box.b > otherBox.e || box.e < otherBox.b || box.c > otherBox.f || box.f < otherBox.c) continue;
                return true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return false;
    }

    public void cleanup() {
        super.cleanup();
        this.world = null;
        this.bukkitWorld = null;
    }

    public int getBlockPower(BlockPosition pos, EnumDirection dir) {
        return this.world.getBlockPower(pos, dir);
    }

    public TileEntity getTileEntity(BlockPosition pos) {
        return this.world.getTileEntity(pos);
    }

    public IBlockData getType(BlockPosition pos) {
        return this.world.getType(pos);
    }

    public boolean isEmpty(BlockPosition pos) {
        return this.world.isEmpty(pos);
    }
}

