/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.BedLeave;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.moving.CreativeFly;
import fr.neatmonster.nocheatplus.checks.moving.MorePackets;
import fr.neatmonster.nocheatplus.checks.moving.MorePacketsVehicle;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.NoFall;
import fr.neatmonster.nocheatplus.checks.moving.Passable;
import fr.neatmonster.nocheatplus.checks.moving.SurvivalFly;
import fr.neatmonster.nocheatplus.checks.moving.locations.LocUtil;
import fr.neatmonster.nocheatplus.checks.moving.locations.MoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.locations.VehicleSetBack;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.checks.moving.velocity.AccountEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.components.IData;
import fr.neatmonster.nocheatplus.components.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.INeedConfig;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.IRemoveData;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.TickListener;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.logging.debug.DebugUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MovingListener
extends CheckListener
implements TickListener,
IRemoveData,
IHaveCheckType,
INotifyReload,
INeedConfig,
JoinLeaveListener {
    private final Plugin plugin = Bukkit.getPluginManager().getPlugin("NoCheatPlus");
    public final NoFall noFall = this.addCheck(new NoFall());
    private final CreativeFly creativeFly = this.addCheck(new CreativeFly());
    private final MorePackets morePackets = this.addCheck(new MorePackets());
    private final MorePacketsVehicle morePacketsVehicle = this.addCheck(new MorePacketsVehicle());
    private final SurvivalFly survivalFly = this.addCheck(new SurvivalFly());
    private final Passable passable = this.addCheck(new Passable());
    private final BedLeave bedLeave = this.addCheck(new BedLeave());
    private final List<MoveInfo> parkedInfo = new ArrayList<MoveInfo>(10);
    private final Map<String, PlayerMoveEvent> processingEvents = new HashMap<String, PlayerMoveEvent>();
    private final Set<String> hoverTicks = new LinkedHashSet<String>(30);
    private final Set<String> playersEnforce = new LinkedHashSet<String>(30);
    private int hoverTicksStep = 5;
    private final Set<EntityType> normalVehicles = new HashSet<EntityType>();
    final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idMoveHandled = this.counters.registerKey("event.player.move.handled");
    private final int idMoveHandledPos = this.counters.registerKey("event.player.move.handled.pos");
    private final int idMoveHandledLook = this.counters.registerKey("event.player.move.handled.look");
    private final int idMoveHandledPosAndLook = this.counters.registerKey("event.player.move.handled.pos_look");

    public MovingListener() {
        super(CheckType.MOVING);
    }

    private MoveInfo useMoveInfo() {
        if (this.parkedInfo.isEmpty()) {
            return new MoveInfo(this.mcAccess);
        }
        return this.parkedInfo.remove(this.parkedInfo.size() - 1);
    }

    private void returnMoveInfo(MoveInfo moveInfo) {
        moveInfo.cleanup();
        this.parkedInfo.add(moveInfo);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.isInsideVehicle()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        int blockY = block.getY();
        Material mat = block.getType();
        MovingData data = MovingData.getData(player);
        if (!MovingUtil.shouldCheckSurvivalFly(player, data, MovingConfig.getConfig(player))) {
            return;
        }
        if (!data.hasSetBack() || (double)blockY + 1.0 < data.getSetBackY()) {
            return;
        }
        Location loc = player.getLocation(this.useLoc);
        if (Math.abs(loc.getX() - 0.5 - (double)block.getX()) <= 1.0 && Math.abs(loc.getZ() - 0.5 - (double)block.getZ()) <= 1.0 && loc.getY() - (double)blockY > 0.0 && loc.getY() - (double)blockY < 2.0 && (MovingUtil.canJumpOffTop(mat) || BlockProperties.isLiquid(mat))) {
            data.setSetBackY((double)blockY + 1.0);
            data.sfJumpPhase = 0;
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        CombinedData.getData((Player)event.getPlayer()).wasInBed = true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        if (this.bedLeave.isEnabled(player) && this.bedLeave.checkBed(player)) {
            MovingConfig cc = MovingConfig.getConfig(player);
            Location loc = player.getLocation(this.useLoc);
            MovingData data = MovingData.getData(player);
            Location target = null;
            boolean sfCheck = MovingUtil.shouldCheckSurvivalFly(player, data, cc);
            if (sfCheck) {
                target = data.getSetBack(loc);
            }
            if (target == null) {
                target = LocUtil.clone(loc);
            }
            if (sfCheck && cc.sfSetBackPolicyFallDamage && this.noFall.isEnabled(player, cc)) {
                double y = loc.getY();
                if (data.hasSetBack()) {
                    y = Math.min(y, data.getSetBackY());
                }
                this.noFall.checkDamage(player, data, y);
            }
            this.useLoc.setWorld(null);
            data.prepareSetBack(target);
            player.teleport(target, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            CombinedData.getData((Player)player).wasInBed = false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        MovingConfig cc = MovingConfig.getConfig(player);
        data.clearFlyData();
        data.clearMorePacketsData();
        Location loc = player.getLocation(this.useLoc);
        data.setSetBack(loc);
        data.resetPositions(loc);
        data.resetTrace(loc, TickTask.getTick(), cc.traceSize, cc.traceMergeDist);
        if (cc.enforceLocation) {
            this.playersEnforce.add(player.getName());
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE || event.getNewGameMode() == GameMode.CREATIVE) {
            MovingData data = MovingData.getData(event.getPlayer());
            data.clearFlyData();
            data.clearMorePacketsData();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        boolean earlyReturn;
        Player player = event.getPlayer();
        this.processingEvents.put(player.getName(), event);
        MovingData data = MovingData.getData(player);
        Location from = event.getFrom();
        Location to = event.getTo();
        Location newTo = null;
        if (player.isInsideVehicle()) {
            newTo = this.onPlayerMoveVehicle(player, from, to, data);
            earlyReturn = true;
        } else if (player.isDead() || player.isSleeping()) {
            data.sfHoverTicks = -1;
            earlyReturn = true;
        } else if (player.isSleeping()) {
            data.sfHoverTicks = -1;
            earlyReturn = true;
        } else {
            earlyReturn = !from.getWorld().equals(to.getWorld());
        }
        if (earlyReturn) {
            if (newTo != null) {
                if (LocUtil.needsYawCorrection(newTo.getYaw())) {
                    newTo.setYaw(LocUtil.correctYaw(newTo.getYaw()));
                }
                if (LocUtil.needsPitchCorrection(newTo.getPitch())) {
                    newTo.setPitch(LocUtil.correctPitch(newTo.getPitch()));
                }
                event.setTo(newTo);
            }
            data.joinOrRespawn = false;
            return;
        }
        MovingConfig cc = MovingConfig.getConfig(player);
        MoveInfo moveInfo = this.useMoveInfo();
        Location loc = player.getLocation(moveInfo.useLoc);
        if (TrigUtil.isSamePos(from, loc) || TrigUtil.isSamePos(loc, data.fromX, data.fromY, data.fromZ)) {
            moveInfo.set(player, from, to, cc.yOnGround);
            this.checkPlayerMove(player, from, to, false, moveInfo, data, cc, event);
        } else {
            if (data.debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Split move 1 (from -> loc):");
            }
            moveInfo.set(player, from, loc, cc.yOnGround);
            if (!this.checkPlayerMove(player, from, loc, true, moveInfo, data, cc, event) && this.processingEvents.containsKey(player.getName())) {
                this.onMoveMonitorNotCancelled(player, from, loc, System.currentTimeMillis(), TickTask.getTick(), CombinedData.getData(player), data);
                data.joinOrRespawn = false;
                if (data.debug) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Split move 2 (loc -> to):");
                }
                moveInfo.set(player, loc, to, cc.yOnGround);
                this.checkPlayerMove(player, loc, to, false, moveInfo, data, cc, event);
            }
        }
        data.joinOrRespawn = false;
        this.returnMoveInfo(moveInfo);
    }

    private boolean checkPlayerMove(Player player, Location from, Location to, boolean mightBeMultipleMoves, MoveInfo moveInfo, MovingData data, MovingConfig cc, PlayerMoveEvent event) {
        boolean checkSf;
        boolean checkCf;
        Location newTo = null;
        data.noFallAssumeGround = false;
        data.resetTeleported();
        if (data.debug) {
            DebugUtil.outputMoveDebug(player, moveInfo.from, moveInfo.to, Math.max(cc.noFallyOnGround, cc.yOnGround), this.mcAccess);
        }
        if (moveInfo.from.hasIllegalCoords() || moveInfo.to.hasIllegalCoords() || !cc.ignoreStance && (moveInfo.from.hasIllegalStance() || moveInfo.to.hasIllegalStance())) {
            MovingUtil.handleIllegalMove(event, player, data, cc);
            return true;
        }
        boolean hasPos = !moveInfo.from.isSamePos(moveInfo.to);
        boolean hasLook = from.getYaw() != to.getYaw() || from.getPitch() != to.getPitch();
        this.counters.addPrimaryThread(this.idMoveHandled, 1);
        int counterId = hasPos && hasLook ? this.idMoveHandledPosAndLook : (hasPos ? this.idMoveHandledPos : (hasLook ? this.idMoveHandledLook : -1));
        if (counterId != -1) {
            this.counters.addPrimaryThread(counterId, 1);
        }
        String playerName = player.getName();
        if (cc.enforceLocation && this.playersEnforce.contains(playerName)) {
            newTo = this.enforceLocation(player, from, data);
            this.playersEnforce.remove(playerName);
        }
        long time = System.currentTimeMillis();
        if (player.isSprinting() || cc.assumeSprint) {
            if (player.getFoodLevel() > 5 || player.isFlying()) {
                data.timeSprinting = time;
                data.multSprinting = this.mcAccess.getSprintAttributeMultiplier(player);
                if (data.multSprinting == Double.MAX_VALUE) {
                    data.multSprinting = 1.30000002;
                } else if (cc.assumeSprint && data.multSprinting == 1.0) {
                    data.multSprinting = 1.30000002;
                }
            } else if (time < data.timeSprinting) {
                data.timeSprinting = 0L;
            }
        } else if (time < data.timeSprinting) {
            data.timeSprinting = 0L;
        }
        PlayerLocation pFrom = moveInfo.from;
        PlayerLocation pTo = moveInfo.to;
        if (data.wasInVehicle) {
            this.onVehicleLeaveMiss(player, data, cc);
        }
        moveInfo.data.set(pFrom, pTo);
        double jumpAmplifier = this.survivalFly.getJumpAmplifier(player);
        if (jumpAmplifier > data.jumpAmplifier) {
            data.jumpAmplifier = jumpAmplifier;
        }
        int tick = TickTask.getTick();
        data.velocityTick(tick - cc.velocityActivationTicks);
        if (MovingUtil.shouldCheckSurvivalFly(player, data, cc)) {
            checkCf = false;
            checkSf = true;
            data.adjustWalkSpeed(player.getWalkSpeed(), tick, cc.speedGrace);
        } else if (cc.creativeFlyCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_CREATIVEFLY) && !player.hasPermission("nocheatplus.checks.moving.creativefly")) {
            checkCf = true;
            checkSf = false;
            data.adjustFlySpeed(player.getFlySpeed(), tick, cc.speedGrace);
            data.adjustWalkSpeed(player.getWalkSpeed(), tick, cc.speedGrace);
        } else {
            checkSf = false;
            checkCf = false;
        }
        boolean checkNf = true;
        boolean verticalBounce = false;
        if (checkSf || checkCf) {
            if (to.getY() < from.getY()) {
                if ((BlockProperties.getBlockFlags(pTo.getTypeIdBelow()) & 0x400000L) != 0L && !this.survivalFly.isReallySneaking(player) && (to.getY() - (double)to.getBlockY() <= Math.max(cc.yOnGround, cc.noFallyOnGround) && MovingUtil.getRealisticFallDistance(player, pFrom.getY(), pTo.getY(), data) > 1.0 || to.getY() - (double)to.getBlockY() < 0.286 && to.getY() - from.getY() > -0.5 && to.getY() - from.getY() < -0.0624 && !pTo.isOnGround())) {
                    verticalBounce = true;
                    checkNf = false;
                }
            } else if (data.verticalBounce != null) {
                if (to.getY() > from.getY() || to.getY() == from.getY() && data.verticalBounce.value < 0.13) {
                    if (to.getY() == from.getY()) {
                        data.prependVerticalVelocity(new SimpleEntry(tick, 0.0, 1));
                        data.getOrUseVerticalVelocity(0.0);
                        if (data.lastYDist < 0.0) {
                            data.verticalBounce = new SimpleEntry(tick, data.verticalBounce.value, 1);
                        }
                    } else {
                        data.useVerticalBounce(player);
                    }
                    checkNf = false;
                } else {
                    data.verticalBounce = null;
                }
            }
        }
        boolean mightSkipNoFall = false;
        if (newTo == null && cc.passableCheck && player.getGameMode() != BridgeMisc.GAME_MODE_SPECTATOR && !NCPExemptionManager.isExempted(player, CheckType.MOVING_PASSABLE) && !player.hasPermission("nocheatplus.checks.moving.passable") && (newTo = this.passable.check(player, pFrom, pTo, data, cc)) != null) {
            mightSkipNoFall = true;
        }
        if (checkSf) {
            double maxYNoFall = Math.max(cc.noFallyOnGround, cc.yOnGround);
            pFrom.collectBlockFlags(maxYNoFall);
            boolean isSamePos = pFrom.isSamePos(pTo);
            if (isSamePos) {
                pTo.prepare(pFrom);
            } else {
                pTo.collectBlockFlags(maxYNoFall);
            }
            if (data.lastFlyCheck == CheckType.MOVING_CREATIVEFLY && data.lastHDist != Double.MAX_VALUE) {
                MovingListener.workaroundFlyNoFlyTransition(tick, data);
            }
            if (newTo == null) {
                newTo = this.survivalFly.check(player, pFrom, pTo, isSamePos, moveInfo.data, data, cc, time);
            }
            if (checkNf) {
                checkNf = this.noFall.isEnabled(player, cc);
            }
            if (newTo == null) {
                if (cc.sfHoverCheck && !data.toWasReset && !pTo.isOnGround()) {
                    this.hoverTicks.add(playerName);
                    data.sfHoverTicks = 0;
                } else {
                    data.sfHoverTicks = -1;
                }
                if (checkNf) {
                    this.noFall.check(player, pFrom, pTo, data, cc);
                }
            } else if (checkNf && cc.sfSetBackPolicyFallDamage) {
                if (this.noFall.estimateDamage(player, from.getY(), data) < 1.0) {
                    mightSkipNoFall = true;
                } else if (mightSkipNoFall && !pFrom.isOnGround() && !pFrom.isResetCond()) {
                    mightSkipNoFall = false;
                }
                if (!(mightSkipNoFall || pTo.isResetCond() && pFrom.isResetCond())) {
                    this.noFall.checkDamage(player, data, Math.min(from.getY(), to.getY()));
                }
            }
            data.lastFlyCheck = CheckType.MOVING_SURVIVALFLY;
        } else if (checkCf) {
            if (newTo == null) {
                newTo = this.creativeFly.check(player, pFrom, pTo, moveInfo.data, data, cc, time);
            }
            data.sfHoverTicks = -1;
            data.sfLowJump = false;
            data.lastFlyCheck = CheckType.MOVING_CREATIVEFLY;
        } else {
            data.clearFlyData();
        }
        if (newTo == null && cc.morePacketsCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_MOREPACKETS) && !player.hasPermission("nocheatplus.checks.moving.morepackets")) {
            newTo = this.morePackets.check(player, pFrom, pTo, data, cc);
        } else {
            data.clearMorePacketsData();
        }
        if ((checkSf || checkCf) && jumpAmplifier != data.jumpAmplifier && (data.noFallAssumeGround || pFrom.isOnGround() || pTo.isOnGround())) {
            data.jumpAmplifier = jumpAmplifier;
        }
        if (newTo == null) {
            if (verticalBounce) {
                this.processBounce(player, pFrom.getY(), pTo.getY(), data, cc);
            }
            data.setPositions(from, to);
            data.lastHDist = moveInfo.data.hDistance;
            data.lastYDist = moveInfo.data.yDistance;
            return false;
        }
        this.onSetBack(player, event, newTo, data, cc);
        return true;
    }

    private static void workaroundFlyNoFlyTransition(int tick, MovingData data) {
        double amount = data.lastHDist * 0.98;
        data.addHorizontalVelocity(new AccountEntry(tick, amount, 1, MovingData.getHorVelValCount(amount)));
        data.addVerticalVelocity(new SimpleEntry(data.lastYDist, 2));
        data.addVerticalVelocity(new SimpleEntry(0.0, 2));
        data.setFrictionJumpPhase();
    }

    private void processBounce(Player player, double fromY, double toY, MovingData data, MovingConfig cc) {
        double max_gain;
        double fallDistance = MovingUtil.getRealisticFallDistance(player, fromY, toY, data);
        double base = Math.sqrt(fallDistance) / 3.3;
        double effect = Math.min(3.5, base + Math.min(base / 10.0, 0.0834));
        if (effect > 0.42 && (max_gain = Math.abs(data.lastYDist < 0.0 ? Math.min(data.lastYDist, toY - fromY) : toY - fromY) - 0.021000000000000005) < effect) {
            effect = max_gain;
            if (data.debug) {
                DebugUtil.debug(player.getName() + " Cap bounce effect by recent y-distances.");
            }
        }
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Bounce effect (dY=" + fallDistance + "): " + effect);
        }
        data.noFallSkipAirCheck = true;
        data.verticalBounce = new SimpleEntry(effect, 1);
    }

    private void onSetBack(Player player, PlayerMoveEvent event, Location newTo, MovingData data, MovingConfig cc) {
        if (LocUtil.needsYawCorrection(newTo.getYaw())) {
            newTo.setYaw(LocUtil.correctYaw(newTo.getYaw()));
        }
        if (LocUtil.needsPitchCorrection(newTo.getPitch())) {
            newTo.setPitch(LocUtil.correctPitch(newTo.getPitch()));
        }
        data.prepareSetBack(newTo);
        data.resetPositions(newTo);
        this.adjustLiftOffEnvelope(player, newTo, data, cc);
        event.setTo(newTo);
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " set back to: " + newTo.getWorld() + StringUtil.fdec3.format(newTo.getX()) + ", " + StringUtil.fdec3.format(newTo.getY()) + ", " + StringUtil.fdec3.format(newTo.getZ()));
        }
    }

    private Location onPlayerMoveVehicle(Player player, Location from, Location to, MovingData data) {
        Entity vehicle = CheckUtils.getLastNonPlayerVehicle((Entity)player);
        data.wasInVehicle = true;
        data.sfHoverTicks = -1;
        data.removeAllVelocity();
        data.sfLowJump = false;
        if (vehicle != null) {
            Location vLoc = vehicle.getLocation();
            if (!this.normalVehicles.contains(vehicle.getType())) {
                this.onVehicleMove(vehicle, vLoc, vLoc, true);
                return null;
            }
            data.vehicleConsistency = MoveConsistency.getConsistency(from, to, vLoc);
            if (data.vehicleConsistency == MoveConsistency.INCONSISTENT) {
                if (MovingConfig.getConfig((Player)player).vehicleEnforceLocation) {
                    return vLoc;
                }
                return null;
            }
            data.resetPositions(vLoc);
            return null;
        }
        return null;
    }

    private void onVehicleLeaveMiss(Player player, MovingData data, MovingConfig cc) {
        if (data.debug) {
            StaticLog.logWarning("VehicleExitEvent missing for: " + player.getName());
        }
        this.onPlayerVehicleLeave(player, null);
        data.noFallSkipAirCheck = true;
        data.sfLowJump = false;
        data.clearNoFallData();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerMoveMonitor(PlayerMoveEvent event) {
        long now = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (this.processingEvents.remove(player.getName()) == null) {
            return;
        }
        if (player.isDead() || player.isSleeping()) {
            return;
        }
        CombinedData data = CombinedData.getData(player);
        Location from = event.getFrom();
        MovingData mData = MovingData.getData(player);
        long tick = TickTask.getTick();
        if (!event.isCancelled()) {
            Location pLoc = player.getLocation(this.useLoc);
            this.onMoveMonitorNotCancelled(player, TrigUtil.isSamePosAndLook(pLoc, from) ? from : pLoc, event.getTo(), now, tick, data, mData);
            this.useLoc.setWorld(null);
        } else {
            data.lastMoveTime = now;
            Combined.feedYawRate(player, from.getYaw(), now, from.getWorld().getName(), data);
            mData.resetPositions(from);
            mData.resetTrace(player, from, tick);
        }
    }

    private void onMoveMonitorNotCancelled(Player player, Location from, Location to, long now, long tick, CombinedData data, MovingData mData) {
        data.lastMoveTime = now;
        String toWorldName = to.getWorld().getName();
        Combined.feedYawRate(player, to.getYaw(), now, toWorldName, data);
        if (player.isInsideVehicle()) {
            Location ref = player.getVehicle().getLocation(this.useLoc);
            mData.resetPositions(ref);
            this.useLoc.setWorld(null);
            mData.updateTrace(player, to, tick);
        } else if (!from.getWorld().getName().equals(toWorldName)) {
            mData.resetPositions(to);
            mData.resetTrace(player, to, tick);
        } else {
            mData.setTo(to);
            mData.updateTrace(player, to, tick);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        MovingData data = MovingData.getData(event.getPlayer());
        data.clearFlyData();
        data.clearMorePacketsData();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        MovingData data = MovingData.getData(player);
        data.clearFlyData();
        data.clearMorePacketsData();
        data.setSetBack(player.getLocation(this.useLoc));
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " death: " + player.getLocation(this.useLoc));
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Location ref;
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        Location teleported = data.getTeleported();
        data.joinOrRespawn = false;
        Location to = event.getTo();
        MovingConfig cc = MovingConfig.getConfig(player);
        if (teleported != null && teleported.equals((Object)to)) {
            if (event.isCancelled()) {
                event.setCancelled(false);
                event.setTo(teleported);
                event.setFrom(teleported);
                ref = teleported;
            } else {
                ref = to;
            }
            data.onSetBack(teleported);
            this.adjustLiftOffEnvelope(player, teleported, data, cc);
        } else if (to != null && !event.isCancelled()) {
            Location newTo;
            boolean smallRange = false;
            boolean cancel = false;
            double margin = 0.67;
            Location from = event.getFrom();
            PlayerTeleportEvent.TeleportCause cause = event.getCause();
            if (cause == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
                if (from != null && from.getWorld().equals(to.getWorld())) {
                    if (TrigUtil.distance(from, to) < 0.67) {
                        smallRange = true;
                    } else if (data.toX != Double.MAX_VALUE && data.hasSetBack()) {
                        Location setBack = data.getSetBack(to);
                        if (TrigUtil.distance(to.getX(), to.getY(), to.getZ(), setBack.getX(), setBack.getY(), setBack.getZ()) < 0.67) {
                            smallRange = true;
                        }
                    }
                    if (smallRange && BlockProperties.isOnGroundOrResetCond(player, to, cc.yOnGround) && BlockProperties.isPassable(to)) {
                        smallRange = false;
                    }
                }
            } else if (cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                if (CombinedConfig.getConfig((Player)player).enderPearlCheck && !BlockProperties.isPassable(to)) {
                    cancel = true;
                }
            } else if (cause == PlayerTeleportEvent.TeleportCause.COMMAND && cc.passableUntrackedTeleportCheck && MovingUtil.shouldCheckUntrackedLocation(player, to) && (newTo = MovingUtil.checkUntrackedLocation(to)) != null) {
                to = newTo;
                event.setTo(newTo);
                smallRange = false;
                cancel = false;
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, player.getName() + " correct untracked teleport destination (" + to + " corrected to " + newTo + ").");
            }
            if (cancel) {
                if (data.hasSetBack() && !data.hasSetBackWorldChanged(to)) {
                    ref = data.getSetBack(to);
                    event.setTo(ref);
                    this.adjustLiftOffEnvelope(player, ref, data, cc);
                } else {
                    ref = from;
                    event.setCancelled(true);
                }
            } else if (smallRange) {
                ref = to;
            } else {
                ref = to;
                double fallDistance = data.noFallFallDistance;
                LiftOffEnvelope oldEnv = data.liftOffEnvelope;
                data.clearMorePacketsData();
                data.clearFlyData();
                data.resetPositions(to);
                if (TrigUtil.maxDistance(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ()) <= 12.0) {
                    data.liftOffEnvelope = oldEnv;
                }
                data.setSetBack(to);
                this.adjustLiftOffEnvelope(player, to, data, cc);
                if (fallDistance > 1.0 && fallDistance - (double)player.getFallDistance() > 0.0 && !cc.noFallTpReset) {
                    player.setFallDistance((float)fallDistance);
                }
                if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                    data.noFallSkipAirCheck = true;
                }
                data.sfHoverTicks = -1;
            }
            if (data.debug && BuildParameters.debugLevel > 0) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " TP" + (smallRange ? " (small-range)" : "") + (cancel ? " (cancelled)" : "") + ": " + to);
            }
        } else {
            data.resetTeleported();
            if (data.debug && BuildParameters.debugLevel > 0) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " TP (cancelled): " + to);
            }
            return;
        }
        Combined.resetYawRate(player, ref.getYaw(), System.currentTimeMillis(), true);
        data.resetTeleported();
        data.resetLastDistances();
        this.processingEvents.remove(player.getName());
    }

    private void adjustLiftOffEnvelope(Player player, Location loc, MovingData data, MovingConfig cc) {
        MoveInfo info = this.useMoveInfo();
        info.set(player, loc, null, cc.yOnGround);
        data.adjustMediumProperties(info.from);
        this.returnMoveInfo(info);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        if (player.isInsideVehicle()) {
            data.removeAllVelocity();
            return;
        }
        Vector velocity = event.getVelocity();
        MovingConfig cc = MovingConfig.getConfig(player);
        data.addVelocity(player, cc, velocity.getX(), velocity.getY(), velocity.getZ());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        EntityType entityType = vehicle.getType();
        if (!this.normalVehicles.contains(entityType)) {
            this.normalVehicles.add(entityType);
            if (MovingConfig.getConfig((String)vehicle.getWorld().getName()).debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, "VehicleMoveEvent fired for: " + entityType);
            }
        }
        if (vehicle.getVehicle() != null) {
            return;
        }
        this.onVehicleMove((Entity)vehicle, event.getFrom(), event.getTo(), false);
    }

    public void onVehicleMove(Entity vehicle, Location from, Location to, boolean fake) {
        Player player = CheckUtils.getFirstPlayerPassenger(vehicle);
        if (player == null) {
            return;
        }
        if (vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, vehicle);
            return;
        }
        if (!from.getWorld().equals(to.getWorld())) {
            return;
        }
        MovingData data = MovingData.getData(player);
        data.joinOrRespawn = false;
        data.vehicleConsistency = MoveConsistency.getConsistency(from, to, player.getLocation(this.useLoc));
        switch (data.vehicleConsistency) {
            case FROM: 
            case TO: {
                data.resetPositions(player.getLocation(this.useLoc));
                break;
            }
        }
        Location newTo = null;
        data.sfNoLowJump = true;
        MovingConfig cc = MovingConfig.getConfig(player);
        if (cc.noFallVehicleReset) {
            data.noFallSkipAirCheck = true;
            data.sfLowJump = false;
            data.clearNoFallData();
        }
        if (data.debug) {
            DebugUtil.outputDebugVehicleMove(player, vehicle, from, to, fake);
        }
        if (this.morePacketsVehicle.isEnabled(player, data, cc)) {
            newTo = this.morePacketsVehicle.check(player, from, to, data, cc);
        } else {
            data.clearMorePacketsData();
        }
        if (newTo != null && data.morePacketsVehicleTaskId == -1) {
            data.morePacketsVehicleTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)new VehicleSetBack(vehicle, player, newTo, data.debug));
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onEntityDamage(EntityDamageEvent event) {
        double maxD;
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MovingData data = MovingData.getData(player);
        if (player.isInsideVehicle()) {
            data.clearNoFallData();
            return;
        }
        MovingConfig cc = MovingConfig.getConfig(player);
        if (event.isCancelled() || !MovingUtil.shouldCheckSurvivalFly(player, data, cc) || !this.noFall.isEnabled(player, cc)) {
            data.clearNoFallData();
            return;
        }
        Location loc = player.getLocation(this.useLoc);
        boolean allowReset = true;
        if (!data.noFallSkipAirCheck) {
            MoveInfo moveInfo = this.useMoveInfo();
            moveInfo.set(player, loc, null, cc.noFallyOnGround);
            PlayerLocation pLoc = moveInfo.from;
            moveInfo.from.collectBlockFlags(cc.noFallyOnGround);
            data.noFallFallDistance = (float)((double)data.noFallFallDistance + 1.0);
            if (!(pLoc.isOnGround(1.0, 0.3, 0.1) || pLoc.isResetCond() || pLoc.isAboveLadder() || pLoc.isAboveStairs())) {
                data.noFallVL += 1.0;
                if (this.noFall.executeActions(player, data.noFallVL, 1.0, cc.noFallActions) && data.hasSetBack()) {
                    allowReset = false;
                }
            } else {
                data.vDistAcc.clear();
            }
            this.returnMoveInfo(moveInfo);
        }
        float fallDistance = player.getFallDistance();
        double damage = BridgeHealth.getDamage(event);
        float yDiff = (float)(data.noFallMaxY - loc.getY());
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " damage(FALL): " + damage + " / dist=" + player.getFallDistance() + " nf=" + data.noFallFallDistance + " yDiff=" + yDiff);
        }
        if ((maxD = NoFall.getDamage(Math.max(yDiff, Math.max(data.noFallFallDistance, fallDistance))) + (allowReset ? 0.0 : 3.0)) > damage) {
            BridgeHealth.setDamage(event, maxD);
            if (data.debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Adjust fall damage to: " + maxD);
            }
        }
        if (allowReset) {
            data.clearNoFallData();
        } else {
            if (cc.noFallViolationReset) {
                data.clearNoFallData();
            }
            if (cc.sfHoverCheck && data.sfHoverTicks < 0) {
                data.sfHoverTicks = 0;
                this.hoverTicks.add(player.getName());
            }
        }
        this.useLoc.setWorld(null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        data.clearFlyData();
        data.resetSetBack();
        this.dataOnJoin(player, event.getRespawnLocation(), data, MovingConfig.getConfig(player), true);
    }

    public void playerJoins(Player player) {
        this.dataOnJoin(player, player.getLocation(this.useLoc), MovingData.getData(player), MovingConfig.getConfig(player), false);
        this.useLoc.setWorld(null);
    }

    private void dataOnJoin(Player player, Location loc, MovingData data, MovingConfig cc, boolean isRespawn) {
        int loaded;
        String tag;
        int tick = TickTask.getTick();
        String string = tag = isRespawn ? "respawn" : "join";
        if (cc.loadChunksOnJoin && (loaded = BlockCache.ensureChunksLoaded(loc.getWorld(), loc.getX(), loc.getZ(), 3.0)) > 0 && data.debug && BuildParameters.debugLevel > 0) {
            StaticLog.logInfo("Player " + tag + ": Loaded " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " for player: " + player.getName());
        }
        if (!data.hasSetBack() || data.hasSetBackWorldChanged(loc)) {
            data.clearFlyData();
            data.setSetBack(loc);
            data.resetPositions(loc);
            data.joinOrRespawn = true;
        } else {
            data.resetPositions(loc);
        }
        data.resetLastDistances();
        data.clearMorePacketsData();
        data.removeAllVelocity();
        data.resetTrace(loc, tick, cc.traceSize, cc.traceMergeDist);
        data.vDistAcc.clear();
        MoveInfo moveInfo = this.useMoveInfo();
        moveInfo.set(player, loc, null, cc.yOnGround);
        data.toWasReset = moveInfo.from.isOnGroundOrResetCond();
        data.adjustMediumProperties(moveInfo.from);
        this.returnMoveInfo(moveInfo);
        data.fromWasReset = data.toWasReset;
        if (cc.enforceLocation) {
            this.playersEnforce.add(player.getName());
        }
        this.initHover(player, data, cc, data.toWasReset);
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " " + tag + ": " + loc);
        }
    }

    private void initHover(Player player, MovingData data, MovingConfig cc, boolean isOnGroundOrResetCond) {
        if (!isOnGroundOrResetCond && cc.sfHoverCheck) {
            data.sfHoverTicks = 0;
            data.sfHoverLoginTicks = cc.sfHoverLoginTicks;
            this.hoverTicks.add(player.getName());
        } else {
            data.sfHoverLoginTicks = 0;
            data.sfHoverTicks = -1;
        }
    }

    public void playerLeaves(Player player) {
        Location refLoc;
        double d;
        MovingData data = MovingData.getData(player);
        Location loc = player.getLocation(this.useLoc);
        if (data.debug) {
            StaticLog.logInfo("Player " + player.getName() + " leaves at location: " + loc.toString());
        }
        if (!player.isSleeping() && !player.isDead() && !BlockProperties.isPassable(loc) && data.toX != Double.MAX_VALUE && (d = (refLoc = new Location(loc.getWorld(), data.toX, data.toY, data.toZ)).distanceSquared(loc)) > 0.0 && (TrigUtil.manhattan(loc, refLoc) > 0 || BlockProperties.isPassable(refLoc)) && this.passable.isEnabled(player)) {
            StaticLog.logWarning("Potential exploit: Player " + player.getName() + " leaves, having moved into a block (not tracked by moving checks): " + player.getWorld().getName() + " / " + DebugUtil.formatMove(refLoc, loc));
            if (d > 1.25) {
                StaticLog.logWarning("SKIP set-back for " + player.getName() + ", because distance is too high (risk of false positives): " + d);
            } else {
                StaticLog.logInfo("Set back player " + player.getName() + ": " + DebugUtil.formatLocation(refLoc));
                data.prepareSetBack(refLoc);
                if (!player.teleport(refLoc)) {
                    StaticLog.logWarning("FAILED to set back player " + player.getName());
                }
            }
        }
        this.useLoc.setWorld(null);
        this.survivalFly.setReallySneaking(player, false);
        this.noFall.onLeave(player);
        data.onPlayerLeave();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldunload(WorldUnloadEvent event) {
        MovingData.onWorldUnload(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleExit(VehicleExitEvent event) {
        LivingEntity entity = event.getExited();
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPlayerVehicleLeave((Player)entity, (Entity)event.getVehicle());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVehicleDestroyLowest(VehicleDestroyEvent event) {
        MovingConfig cc;
        Player player;
        Entity attacker = event.getAttacker();
        if (attacker instanceof Player && attacker.equals(event.getVehicle().getPassenger()) && (this.survivalFly.isEnabled(player = (Player)attacker, cc = MovingConfig.getConfig(player)) || this.creativeFly.isEnabled(player, cc)) && cc.vehiclePreventDestroyOwn) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.DARK_RED + "Destroying your own vehicle is disabled.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Entity entity = event.getVehicle().getPassenger();
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPlayerVehicleLeave((Player)entity, (Entity)event.getVehicle());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MovingData data = MovingData.getData(player);
        data.joinOrRespawn = false;
        data.removeAllVelocity();
        data.vehicleConsistency = MoveConsistency.getConsistency(event.getVehicle().getLocation(), null, player.getLocation(this.useLoc));
        this.useLoc.setWorld(null);
    }

    private void onPlayerVehicleLeave(Player player, Entity vehicle) {
        Location pLoc;
        MovingData data = MovingData.getData(player);
        data.wasInVehicle = false;
        data.joinOrRespawn = false;
        MovingConfig cc = MovingConfig.getConfig(player);
        Location loc = pLoc = player.getLocation(this.useLoc);
        if (vehicle != null) {
            Location vLoc = vehicle.getLocation();
            if (!this.normalVehicles.contains(vehicle.getType()) || cc.noFallVehicleReset) {
                data.noFallSkipAirCheck = true;
                data.clearNoFallData();
            }
            if (MoveConsistency.getConsistency(vLoc, null, pLoc) == MoveConsistency.INCONSISTENT) {
                loc = vLoc;
                if (data.vehicleConsistency != MoveConsistency.INCONSISTENT) {
                    Location oldLoc = new Location(pLoc.getWorld(), data.toX, data.toY, data.toZ);
                    if (data.toX != Double.MAX_VALUE && MoveConsistency.getConsistency(oldLoc, null, pLoc) != MoveConsistency.INCONSISTENT) {
                        loc = oldLoc;
                    }
                }
            }
            if (data.debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " vehicle leave: " + vehicle.getType() + "@" + pLoc.distance(vLoc));
            }
        }
        if (BlockProperties.isLiquid(loc.getBlock().getType())) {
            loc.setY((double)Location.locToBlock((double)loc.getY()) + 1.25);
        }
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " vehicle leave: " + pLoc.toString() + (pLoc.equals((Object)loc) ? "" : " / player at: " + pLoc.toString()));
        }
        data.resetPositions(loc);
        data.setSetBack(loc);
        data.removeAllVelocity();
        data.addHorizontalVelocity(new AccountEntry(0.9, 1, 1));
        data.addVerticalVelocity(new SimpleEntry(0.6, 1));
        this.useLoc.setWorld(null);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.survivalFly.setReallySneaking(event.getPlayer(), event.isSneaking());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        if (!event.isSprinting()) {
            MovingData.getData((Player)event.getPlayer()).timeSprinting = 0L;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        MovingConfig cc;
        Player player = event.getPlayer();
        if (player.isFlying() || event.isFlying() && !event.isCancelled()) {
            return;
        }
        MovingData data = MovingData.getData(player);
        if (!MovingUtil.shouldCheckSurvivalFly(player, data, cc = MovingConfig.getConfig(player)) || data.isVelocityJumpPhase() || BlockProperties.isOnGroundOrResetCond(player, player.getLocation(this.useLoc), cc.yOnGround)) {
            this.useLoc.setWorld(null);
            return;
        }
        this.useLoc.setWorld(null);
        data.addVelocity(player, cc, 0.0, 0.3, 0.0);
    }

    public void onTick(int tick, long timeLast) {
        ArrayList<String> rem = new ArrayList<String>(this.hoverTicks.size());
        for (String playerName : this.playersEnforce) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) continue;
            MovingData data = MovingData.getData(player);
            Location newTo = this.enforceLocation(player, player.getLocation(this.useLoc), data);
            if (newTo == null) continue;
            data.prepareSetBack(newTo);
            player.teleport(newTo, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
        if (!rem.isEmpty()) {
            this.playersEnforce.removeAll(rem);
        }
        rem.clear();
        if (tick % this.hoverTicksStep != 0) {
            return;
        }
        MoveInfo info = this.useMoveInfo();
        for (String playerName : this.hoverTicks) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            MovingData data = MovingData.getData(player);
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) {
                data.sfHoverTicks = -1;
            }
            if (data.sfHoverTicks < 0) {
                data.sfHoverLoginTicks = 0;
                rem.add(playerName);
                continue;
            }
            if (data.sfHoverLoginTicks > 0) {
                --data.sfHoverLoginTicks;
                continue;
            }
            MovingConfig cc = MovingConfig.getConfig(player);
            if (!cc.sfHoverCheck) {
                rem.add(playerName);
                data.sfHoverTicks = -1;
                continue;
            }
            data.sfHoverTicks += this.hoverTicksStep;
            if (data.sfHoverTicks < cc.sfHoverTicks || !this.checkHover(player, data, cc, info)) continue;
            rem.add(playerName);
        }
        this.hoverTicks.removeAll(rem);
        rem.clear();
        this.returnMoveInfo(info);
        this.useLoc.setWorld(null);
    }

    private Location enforceLocation(Player player, Location loc, MovingData data) {
        if (data.toX != Double.MAX_VALUE && TrigUtil.distanceSquared(data.toX, data.toY, data.toZ, loc.getX(), loc.getY(), loc.getZ()) > 0.00390625) {
            if (data.hasSetBack()) {
                return data.getSetBack(loc);
            }
            return new Location(player.getWorld(), data.toX, data.toY, data.toZ, loc.getYaw(), loc.getPitch());
        }
        return null;
    }

    private boolean checkHover(Player player, MovingData data, MovingConfig cc, MoveInfo info) {
        boolean res;
        Location loc = player.getLocation(this.useLoc);
        info.set(player, loc, null, cc.yOnGround);
        int loaded = info.from.ensureChunksLoaded();
        if (loaded > 0 && data.debug && BuildParameters.debugLevel > 0) {
            StaticLog.logInfo("Hover check: Needed to load " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " around " + loc.getBlockX() + "," + loc.getBlockZ() + " in order to check player: " + player.getName());
        }
        if (info.from.isOnGroundOrResetCond() || info.from.isAboveLadder() || info.from.isAboveStairs()) {
            res = true;
            data.sfHoverTicks = 0;
        } else if (data.sfHoverTicks > cc.sfHoverTicks) {
            if (MovingUtil.shouldCheckSurvivalFly(player, data, cc)) {
                this.handleHoverViolation(player, loc, cc, data);
                res = false;
                data.sfHoverTicks = 0;
            } else {
                res = false;
                data.sfHoverTicks = 0;
            }
        } else {
            res = false;
        }
        info.cleanup();
        return res;
    }

    private void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        if (cc.sfHoverFallDamage && this.noFall.isEnabled(player, cc)) {
            this.noFall.checkDamage(player, data, loc.getY());
        }
        this.survivalFly.handleHoverViolation(player, loc, cc, data);
    }

    public CheckType getCheckType() {
        return CheckType.MOVING_SURVIVALFLY;
    }

    public IData removeData(String playerName) {
        this.hoverTicks.remove(playerName);
        this.playersEnforce.remove(playerName);
        return null;
    }

    public void removeAllData() {
        this.hoverTicks.clear();
        this.playersEnforce.clear();
        this.parkedInfo.clear();
    }

    public void onReload() {
        for (MoveInfo info : this.parkedInfo) {
            info.cleanup();
        }
        this.parkedInfo.clear();
        this.hoverTicksStep = Math.max(1, ConfigManager.getConfigFile().getInt("checks.moving.survivalfly.hover.step"));
        MovingData.onReload();
    }
}

