/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.inventory.Drop;
import fr.neatmonster.nocheatplus.checks.inventory.FastClick;
import fr.neatmonster.nocheatplus.checks.inventory.InstantBow;
import fr.neatmonster.nocheatplus.checks.inventory.InstantEat;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.inventory.Items;
import fr.neatmonster.nocheatplus.checks.inventory.Open;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.InventoryUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryListener
extends CheckListener
implements JoinLeaveListener {
    private final Drop drop = this.addCheck(new Drop());
    private final FastClick fastClick = this.addCheck(new FastClick());
    private final InstantBow instantBow = this.addCheck(new InstantBow());
    private final InstantEat instantEat = this.addCheck(new InstantEat());
    protected final Items items = this.addCheck(new Items());
    private final Open open = this.addCheck(new Open());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("canceldead");
    private final int idIllegalItem = this.counters.registerKey("illegalitem");
    private final int idEggOnEntity = this.counters.registerKey("eggonentity");

    public InventoryListener() {
        super(CheckType.INVENTORY);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityShootBow(EntityShootBowEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.instantBow.isEnabled(player = (Player)event.getEntity())) {
            long now = System.currentTimeMillis();
            Location loc = player.getLocation(this.useLoc);
            if (Combined.checkYawRate(player, loc.getYaw(), now, loc.getWorld().getName())) {
                event.setCancelled(true);
            }
            if (this.instantBow.check(player, event.getForce(), now)) {
                event.setCancelled(true);
            } else if (Improbable.check(player, 0.6f, now, "inventory.instantbow")) {
                event.setCancelled(true);
            }
            this.useLoc.setWorld(null);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.instantEat.isEnabled(player) && this.instantEat.check(player, event.getFoodLevel())) {
                event.setCancelled(true);
            } else if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
                event.setCancelled(true);
                this.counters.addPrimaryThread(this.idCancelDead, 1);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            long now = System.currentTimeMillis();
            HumanEntity entity = event.getWhoClicked();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            int slot = event.getSlot();
            if (slot == -999 || slot < 0) {
                InventoryData.getData((Player)player).lastClickTime = now;
                return;
            }
            ItemStack cursor = event.getCursor();
            ItemStack clicked = event.getCurrentItem();
            boolean cancel = false;
            try {
                if (!cancel && Items.checkIllegalEnchantments(player, clicked)) {
                    cancel = true;
                    this.counters.addPrimaryThread(this.idIllegalItem, 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                if (!cancel && Items.checkIllegalEnchantments(player, cursor)) {
                    cancel = true;
                    this.counters.addPrimaryThread(this.idIllegalItem, 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            InventoryData data = InventoryData.getData(player);
            if (this.fastClick.isEnabled(player)) {
                InventoryConfig cc = InventoryConfig.getConfig(player);
                if (player.getGameMode() != GameMode.CREATIVE || !cc.fastClickSpareCreative) {
                    if (this.fastClick.check(player, now, event.getView(), slot, cursor, clicked, event.isShiftClick(), data, cc)) {
                        cancel = true;
                    }
                    Improbable.feed(player, 0.7f, System.currentTimeMillis());
                }
            }
            data.lastClickTime = now;
            if (cancel) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    protected void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItemDrop();
        if (item != null) {
            Items.checkIllegalEnchantments(player, item.getItemStack());
        }
        if (event.getPlayer().isDead()) {
            return;
        }
        if (this.drop.isEnabled(event.getPlayer()) && this.drop.check(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public final void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        InventoryData data = InventoryData.getData(player);
        boolean resetAll = false;
        if (event.hasItem()) {
            ItemStack item = event.getItem();
            Material type = item.getType();
            if (type == Material.BOW) {
                long now = System.currentTimeMillis();
                data.instantBowInteract = data.instantBowInteract > 0L && now - data.instantBowInteract < 800L ? Math.min(System.currentTimeMillis(), data.instantBowInteract) : System.currentTimeMillis();
            } else if (type.isEdible() || type == Material.POTION || type == Material.MILK_BUCKET) {
                long now = System.currentTimeMillis();
                data.instantEatFood = type;
                data.instantEatInteract = data.instantEatInteract > 0L && now - data.instantEatInteract < 800L ? Math.min(System.currentTimeMillis(), data.instantEatInteract) : System.currentTimeMillis();
                data.instantBowInteract = 0L;
            } else {
                resetAll = true;
            }
            if (Items.checkIllegalEnchantments(player, item)) {
                event.setCancelled(true);
                this.counters.addPrimaryThread(this.idIllegalItem, 1);
            }
        } else {
            resetAll = true;
        }
        if (resetAll) {
            data.instantBowInteract = 0L;
            data.instantEatInteract = 0L;
            data.instantEatFood = null;
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public final void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        ItemStack stack = player.getItemInHand();
        Entity entity = event.getRightClicked();
        if (stack != null && stack.getType() == Material.MONSTER_EGG && (entity == null || entity instanceof LivingEntity || entity instanceof ComplexEntityPart) && this.items.isEnabled(player)) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idEggOnEntity, 1);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        InventoryData data = InventoryData.getData(player);
        data.instantBowInteract = 0L;
        data.instantEatInteract = 0L;
        data.instantEatFood = null;
        PlayerInventory inv = player.getInventory();
        Items.checkIllegalEnchantments(player, inv.getItem(event.getNewSlot()));
        Items.checkIllegalEnchantments(player, inv.getItem(event.getPreviousSlot()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.open.check(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        this.open.check(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityPortal(EntityPortalEnterEvent event) {
        Player player = InventoryUtil.getPlayerPassengerRecursively(event.getEntity());
        if (player != null) {
            this.open.check(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.open.check(event.getPlayer());
    }

    public void playerJoins(Player player) {
    }

    public void playerLeaves(Player player) {
        this.open.check(player);
    }
}

