/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    public static int getFreeSlots(Inventory inventory) {
        ItemStack[] contents = inventory.getContents();
        int count = 0;
        for (int i = 0; i < contents.length; ++i) {
            if (!BlockProperties.isAir(contents[i])) continue;
            ++count;
        }
        return count;
    }

    public static int getStackCount(Inventory inventory, ItemStack reference) {
        if (inventory == null) {
            return 0;
        }
        if (reference == null) {
            return InventoryUtil.getFreeSlots(inventory);
        }
        Material mat = reference.getType();
        short durability = reference.getDurability();
        ItemStack[] contents = inventory.getContents();
        int count = 0;
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != mat || stack.getDurability() != durability) continue;
            ++count;
        }
        return count;
    }

    public static int getStackCount(InventoryView view, ItemStack reference) {
        return InventoryUtil.getStackCount(view.getBottomInventory(), reference) + InventoryUtil.getStackCount(view.getTopInventory(), reference);
    }

    public static boolean closePlayerInventoryRecursively(Entity entity) {
        Player player = InventoryUtil.getPlayerPassengerRecursively(entity);
        return player != null && InventoryUtil.closeOpenInventory((Player)entity);
    }

    public static Player getPlayerPassengerRecursively(Entity entity) {
        while (entity != null) {
            if (entity instanceof Player) {
                return (Player)entity;
            }
            Entity passenger = entity.getPassenger();
            if (entity.equals(passenger)) break;
            entity = passenger;
        }
        return null;
    }

    public static boolean closeOpenInventory(Player player) {
        if (InventoryUtil.hasInventoryOpen(player)) {
            player.closeInventory();
            return true;
        }
        return true;
    }

    public static boolean hasInventoryOpen(Player player) {
        InventoryView view = player.getOpenInventory();
        return view != null && view.getType() != InventoryType.CRAFTING;
    }
}

