/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.hooks;

import fr.neatmonster.nocheatplus.checks.CheckType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIUtils {
    private static final Map<CheckType, CheckType[]> childrenMap = new HashMap<CheckType, CheckType[]>();
    private static final Map<CheckType, CheckType[]> withChildrenMap = new HashMap<CheckType, CheckType[]>();
    private static final Set<CheckType> needSync = new HashSet<CheckType>();

    public static final Collection<CheckType> getChildren(CheckType type) {
        return Arrays.asList((Object[])childrenMap.get((Object)type));
    }

    public static final Collection<CheckType> getWithChildren(CheckType type) {
        return Arrays.asList((Object[])withChildrenMap.get((Object)type));
    }

    public static final boolean isParent(CheckType supposedParent, CheckType supposedChild) {
        if (supposedParent == supposedChild) {
            return false;
        }
        if (supposedParent == CheckType.ALL) {
            return true;
        }
        for (CheckType parent = supposedChild.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != supposedParent) continue;
            return true;
        }
        return false;
    }

    public static final boolean needsSynchronization(CheckType type) {
        return needSync.contains((Object)type);
    }

    static {
        HashMap map = new HashMap();
        for (CheckType type : CheckType.values()) {
            map.put(type, new LinkedHashSet());
        }
        for (CheckType type : CheckType.values()) {
            if (type != CheckType.ALL) {
                ((Set)map.get((Object)CheckType.ALL)).add(type);
            }
            for (CheckType other : CheckType.values()) {
                if (!APIUtils.isParent(other, type)) continue;
                ((Set)map.get((Object)other)).add(type);
            }
        }
        for (CheckType parent : map.keySet()) {
            Set set = (Set)map.get((Object)parent);
            CheckType[] a = new CheckType[set.size()];
            childrenMap.put(parent, set.toArray(a));
            CheckType[] aw = new CheckType[set.size() + 1];
            set.toArray(aw);
            aw[set.size()] = parent;
            withChildrenMap.put(parent, aw);
        }
        for (CheckType checkType : new CheckType[]{CheckType.CHAT, CheckType.NET}) {
            needSync.add(checkType);
        }
        boolean added = true;
        while (added) {
            added = false;
            for (CheckType checkType : CheckType.values()) {
                if (checkType.getParent() == null || needSync.contains((Object)checkType) || !needSync.contains((Object)checkType.getParent())) continue;
                needSync.add(checkType);
                added = true;
            }
        }
    }
}

