/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class BridgeEnchant {
    private static final Enchantment DEPTH_STRIDER = BridgeEnchant.parseEnchantment("DEPTH_STRIDER");

    private static final Enchantment parseEnchantment(String name) {
        try {
            return Enchantment.getByName((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getDepthStriderLevel(Player player) {
        int level = 0;
        if (DEPTH_STRIDER != null) {
            ItemStack[] armor = player.getInventory().getArmorContents();
            for (int i = 0; i < armor.length; ++i) {
                ItemStack item = armor[i];
                if (BlockProperties.isAir(item)) continue;
                level = Math.max(item.getEnchantmentLevel(DEPTH_STRIDER), level);
            }
        }
        return Math.min(3, level);
    }

    public static boolean hasDepthStrider() {
        return DEPTH_STRIDER != null;
    }
}

