/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class KeepAliveFrequency
extends BaseAdapter {
    private final Check check = new Check(CheckType.NET_KEEPALIVEFREQUENCY){};

    public KeepAliveFrequency(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, PacketType.Play.Client.KEEP_ALIVE);
    }

    public void onPacketReceiving(PacketEvent event) {
        double vl;
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
            event.setCancelled(true);
            return;
        }
        NetData data = this.dataFactory.getData(player);
        data.lastKeepAliveTime = time;
        NetConfig cc = this.configFactory.getConfig(player);
        if (!cc.keepAliveFrequencyActive) {
            return;
        }
        data.keepAliveFreq.add(time, 1.0f);
        float first = data.keepAliveFreq.bucketScore(0);
        if (first > 1.0f && !this.check.hasBypass(player) && this.check.executeActions(player, vl = (double)Math.max(first - 1.0f, data.keepAliveFreq.score(1.0f) - (float)data.keepAliveFreq.numberOfBuckets()), 1.0, cc.keepAliveFrequencyActions)) {
            event.setCancelled(true);
        }
    }

    public void onPacketSending(PacketEvent event) {
    }
}

