/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.utilities.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetStatic {
    public static double morePacketsCheck(ActionFrequency packetFreq, long time, float packets, float maxPackets, float idealPackets, ActionFrequency burstFreq, float burstPackets, double burstDirect, double burstEPM, List<String> tags) {
        float burst;
        double fullCount;
        int burnStart;
        float sc0;
        long winDur = packetFreq.bucketDuration();
        int winNum = packetFreq.numberOfBuckets();
        long totalDur = winDur * (long)winNum;
        long tDiff = time - packetFreq.lastAccess();
        if (tDiff >= winDur && tDiff < totalDur && (sc0 = packetFreq.bucketScore(0)) > maxPackets) {
            float sci;
            sc0 -= maxPackets;
            for (int i = 1; i < winNum && (sci = packetFreq.bucketScore(i)) < maxPackets; ++i) {
                float consume = Math.min(sc0, maxPackets - sci);
                sc0 -= consume;
                packetFreq.setBucket(i, sci + consume);
                if (sci > 0.0f) break;
            }
            packetFreq.setBucket(0, maxPackets + sc0);
        }
        packetFreq.add(time, packets);
        float burnScore = idealPackets * (float)winDur / 1000.0f;
        int empty = 0;
        boolean used = false;
        for (burnStart = 1; burnStart < winNum; ++burnStart) {
            if (!(packetFreq.bucketScore(burnStart) > 0.0f)) continue;
            if (used) {
                for (int j = burnStart; j < winNum; ++j) {
                    if (packetFreq.bucketScore(j) != 0.0f) continue;
                    ++empty;
                }
                break;
            }
            used = true;
        }
        if (empty > 0) {
            float lag = TickTask.getLag(totalDur, true);
            empty = Math.min(empty, Math.round((lag - 1.0f) * (float)winNum));
        }
        if (burnStart < winNum) {
            float trailing = Math.max(packetFreq.trailingScore(burnStart, 1.0f), burnScore * (float)(winNum - burnStart - empty));
            float leading = packetFreq.leadingScore(burnStart, 1.0f);
            fullCount = leading + trailing;
        } else {
            fullCount = packetFreq.score(1.0f);
        }
        double violation = 0.0;
        double vEPSAcc = fullCount - (double)(maxPackets * (float)winNum * (float)winDur / 1000.0f);
        if (vEPSAcc > 0.0) {
            violation = Math.max(violation, vEPSAcc);
            tags.add("epsacc");
        }
        if ((burst = packetFreq.bucketScore(0)) > burstPackets && (burst /= TickTask.getLag(winDur, true)) > burstPackets) {
            double vBurstDirect = (double)burst - burstDirect;
            if (vBurstDirect > 0.0) {
                violation = Math.max(violation, vBurstDirect);
                tags.add("burstdirect");
            }
            burstFreq.add(time, 1.0f);
            double vBurstEPM = (double)burstFreq.score(0.0f) - burstEPM * (double)(burstFreq.bucketDuration() * (long)burstFreq.numberOfBuckets()) / 60000.0;
            if (vBurstEPM > 0.0) {
                violation = Math.max(violation, vBurstEPM);
                tags.add("burstepm");
            }
        }
        return Math.max(0.0, violation);
    }
}

