/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import org.bukkit.Location;

public abstract class RayTracing {
    protected double x0;
    protected double y0;
    protected double z0;
    protected double dX;
    protected double dY;
    protected double dZ;
    protected int blockX;
    protected int blockY;
    protected int blockZ;
    protected int endBlockX;
    protected int endBlockY;
    protected int endBlockZ;
    protected double oX;
    protected double oY;
    protected double oZ;
    protected double t = Double.MIN_VALUE;
    protected double tol = 0.0;
    protected boolean forceStepEndPos = true;
    protected int step = 0;
    protected boolean secondaryStep = true;
    private int maxSteps = Integer.MAX_VALUE;

    public RayTracing(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.set(x0, y0, z0, x1, y1, z1);
    }

    public RayTracing() {
        this.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public void set(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.dX = x1 - x0;
        this.dY = y1 - y0;
        this.dZ = z1 - z0;
        this.blockX = Location.locToBlock((double)x0);
        this.blockY = Location.locToBlock((double)y0);
        this.blockZ = Location.locToBlock((double)z0);
        this.endBlockX = Location.locToBlock((double)x1);
        this.endBlockY = Location.locToBlock((double)y1);
        this.endBlockZ = Location.locToBlock((double)z1);
        this.oX = x0 - (double)this.blockX;
        this.oY = y0 - (double)this.blockY;
        this.oZ = z0 - (double)this.blockZ;
        this.t = 0.0;
        this.step = 0;
    }

    private static final double tDiff(double dTotal, double offset, boolean isEndBlock) {
        if (dTotal > 0.0) {
            if (offset >= 1.0) {
                return isEndBlock ? Double.MAX_VALUE : 0.0;
            }
            return (1.0 - offset) / dTotal;
        }
        if (dTotal < 0.0) {
            if (offset <= 0.0) {
                return isEndBlock ? Double.MAX_VALUE : 0.0;
            }
            return offset / -dTotal;
        }
        return Double.MAX_VALUE;
    }

    public void loop() {
        while (this.t + this.tol < 1.0) {
            double tZ;
            double tY;
            double tX = RayTracing.tDiff(this.dX, this.oX, this.blockX == this.endBlockX);
            double tMin = Math.max(0.0, Math.min(tX, Math.min(tY = RayTracing.tDiff(this.dY, this.oY, this.blockY == this.endBlockY), tZ = RayTracing.tDiff(this.dZ, this.oZ, this.blockZ == this.endBlockZ))));
            if (tMin == Double.MAX_VALUE) {
                if (this.step >= 1) break;
                tMin = 0.0;
            }
            if (this.t + tMin > 1.0) {
                tMin = 1.0 - this.t;
            }
            ++this.step;
            if (!this.step(this.blockX, this.blockY, this.blockZ, this.oX, this.oY, this.oZ, tMin, true) || this.t + tMin + this.tol >= 1.0 && this.isEndBlock()) break;
            int transitions = 0;
            boolean transZ = false;
            boolean transY = false;
            boolean transX = false;
            if (tX == tMin && this.blockX != this.endBlockX && this.dX != 0.0) {
                transX = true;
                ++transitions;
            }
            if (tY == tMin && this.blockY != this.endBlockY && this.dY != 0.0) {
                transY = true;
                ++transitions;
            }
            if (tZ == tMin && this.blockZ != this.endBlockZ && this.dZ != 0.0) {
                transZ = true;
                ++transitions;
            }
            this.oX = Math.min(1.0, Math.max(0.0, this.oX + tMin * this.dX));
            this.oY = Math.min(1.0, Math.max(0.0, this.oY + tMin * this.dY));
            this.oZ = Math.min(1.0, Math.max(0.0, this.oZ + tMin * this.dZ));
            this.t = Math.min(1.0, this.t + tMin);
            if (transitions <= 0 || !this.handleTransitions(transitions, transX, transY, transZ, tMin)) break;
            if (this.forceStepEndPos && this.t + this.tol >= 1.0) {
                this.step(this.blockX, this.blockY, this.blockZ, this.oX, this.oY, this.oZ, 0.0, true);
                break;
            }
            if (this.step < this.maxSteps) continue;
            break;
        }
    }

    protected boolean handleTransitions(int transitions, boolean transX, boolean transY, boolean transZ, double tMin) {
        if (transitions > 1 && this.secondaryStep && !this.handleSecondaryTransitions(transitions, transX, transY, transZ, tMin)) {
            return false;
        }
        double tcMin = 1.0;
        if (transX) {
            if (this.dX > 0.0) {
                ++this.blockX;
                this.oX = 0.0;
                tcMin = Math.min(tcMin, ((double)this.blockX - this.x0) / this.dX);
            } else {
                --this.blockX;
                this.oX = 1.0;
                tcMin = Math.min(tcMin, (1.0 + (double)this.blockX - this.x0) / this.dX);
            }
        }
        if (transY) {
            if (this.dY > 0.0) {
                ++this.blockY;
                this.oY = 0.0;
                tcMin = Math.min(tcMin, ((double)this.blockY - this.y0) / this.dY);
            } else {
                --this.blockY;
                this.oY = 1.0;
                tcMin = Math.min(tcMin, (1.0 + (double)this.blockY - this.y0) / this.dY);
            }
        }
        if (transZ) {
            if (this.dZ > 0.0) {
                ++this.blockZ;
                this.oZ = 0.0;
                tcMin = Math.min(tcMin, ((double)this.blockZ - this.z0) / this.dZ);
            } else {
                --this.blockZ;
                this.oZ = 1.0;
                tcMin = Math.min(tcMin, (1.0 + (double)this.blockZ - this.z0) / this.dZ);
            }
        }
        this.oX = this.x0 + tcMin * this.dX - (double)this.blockX;
        this.oY = this.y0 + tcMin * this.dY - (double)this.blockY;
        this.oZ = this.z0 + tcMin * this.dZ - (double)this.blockZ;
        this.t = tcMin;
        return true;
    }

    protected boolean handleSecondaryTransitions(int transitions, boolean transX, boolean transY, boolean transZ, double tMin) {
        if (transX && !this.step(this.blockX + (this.dX > 0.0 ? 1 : -1), this.blockY, this.blockZ, this.dX > 0.0 ? 0.0 : 1.0, this.oY, this.oZ, 0.0, false)) {
            return false;
        }
        if (transY && !this.step(this.blockX, this.blockY + (this.dY > 0.0 ? 1 : -1), this.blockZ, this.oX, this.dY > 0.0 ? 0.0 : 1.0, this.oZ, 0.0, false)) {
            return false;
        }
        if (transZ && !this.step(this.blockX, this.blockY, this.blockZ + (this.dZ > 0.0 ? 1 : -1), this.oX, this.oY, this.dZ > 0.0 ? 0.0 : 1.0, 0.0, false)) {
            return false;
        }
        return transitions != 3 || this.handleSecondaryDoubleTransitions(transitions, transX, transY, transZ, tMin);
    }

    protected boolean handleSecondaryDoubleTransitions(int transitions, boolean transX, boolean transY, boolean transZ, double tMin) {
        if (!this.step(this.blockX + (this.dX > 0.0 ? 1 : -1), this.blockY + (this.dY > 0.0 ? 1 : -1), this.blockZ, this.dX > 0.0 ? 0.0 : 1.0, this.dY > 0.0 ? 0.0 : 1.0, this.oZ, 0.0, false)) {
            return false;
        }
        if (!this.step(this.blockX + (this.dX > 0.0 ? 1 : -1), this.blockY, this.blockZ + (this.dZ > 0.0 ? 1 : -1), this.dX > 0.0 ? 0.0 : 1.0, this.oY, this.dZ > 0.0 ? 0.0 : 1.0, 0.0, false)) {
            return false;
        }
        return this.step(this.blockX, this.blockY + (this.dY > 0.0 ? 1 : -1), this.blockZ + (this.dZ > 0.0 ? 1 : -1), this.oX, this.dY > 0.0 ? 0.0 : 1.0, this.dZ > 0.0 ? 0.0 : 1.0, 0.0, false);
    }

    public boolean collides() {
        return false;
    }

    public boolean isEndBlock() {
        return this.blockX == this.endBlockX && this.blockY == this.endBlockY && this.blockZ == this.endBlockZ;
    }

    public int getStepsDone() {
        return this.step;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    protected abstract boolean step(int var1, int var2, int var3, double var4, double var6, double var8, double var10, boolean var12);
}

