/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.details;

import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.LoggerID;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.logging.details.ContentLogger;
import fr.neatmonster.nocheatplus.logging.details.ContentStream;
import fr.neatmonster.nocheatplus.logging.details.DefaultContentStream;
import fr.neatmonster.nocheatplus.logging.details.FileLoggerAdapter;
import fr.neatmonster.nocheatplus.logging.details.LogNode;
import fr.neatmonster.nocheatplus.logging.details.LogNodeDispatcher;
import fr.neatmonster.nocheatplus.logging.details.LogOptions;
import fr.neatmonster.nocheatplus.logging.details.LoggerAdapter;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLogManager
implements LogManager {
    private final LogNodeDispatcher dispatcher;
    private final String defaultPrefix;
    private Map<StreamID, ContentStream<String>> idStreamMap = new IdentityHashMap<StreamID, ContentStream<String>>();
    private Map<String, ContentStream<String>> nameStreamMap = new HashMap<String, ContentStream<String>>();
    private Map<String, StreamID> nameStreamIDMap = new HashMap<String, StreamID>();
    private Map<LoggerID, LogNode<String>> idNodeMap = new IdentityHashMap<LoggerID, LogNode<String>>();
    private Map<String, LogNode<String>> nameNodeMap = new HashMap<String, LogNode<String>>();
    private Map<String, LoggerID> nameLoggerIDMap = new HashMap<String, LoggerID>();
    protected final Object registryCOWLock = new Object();
    private final StreamID initStreamID;
    private final StreamID voidStreamID;
    private StreamID fallBackStreamID = this.voidStreamID = new StreamID("void");
    protected final ContentLogger<String> initLogger = new ContentLogger<String>(){

        @Override
        public void log(Level level, String content) {
            AbstractLogManager.this.log(AbstractLogManager.this.getInitStreamID(), level, content);
        }
    };

    public AbstractLogManager(LogNodeDispatcher dispatcher, String defaultPrefix, StreamID initStreamID) {
        this.dispatcher = dispatcher;
        this.defaultPrefix = defaultPrefix;
        this.initStreamID = initStreamID;
        this.createInitStream();
        this.registerInitLogger();
        dispatcher.setInitLogger(this.initLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createInitStream() {
        Object object = this.registryCOWLock;
        synchronized (object) {
            if (!this.hasStream(this.initStreamID)) {
                this.createStringStream(this.initStreamID);
            }
        }
    }

    protected abstract void registerInitLogger();

    protected LogNodeDispatcher getLogNodeDispatcher() {
        return this.dispatcher;
    }

    @Override
    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    @Override
    public StreamID getInitStreamID() {
        return this.initStreamID;
    }

    @Override
    public StreamID getVoidStreamID() {
        return this.voidStreamID;
    }

    @Override
    public StreamID getStreamID(String name) {
        return this.nameStreamIDMap.get(name.toLowerCase());
    }

    @Override
    public LoggerID getLoggerID(String name) {
        return this.nameLoggerIDMap.get(name.toLowerCase());
    }

    @Override
    public void debug(StreamID streamID, String message) {
        this.log(streamID, Level.FINE, message);
    }

    @Override
    public void info(StreamID streamID, String message) {
        this.log(streamID, Level.INFO, message);
    }

    @Override
    public void warning(StreamID streamID, String message) {
        this.log(streamID, Level.WARNING, message);
    }

    @Override
    public void severe(StreamID streamID, String message) {
        this.log(streamID, Level.SEVERE, message);
    }

    @Override
    public void log(StreamID streamID, Level level, String message) {
        if (streamID != this.voidStreamID) {
            ContentStream<String> stream = this.idStreamMap.get(streamID);
            if (stream != null) {
                stream.log(level, message);
            } else {
                this.handleFallBack(streamID, level, message);
            }
        }
    }

    private void handleFallBack(StreamID streamID, Level level, String message) {
        if (this.fallBackStreamID == null || streamID == this.fallBackStreamID) {
            throw new RuntimeException("Stream not registered: " + streamID);
        }
        this.log(this.fallBackStreamID, level, message);
    }

    @Override
    public void debug(StreamID streamID, Throwable t) {
        this.log(streamID, Level.FINE, t);
    }

    @Override
    public void info(StreamID streamID, Throwable t) {
        this.log(streamID, Level.INFO, t);
    }

    @Override
    public void warning(StreamID streamID, Throwable t) {
        this.log(streamID, Level.WARNING, t);
    }

    @Override
    public void severe(StreamID streamID, Throwable t) {
        this.log(streamID, Level.SEVERE, t);
    }

    @Override
    public void log(StreamID streamID, Level level, Throwable t) {
        this.log(streamID, level, StringUtil.throwableToString(t));
    }

    @Override
    public boolean hasStream(StreamID streamID) {
        return this.idStreamMap.containsKey(streamID) || this.nameStreamMap.containsKey(streamID.name.toLowerCase());
    }

    @Override
    public boolean hasStream(String name) {
        return this.getStreamID(name) != null;
    }

    private void testRegisterStream(StreamID streamID) {
        if (streamID == null) {
            throw new NullPointerException("StreamID must not be null.");
        }
        if (streamID.name == null) {
            throw new NullPointerException("StreamID.name must not be null.");
        }
        if (streamID.name.equalsIgnoreCase(this.voidStreamID.name)) {
            throw new RuntimeException("Can not overrite void StreamID.");
        }
        if (this.hasStream(streamID)) {
            throw new IllegalArgumentException("Stream already registered: " + streamID.name.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentStream<String> createStringStream(StreamID streamID) {
        DefaultContentStream<String> stream;
        Object object = this.registryCOWLock;
        synchronized (object) {
            this.testRegisterStream(streamID);
            IdentityHashMap<StreamID, ContentStream<String>> idStreamMap = new IdentityHashMap<StreamID, ContentStream<String>>(this.idStreamMap);
            HashMap<String, ContentStream<String>> nameStreamMap = new HashMap<String, ContentStream<String>>(this.nameStreamMap);
            HashMap<String, StreamID> nameStreamIDMap = new HashMap<String, StreamID>(this.nameStreamIDMap);
            stream = new DefaultContentStream<String>(this.dispatcher);
            idStreamMap.put(streamID, stream);
            nameStreamMap.put(streamID.name.toLowerCase(), stream);
            nameStreamIDMap.put(streamID.name.toLowerCase(), streamID);
            this.idStreamMap = idStreamMap;
            this.nameStreamMap = nameStreamMap;
            this.nameStreamIDMap = nameStreamIDMap;
        }
        return stream;
    }

    @Override
    public boolean hasLogger(LoggerID loggerID) {
        return this.idNodeMap.containsKey(loggerID) || this.nameNodeMap.containsKey(loggerID.name.toLowerCase());
    }

    @Override
    public boolean hasLogger(String name) {
        return this.getLoggerID(name) != null;
    }

    private void testRegisterLogger(LoggerID loggerID) {
        if (loggerID == null) {
            throw new NullPointerException("LoggerID must not be null.");
        }
        if (loggerID.name == null) {
            throw new NullPointerException("LoggerID.name must not be null.");
        }
        if (this.hasLogger(loggerID)) {
            throw new IllegalArgumentException("Logger already registered: " + loggerID.name.toLowerCase());
        }
    }

    protected LoggerID registerStringLogger(ContentLogger<String> logger, LogOptions options) {
        LoggerID loggerID = new LoggerID(options.name);
        this.registerStringLogger(loggerID, logger, options);
        return loggerID;
    }

    protected LoggerID registerStringLogger(Logger logger, LogOptions options) {
        LoggerID loggerID = new LoggerID(options.name);
        this.registerStringLogger(loggerID, logger, options);
        return loggerID;
    }

    protected LoggerID registerStringLogger(File file, LogOptions options) {
        LoggerID loggerID = new LoggerID(options.name);
        this.registerStringLogger(loggerID, file, options);
        return loggerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogNode<String> registerStringLogger(LoggerID loggerID, ContentLogger<String> logger, LogOptions options) {
        LogNode<String> node;
        Object object = this.registryCOWLock;
        synchronized (object) {
            this.testRegisterLogger(loggerID);
            IdentityHashMap<LoggerID, LogNode<String>> idNodeMap = new IdentityHashMap<LoggerID, LogNode<String>>(this.idNodeMap);
            HashMap<String, LogNode<String>> nameNodeMap = new HashMap<String, LogNode<String>>(this.nameNodeMap);
            HashMap<String, LoggerID> nameLoggerIDMap = new HashMap<String, LoggerID>(this.nameLoggerIDMap);
            node = new LogNode<String>(loggerID, logger, options);
            idNodeMap.put(loggerID, node);
            nameNodeMap.put(loggerID.name.toLowerCase(), node);
            nameLoggerIDMap.put(loggerID.name.toLowerCase(), loggerID);
            this.idNodeMap = idNodeMap;
            this.nameNodeMap = nameNodeMap;
            this.nameLoggerIDMap = nameLoggerIDMap;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogNode<String> registerStringLogger(LoggerID loggerID, Logger logger, LogOptions options) {
        LogNode<String> node;
        Object object = this.registryCOWLock;
        synchronized (object) {
            LoggerAdapter adapter = new LoggerAdapter(logger);
            node = this.registerStringLogger(loggerID, adapter, options);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogNode<String> registerStringLogger(LoggerID loggerID, File file, LogOptions options) {
        LogNode<String> node;
        Object object = this.registryCOWLock;
        synchronized (object) {
            this.testRegisterLogger(loggerID);
            FileLoggerAdapter adapter = new FileLoggerAdapter(file);
            if (adapter.isInoperable()) {
                adapter.detachLogger();
                throw new RuntimeException("Failed to set up file logger for id '" + loggerID + "': " + file);
            }
            try {
                node = this.registerStringLogger(loggerID, adapter, options);
            }
            catch (Exception ex) {
                adapter.detachLogger();
                throw new RuntimeException(ex);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachStringLogger(LoggerID loggerID, StreamID streamID) {
        Object object = this.registryCOWLock;
        synchronized (object) {
            if (!this.hasLogger(loggerID)) {
                throw new RuntimeException("Logger is not registered: " + loggerID);
            }
            if (!this.hasStream(streamID)) {
                throw new RuntimeException("Stream is not registered: " + streamID);
            }
            LogNode<String> node = this.idNodeMap.get(loggerID);
            if (streamID == this.initStreamID) {
                switch (node.options.callContext) {
                    case PRIMARY_THREAD_ONLY: 
                    case ANY_THREAD_DIRECT: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported call context for init stream " + streamID + ": " + (Object)((Object)node.options.callContext));
                    }
                }
            }
            this.idStreamMap.get(streamID).addNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear(long msWaitFlush, boolean recreateInitLogger) {
        Object object = this.registryCOWLock;
        synchronized (object) {
            for (ContentStream<String> contentStream : this.idStreamMap.values()) {
                contentStream.clear();
            }
            this.dispatcher.flush(msWaitFlush);
            for (LogNode logNode : this.idNodeMap.values()) {
                if (!(logNode.logger instanceof FileLoggerAdapter)) continue;
                FileLoggerAdapter logger = (FileLoggerAdapter)logNode.logger;
                logger.flush();
                logger.detachLogger();
            }
            this.idNodeMap = new IdentityHashMap<LoggerID, LogNode<String>>();
            this.nameNodeMap = new HashMap<String, LogNode<String>>();
            this.nameLoggerIDMap = new HashMap<String, LoggerID>();
            this.idStreamMap = new IdentityHashMap<StreamID, ContentStream<String>>();
            this.nameStreamMap = new HashMap<String, ContentStream<String>>();
            this.nameStreamIDMap = new HashMap<String, StreamID>();
            if (recreateInitLogger) {
                this.createInitStream();
                this.registerInitLogger();
                if (this.fallBackStreamID != null && this.fallBackStreamID != this.voidStreamID) {
                    this.fallBackStreamID = this.initStreamID;
                }
            } else if (this.fallBackStreamID != null) {
                this.fallBackStreamID = this.voidStreamID;
            }
        }
    }

    public void shutdown() {
        this.clear(500L, false);
    }
}

