/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.debug;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class DebugUtil {
    public static String formatLocation(Location loc) {
        StringBuilder b = new StringBuilder(128);
        DebugUtil.addLocation(loc, b);
        return b.toString();
    }

    public static String formatMove(Location from, Location to) {
        StringBuilder builder = new StringBuilder(128);
        DebugUtil.addMove(from, to, null, builder);
        return builder.toString();
    }

    public static void addLocation(double x, double y, double z, StringBuilder builder) {
        builder.append(x + ", " + y + ", " + z);
    }

    public static void addLocation(Location loc, StringBuilder builder) {
        DebugUtil.addLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addLocation(PlayerLocation loc, StringBuilder builder) {
        DebugUtil.addLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addFormattedLocation(double x, double y, double z, StringBuilder builder) {
        builder.append(StringUtil.fdec3.format(x) + ", " + StringUtil.fdec3.format(y) + ", " + StringUtil.fdec3.format(z));
    }

    public static void addFormattedLocation(Location loc, StringBuilder builder) {
        DebugUtil.addFormattedLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addFormattedLocation(PlayerLocation loc, StringBuilder builder) {
        DebugUtil.addFormattedLocation(loc.getX(), loc.getY(), loc.getZ(), builder);
    }

    public static void addMove(double fromX, double fromY, double fromZ, double toX, double toY, double toZ, StringBuilder builder) {
        builder.append("from: ");
        DebugUtil.addLocation(fromX, fromY, fromZ, builder);
        builder.append("\nto: ");
        DebugUtil.addLocation(toX, toY, toZ, builder);
    }

    public static void addFormattedMove(double fromX, double fromY, double fromZ, double toX, double toY, double toZ, StringBuilder builder) {
        DebugUtil.addFormattedLocation(fromX, fromY, fromZ, builder);
        builder.append(" -> ");
        DebugUtil.addFormattedLocation(toX, toY, toZ, builder);
    }

    public static void addFormattedMove(PlayerLocation from, PlayerLocation to, Location loc, StringBuilder builder) {
        if (loc != null && !from.isSamePos(loc)) {
            builder.append("(");
            DebugUtil.addFormattedLocation(loc, builder);
            builder.append(") ");
        }
        DebugUtil.addFormattedMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addMove(PlayerLocation from, PlayerLocation to, Location loc, StringBuilder builder) {
        if (loc != null && !from.isSamePos(loc)) {
            builder.append("Location: ");
            DebugUtil.addLocation(loc, builder);
            builder.append("\n");
        }
        DebugUtil.addMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addFormattedMove(Location from, Location to, Location loc, StringBuilder builder) {
        if (loc != null && !TrigUtil.isSamePos(from, loc)) {
            builder.append("(");
            DebugUtil.addFormattedLocation(loc, builder);
            builder.append(") ");
        }
        DebugUtil.addFormattedMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void addMove(Location from, Location to, Location loc, StringBuilder builder) {
        if (loc != null && !TrigUtil.isSamePos(from, loc)) {
            builder.append("Location: ");
            DebugUtil.addLocation(loc, builder);
            builder.append("\n");
        }
        DebugUtil.addMove(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), builder);
    }

    public static void outputMoveDebug(Player player, PlayerLocation from, PlayerLocation to, double maxYOnGround, MCAccess mcAccess) {
        double slow;
        StringBuilder builder = new StringBuilder(250);
        Location loc = player.getLocation();
        if (BuildParameters.debugLevel > 0) {
            builder.append("\n-------------- MOVE --------------\n");
            builder.append(player.getName() + " " + from.getWorld().getName() + ":\n");
            DebugUtil.addMove(from, to, loc, builder);
        } else {
            builder.append(player.getName() + " " + from.getWorld().getName() + " ");
            DebugUtil.addFormattedMove(from, to, loc, builder);
        }
        double jump = mcAccess.getJumpAmplifier(player);
        double speed = mcAccess.getFasterMovementAmplifier(player);
        double strider = BridgeEnchant.getDepthStriderLevel(player);
        if (BuildParameters.debugLevel > 0) {
            Vector v;
            try {
                builder.append("\n(walkspeed=" + player.getWalkSpeed() + " flyspeed=" + player.getFlySpeed() + ")");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (player.isSprinting()) {
                builder.append("(sprinting)");
            }
            if (player.isSneaking()) {
                builder.append("(sneaking)");
            }
            if (player.isBlocking()) {
                builder.append("(blocking)");
            }
            if ((v = player.getVelocity()).lengthSquared() > 0.0) {
                builder.append("(svel=" + v.getX() + "," + v.getY() + "," + v.getZ() + ")");
            }
        }
        if (speed != Double.NEGATIVE_INFINITY) {
            builder.append("(e_speed=" + (speed + 1.0) + ")");
        }
        if ((slow = PotionUtil.getPotionEffectAmplifier(player, PotionEffectType.SLOW)) != Double.NEGATIVE_INFINITY) {
            builder.append("(e_slow=" + (slow + 1.0) + ")");
        }
        if (jump != Double.NEGATIVE_INFINITY) {
            builder.append("(e_jump=" + (jump + 1.0) + ")");
        }
        if (strider != 0.0) {
            builder.append("(e_depth_strider=" + strider + ")");
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        if (BuildParameters.debugLevel > 0) {
            builder.setLength(0);
            from.collectBlockFlags(maxYOnGround);
            if (from.getBlockFlags() != 0L) {
                builder.append("\nfrom flags: " + StringUtil.join(BlockProperties.getFlagNames(from.getBlockFlags()), "+"));
            }
            if (from.getTypeId() != 0) {
                DebugUtil.addBlockInfo(builder, from, "\nfrom");
            }
            if (from.getTypeIdBelow() != 0) {
                DebugUtil.addBlockBelowInfo(builder, from, "\nfrom");
            }
            if (!from.isOnGround() && from.isOnGround(0.5)) {
                builder.append(" (ground within 0.5)");
            }
            to.collectBlockFlags(maxYOnGround);
            if (to.getBlockFlags() != 0L) {
                builder.append("\nto flags: " + StringUtil.join(BlockProperties.getFlagNames(to.getBlockFlags()), "+"));
            }
            if (to.getTypeId() != 0) {
                DebugUtil.addBlockInfo(builder, to, "\nto");
            }
            if (to.getTypeIdBelow() != 0) {
                DebugUtil.addBlockBelowInfo(builder, to, "\nto");
            }
            if (!to.isOnGround() && to.isOnGround(0.5)) {
                builder.append(" (ground within 0.5)");
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        }
    }

    public static void addBlockBelowInfo(StringBuilder builder, PlayerLocation loc, String tag) {
        builder.append(tag + " below id=" + loc.getTypeIdBelow() + " data=" + loc.getData(loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ()) + " shape=" + Arrays.toString(loc.getBlockCache().getBounds(loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ())));
    }

    public static void addBlockInfo(StringBuilder builder, PlayerLocation loc, String tag) {
        builder.append(tag + " id=" + loc.getTypeId() + " data=" + loc.getData() + " shape=" + Arrays.toString(loc.getBlockCache().getBounds(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())));
    }

    public static void outputDebugVehicleMove(Player player, Entity vehicle, Location from, Location to, boolean fake) {
        boolean wrongVehicle;
        StringBuilder builder = new StringBuilder(250);
        Location vLoc = vehicle.getLocation();
        Location loc = player.getLocation();
        Entity actualVehicle = player.getVehicle();
        boolean bl = wrongVehicle = actualVehicle == null || actualVehicle.getEntityId() != vehicle.getEntityId();
        if (BuildParameters.debugLevel > 0) {
            builder.append("\n-------------- VEHICLE MOVE " + (fake ? "(fake)" : "") + "--------------\n");
            builder.append(player.getName() + " " + from.getWorld().getName() + ":\n");
            DebugUtil.addMove(from, to, null, builder);
            builder.append("\n Vehicle: ");
            DebugUtil.addLocation(vLoc, builder);
            builder.append("\n Player: ");
            DebugUtil.addLocation(loc, builder);
        } else {
            builder.append(player.getName() + " " + from.getWorld().getName() + "veh." + (fake ? "(fake)" : "") + " ");
            DebugUtil.addFormattedMove(from, to, null, builder);
            builder.append("\n Vehicle: ");
            DebugUtil.addFormattedLocation(vLoc, builder);
            builder.append(" Player: ");
            DebugUtil.addFormattedLocation(loc, builder);
        }
        builder.append("\n Vehicle type: " + vehicle.getType() + (wrongVehicle ? (actualVehicle == null ? " (exited?)" : " actual: " + actualVehicle.getType()) : ""));
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }

    public static String toJava(double[] doubles) {
        StringBuilder builder = new StringBuilder(20 + doubles.length * 20);
        DebugUtil.toJava(doubles, builder);
        return builder.toString();
    }

    public static void toJava(double[] doubles, StringBuilder builder) {
        if (doubles == null) {
            builder.append("null");
            return;
        }
        builder.append("new double[] {");
        if (doubles.length > 0) {
            builder.append(doubles[0]);
        }
        for (int i = 1; i < doubles.length; ++i) {
            builder.append(", " + doubles[i]);
        }
        builder.append("}");
    }
}

