/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components;

import fr.neatmonster.nocheatplus.components.PermStateReceiver;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSetPermState
implements PermStateReceiver {
    protected final HashMap<String, Set<String>> playerSets = new HashMap();
    protected String[] defaultPermissions;

    public NameSetPermState(String ... permissions) {
        this.defaultPermissions = permissions;
    }

    @Override
    public String[] getDefaultPermissions() {
        return this.defaultPermissions;
    }

    @Override
    public boolean hasPermission(String player, String permission) {
        Set<String> names = this.playerSets.get(permission);
        if (names == null) {
            return false;
        }
        return names.contains(player);
    }

    @Override
    public void setPermission(String player, String permission, boolean state) {
        Set<String> names = this.playerSets.get(permission);
        if (names == null) {
            if (!state) {
                return;
            }
            names = new LinkedHashSet<String>(20);
            this.playerSets.put(permission, names);
        }
        if (state) {
            names.add(player);
        } else {
            names.remove(player);
        }
    }

    @Override
    public void removePlayer(String player) {
        Iterator<Map.Entry<String, Set<String>>> it = this.playerSets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Set<String>> entry = it.next();
            Set<String> set = entry.getValue();
            set.remove(player);
            if (!set.isEmpty()) continue;
            it.remove();
        }
    }

    public Set<String> getPlayers(String permission) {
        return this.playerSets.get(permission);
    }

    public void addDefaultPermissions(Collection<String> permissions) {
        HashSet<String> newDefaults = new HashSet<String>();
        newDefaults.addAll(Arrays.asList(this.defaultPermissions));
        newDefaults.addAll(permissions);
    }

    public void setDefaultPermissions(Collection<String> permissions) {
        this.defaultPermissions = new String[permissions.size()];
        permissions.toArray(this.defaultPermissions);
    }
}

