/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cbreflect;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.bukkit.BlockCacheBukkit;
import fr.neatmonster.nocheatplus.compat.bukkit.MCAccessBukkitBase;
import fr.neatmonster.nocheatplus.compat.cbreflect.BlockCacheCBReflect;
import fr.neatmonster.nocheatplus.compat.cbreflect.reflect.ReflectHelper;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class MCAccessCBReflect
extends MCAccessBukkitBase {
    protected final ReflectHelper helper = new ReflectHelper();
    protected final boolean knownSupportedVersion;
    protected final boolean dealFallDamageFiresAnEvent;

    public MCAccessCBReflect() throws ReflectHelper.ReflectFailureException {
        String mcVersion = ServerVersion.getMinecraftVersion();
        if (mcVersion == "unknown") {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, "[NoCheatPlus] The Minecraft version could not be detected, Compat-CB-Reflect might or might not work.");
            this.knownSupportedVersion = false;
        } else if (ServerVersion.compareVersions(mcVersion, "1.4.5") < 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, "[NoCheatPlus] The Minecraft version seems to be older than what Compat-CB-Reflect can support.");
            this.knownSupportedVersion = false;
        } else if (ServerVersion.compareVersions(mcVersion, "1.9") >= 0) {
            this.knownSupportedVersion = false;
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.INIT, "[NoCheatPlus] The Minecraft version seems to be more recent than the one Compat-CB-Reflect has been built with - this might work, but there could be incompatibilities.");
        } else {
            this.knownSupportedVersion = true;
        }
        this.dealFallDamageFiresAnEvent = mcVersion != "unknown" && ServerVersion.compareVersions(mcVersion, "1.8") >= 0;
    }

    public String getMCVersion() {
        return "1.4.5-1.8.8|?";
    }

    public String getServerVersionTag() {
        return "CB-Reflect";
    }

    public BlockCache getBlockCache(World world) {
        try {
            return new BlockCacheCBReflect(this.helper, world);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return new BlockCacheBukkit(world);
        }
    }

    public boolean shouldBeZombie(Player player) {
        try {
            Object handle = this.helper.getHandle(player);
            return !this.helper.nmsPlayer_dead(handle) && this.helper.nmsPlayer_getHealth(handle) <= 0.0;
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.shouldBeZombie(player);
        }
    }

    public void setDead(Player player, int deathTicks) {
        try {
            Object handle = this.helper.getHandle(player);
            this.helper.nmsPlayer_dead(handle, true);
            this.helper.nmsPlayer_deathTicks(handle, deathTicks);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            super.setDead(player, deathTicks);
        }
    }

    public AlmostBoolean dealFallDamageFiresAnEvent() {
        if (!this.dealFallDamageFiresAnEvent) {
            return AlmostBoolean.NO;
        }
        return AlmostBoolean.match(this.helper.canDealFallDamage());
    }

    public void dealFallDamage(Player player, double damage) {
        try {
            this.helper.dealFallDamage(player, damage);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            super.dealFallDamage(player, damage);
        }
    }

    public int getInvulnerableTicks(Player player) {
        try {
            return this.helper.getInvulnerableTicks(player);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.getInvulnerableTicks(player);
        }
    }

    public void setInvulnerableTicks(Player player, int ticks) {
        try {
            this.helper.setInvulnerableTicks(player, ticks);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            super.setInvulnerableTicks(player, ticks);
        }
    }

    public double getSpeedAttributeMultiplier(Player player) {
        try {
            return this.helper.getSpeedAttributeMultiplier(player, true);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.getSpeedAttributeMultiplier(player);
        }
    }

    public double getSprintAttributeMultiplier(Player player) {
        try {
            return this.helper.getSprintAttributeMultiplier(player);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.getSprintAttributeMultiplier(player);
        }
    }

    public AlmostBoolean isBlockSolid(int id) {
        try {
            return this.helper.isBlockSolid(id);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.isBlockSolid(id);
        }
    }

    public AlmostBoolean isBlockLiquid(int id) {
        try {
            return this.helper.isBlockLiquid(id);
        }
        catch (ReflectHelper.ReflectFailureException ex) {
            return super.isBlockLiquid(id);
        }
    }
}

