/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cb3043;

import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.cb3043.BlockCacheCB3043;
import fr.neatmonster.nocheatplus.utilities.AttribUtil;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import net.minecraft.server.v1_7_R3.AttributeInstance;
import net.minecraft.server.v1_7_R3.AttributeModifier;
import net.minecraft.server.v1_7_R3.AxisAlignedBB;
import net.minecraft.server.v1_7_R3.Block;
import net.minecraft.server.v1_7_R3.DamageSource;
import net.minecraft.server.v1_7_R3.Entity;
import net.minecraft.server.v1_7_R3.EntityComplexPart;
import net.minecraft.server.v1_7_R3.EntityPlayer;
import net.minecraft.server.v1_7_R3.GenericAttributes;
import net.minecraft.server.v1_7_R3.MobEffectList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.craftbukkit.v1_7_R3.CraftServer;
import org.bukkit.craftbukkit.v1_7_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_7_R3.entity.CraftPlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCAccessCB3043
implements MCAccess {
    public MCAccessCB3043() {
        this.getCommandMap();
        ReflectionUtil.checkMembers("net.minecraft.server.v1_7_R3.", new String[][]{{"Entity", "dead"}});
        ReflectionUtil.checkMethodReturnTypesNoArgs(Block.class, new String[]{"x", "y", "z", "A", "B", "C"}, Double.TYPE);
    }

    public String getMCVersion() {
        return "1.7.8|1.7.9";
    }

    public String getServerVersionTag() {
        return "CB3043";
    }

    public CommandMap getCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public BlockCache getBlockCache(World world) {
        return new BlockCacheCB3043(world);
    }

    public double getHeight(org.bukkit.entity.Entity entity) {
        Entity mcEntity = ((CraftEntity)entity).getHandle();
        double entityHeight = Math.max((double)mcEntity.length, Math.max((double)mcEntity.height, mcEntity.boundingBox.e - mcEntity.boundingBox.b));
        if (entity instanceof LivingEntity) {
            return Math.max(((LivingEntity)entity).getEyeHeight(), entityHeight);
        }
        return entityHeight;
    }

    public AlmostBoolean isBlockSolid(int id) {
        Block block = Block.e((int)id);
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isSolid());
    }

    public AlmostBoolean isBlockLiquid(int id) {
        Block block = Block.e((int)id);
        if (block == null || block.getMaterial() == null) {
            return AlmostBoolean.MAYBE;
        }
        return AlmostBoolean.match(block.getMaterial().isLiquid());
    }

    public double getWidth(org.bukkit.entity.Entity entity) {
        return ((CraftEntity)entity).getHandle().width;
    }

    public AlmostBoolean isIllegalBounds(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.dead) {
            return AlmostBoolean.NO;
        }
        AxisAlignedBB box = entityPlayer.boundingBox;
        if (!entityPlayer.isSleeping()) {
            double dY = Math.abs(box.e - box.b);
            if (dY > 1.8) {
                return AlmostBoolean.YES;
            }
            if (dY < 0.1 && (double)entityPlayer.length >= 0.1) {
                return AlmostBoolean.YES;
            }
        }
        return AlmostBoolean.MAYBE;
    }

    public double getJumpAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.JUMP)) {
            return mcPlayer.getEffect(MobEffectList.JUMP).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getFasterMovementAmplifier(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        if (mcPlayer.hasEffect(MobEffectList.FASTER_MOVEMENT)) {
            return mcPlayer.getEffect(MobEffectList.FASTER_MOVEMENT).getAmplifier();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getSpeedAttributeMultiplier(Player player) {
        AttributeInstance attr = ((CraftLivingEntity)player).getHandle().getAttributeInstance(GenericAttributes.d);
        double val = attr.getValue() / attr.b();
        AttributeModifier mod = attr.a(AttribUtil.ID_SPRINT_BOOST);
        if (mod == null) {
            return val;
        }
        return val / AttribUtil.getMultiplier(mod.c(), mod.d());
    }

    public double getSprintAttributeMultiplier(Player player) {
        AttributeModifier mod = ((CraftLivingEntity)player).getHandle().getAttributeInstance(GenericAttributes.d).a(AttribUtil.ID_SPRINT_BOOST);
        if (mod == null) {
            return 1.0;
        }
        return AttribUtil.getMultiplier(mod.c(), mod.d());
    }

    public int getInvulnerableTicks(Player player) {
        return ((CraftPlayer)player).getHandle().invulnerableTicks;
    }

    public void setInvulnerableTicks(Player player, int ticks) {
        ((CraftPlayer)player).getHandle().invulnerableTicks = ticks;
    }

    public void dealFallDamage(Player player, double damage) {
        ((CraftPlayer)player).getHandle().damageEntity(DamageSource.FALL, (float)damage);
    }

    public boolean isComplexPart(org.bukkit.entity.Entity entity) {
        return ((CraftEntity)entity).getHandle() instanceof EntityComplexPart;
    }

    public boolean shouldBeZombie(Player player) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        return !mcPlayer.dead && mcPlayer.getHealth() <= 0.0f;
    }

    public void setDead(Player player, int deathTicks) {
        EntityPlayer mcPlayer = ((CraftPlayer)player).getHandle();
        mcPlayer.deathTicks = deathTicks;
        mcPlayer.dead = true;
    }

    public boolean hasGravity(Material mat) {
        return mat.hasGravity();
    }

    public AlmostBoolean dealFallDamageFiresAnEvent() {
        return AlmostBoolean.MAYBE;
    }
}

